#ifndef _SCOREGROUP_H_
#define _SCOREGROUP_H_

#include "scoreObject.h"
#include "position.h"
#include "table.h"

class Note;
class Part;
class ScoreElement;
class PrScoreEditor;

/** A ScoreGroup consists of ScoreElements, which are ScoreChords and ScoreBreaks
 */

class ScoreGroup : public ScoreObject
{
 private:
  Table          _elements;
  short int      _tuplet;
  short int      _chords;
  struct GroupInitState * state;

  void create(Note*, long, int);

 public:
  ScoreGroup();
  ~ScoreGroup();
  void add(Note * note, Position pos, long dur, int dis, bool _no_overlap);
  short int tuplet() const { return _tuplet; }

  /** returns the number of chords with flags to be drawn!
   */
  short int numberOfChords() const { return _chords; }

  /** returns true, if there is only one chord with flags within this group
   */
  bool single() const { return (_chords==1); }

  virtual const Position & start() const;
  virtual long end() const;
  virtual long duration() const;
  virtual int display() const;
  virtual void paint(PrScoreEditor * ed, int x=0, int y=0, int style=0);
  virtual void print(PrScoreEditor * ed, int x=0, int y=0);

  virtual ostream & print(int,ostream&) const;
  virtual void flush(const char*) const;
  virtual Element * copy() const;

};


#endif

