#ifndef _PLAYER_H_
#define _PLAYER_H_


class DeviceManager;
class Song;
class Part;
class PrProgress;
class SongIterator;

class AlsaManager;

#define MAXDEVNUM 16
#define TIMERINTERVALL 1000.0

enum { KMID, ARTS, ALSA };

class Player
{
  friend class Track;

 private:
  Song * _song;
  DeviceManager * devman;
  int devnum;
  char * devices[MAXDEVNUM];
  long oldTimePos;
  bool needSync;
  bool _playing;
  void init();
  void wait(long,long);
  void mergeQueue();

 public:
  Player();
  Player(Song*);
  ~Player();
  const char * device(int i);
  int devicenum();
  void play(PrProgress * progress = 0, Part * part=0, long left = 0, long right = 0, bool cycl = false, int record_track = -1);
  void hit(int out, int ch, int freq, int vol);
  void quad(int out, int ch, int freq1, int freq2, int freq3, int freq4, int vol);
  void killAllNotes();
  void setTempo(int t, long pos=0);
  bool playing() const { return _playing; }
  /* 
   * ARTS/ALSA
   */
 private:
  void metronome(int);

  AlsaManager * alsa;
  SongIterator * aiterator;
  int ntracks;
  long pp;
  long left;

  struct PlayerState * ps;
  void initPlayer();
  void freePlayer();

 public:
  bool playQuantum(bool cycl = false);
  bool playStart(PrProgress * progress, Part * part, long left, long right);
  double time();
  long ticks();
  long volume();
  void programChange(int track);
  void programChange(Track*);
};

#endif
