#ifndef _HARMONYTRACK_CPP_
#define _HARMONYTRACK_CPP_

#include <iostream.h>
#include "harmonyTrack.h"
#include "loader.h"
#include "addElement.h"
#include "table.h"
#include "str.h"
#include "prTrack.h"
#include "prFactory.h"
#include "song.h"
#include "part.h"
#include "prMainEditor.h"
#include "riemannEvent.h"

#include "textHarmonyTrack.h"
#include "kdeHarmonyTrack.h"

extern Song * sonG;
extern PrFactory * factory;
extern PrMainEditor * mainEditor;

HarmonyTrack * global_harmony_track = 0;

extern "C" {
  //
  // implemented as a singleton
  //
  Track * riemann_track() {
    if (global_harmony_track==0) {
      global_harmony_track = new HarmonyTrack();
      global_harmony_track->show();
    }
    return global_harmony_track;
    // return new HarmonyTrack();
  }
}

HarmonyTrack::HarmonyTrack() : _key(UNDEFKEY), _genus(UNDEFGEN)
{
  _type = TRACK;
  if (factory->isA()==TEXT) { _pr = new TextHarmonyTrack(this); _pr->show(); }
  if (factory->isA()==KDE)  { _pr = new KdeHarmonyTrack(this); _pr->show(); }
}

HarmonyTrack::HarmonyTrack(const HarmonyTrack& st)
  : Track(st,TRACK), _key(UNDEFKEY), _genus(UNDEFGEN)
{
  if (factory->isA()==TEXT) { _pr = new TextHarmonyTrack(this); _pr->show(); }
  if (factory->isA()==KDE)  { _pr = new KdeHarmonyTrack(this); _pr->show(); }
}

HarmonyTrack::~HarmonyTrack() {
}


Key HarmonyTrack::key() { return _key; }

Genus HarmonyTrack::genus() { return _genus; }

void HarmonyTrack::setKey(Key k) {
  _key = k;
  if (factory->isA()==KDE) ((KdeHarmonyTrack*)_pr)->setKey((int)k);
}

bool HarmonyTrack::suggestKey(Key k) {
  if (_key==UNDEFKEY) { setKey(k); return true; }
  else return false;
}

void HarmonyTrack::setGenus(Genus g) {
  _genus = g;
  if (factory->isA()==KDE) ((KdeHarmonyTrack*)_pr)->setGenus((int)g);
}

bool HarmonyTrack::suggestGenus(Genus g) {
  if (_genus==UNDEFGEN) { setGenus(g); return true; }
  else return false;
}



ostream & HarmonyTrack::printOptions(int dep, ostream & s) const {
  s << spc(dep) << "<OPTIONS ";
  // TODO...
  s << " />" << endl;
  return s;
}

void HarmonyTrack::flush(const char * c) const {
  cout << c << "HARMONYTRACK" << endl;
}

Element * HarmonyTrack::copy() const {
  return new HarmonyTrack(*this);
}

void HarmonyTrack::loadOpt(ifstream *& inPtr) {
  Table * opt = Loader::getAttributes("OPTIONS",inPtr);

  opt->scratch();
  delete opt;
}

const char * HarmonyTrack::eventType() { return "RIEMANN"; }

EVENTLOAD HarmonyTrack::eventLoad() { return &RiemannEvent::load; }



#endif
