#ifndef _GLOBALS_CPP_
#define _GLOBALS_CPP_

#include <stdio.h>

#include "globals.h"

const char * sKey[]   = { "UNDEFINED", "FES", "CES", "GES", "DES", "AS", "ES", "B", "F", "C", "G", "D", "A", "E", "H", "FIS", "CIS", "GIS", "DIS", "AIS", "EIS", "HIS" };
const char * sInterval[] = { "UNDEFINT", "PRIME", "MINORSECOND", "MAJORSECOND", "MINORTHIRD", "MAJORTHIRD", "FOURTH", "TRITONUS", "FIFTH", "MINORSIXTH", "MAJORSIXTH", "MINORSEVENTH", "MAJORSEVENTH", "OCTAVE" };
const char * sGenus[] = { "-", "min", "maj", "dim" };


const Key key_of_step[STEP][5] = {
  // bb    b    0    #    x
  {   C,   C,   C, HIS, HIS }, // c
  { DES, DES, CIS, CIS, CIS }, // c#
  {   D,   D,   D,   D,   D }, // d
  {  ES,  ES, DIS, DIS, DIS }, // d#
  { FES, FES,   E,   E,   E }, // e
  {   F,   F,   F, EIS, EIS }, // f
  { GES, GES, FIS, FIS, FIS }, // f#
  {   G,   G,   G,   G,   G }, // g
  {  AS,  AS, GIS, GIS, GIS }, // g#
  {   A,   A,   A,   A,   A }, // a
  {   B,   B, AIS, AIS, AIS }, // a#
  { CES, CES,   H,   H,   H }  // h
};



//                        UNDEFKEY, FES, CES, GES, DES, AS, ES,  B,  F,  C,  G,  D,  A,  E,  H, FIS, CIS, GIS, DIS, AIS, EIS, HIS
const int tone_of_key[KEY] = {   0,   3,   7,   5,   2,  6,  3,  7,  4,  1,  5,  2,  6,  3,  7,   4,   2,   6,   3,   7,   4,   1 };

//                        UNDEFKEY, FES, CES, GES, DES, AS, ES,  B,  F,  C,  G,  D,  A,  E,  H, FIS, CIS, GIS, DIS, AIS, EIS, HIS
const int step_of_key[KEY] = {   0,   4,  11,   6,   1,  8,  3, 10,  5,  0,  7,  2,  9,  4, 11,   6,   1,   8,   3,  10,   5,   0 };

//                             c  c#  d  d#  e  f  f#  g  g#  a  a#  h
const int tone_of_step[12] = { 0, 2,  2,  3, 3, 4,  4, 5,  6, 6,  7, 7 };

const int single_c_matrix[GENUS][KEY] = {
  // UNDEFKEY, FES, CES, GES, DES, AS, ES,  B,  F,  C,  G,  D,  A,  E,  H, FIS, CIS, GIS, DIS, AIS, EIS, HIS
  {         0,   0,   0,   0,   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   0,   0,   0,   0,   0,   0,   0 }, // UNDEF
  {         0,  -2,  -2,  -2,  -2,  2,  2,  2,  1,  2,  2,  1,  2, -3,  1,  -2,  -2,   1,  -2,   1,  -1,  -2 }, // quest for C MINOR
  {         0,  -2,  -2,  -2,  -2, -1, -3,  2,  1,  2,  2,  1,  2,  2,  1,  -2,  -2,  -2,  -2,  -2,  -2,  -2 }, // quest for C MAJOR
  {         0,   0,   0,   2,   0,  0,  2,  0,  0,  2,  0,  0,  2,  0,  0,   2,   0,   0,   2,   0,   0,   2 }  // quest for C DIMINISHED
};

const int double_c_matrix[GENUS][KEY] = {
  // UNDEFKEY, FES, CES, GES, DES, AS, ES,  B,  F,  C,  G,  D,  A,  E,  H, FIS, CIS, GIS, DIS, AIS, EIS, HIS
  {         0,   0,   0,   0,   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   0,   0,   0,   0,   0,   0,   0 }, // UNDEF
  {         0,   0,   0,   0,   0,  0,  2,  0,  0,  3,  2,  0,  2,  0,  0,   0,   0,   0,   0,   0,   0,   0 }, // MINOR
  {         0,   0,   0,   0,   0,  0,  0,  0,  0,  3,  2,  0,  2,  2,  0,   0,   0,   0,   0,   0,   0,   0 }, // MAJOR
  {         0,   0,   0,   2,   0,  0,  2,  0,  0,  2,  0,  0,  2,  0,  0,   2,   0,   0,   2,   0,   0,   2 } // DIMINISHED
};


const int harmonic_weight[GENUS][GENUS][KEY] = {
  {
    {         0,   0,   0,   0,   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   0,   0,   0,   0,   0,   0,   0 }, // UNDEF
    {         0,   0,   0,   0,   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   0,   0,   0,   0,   0,   0,   0 }, // UNDEF
    {         0,   0,   0,   0,   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   0,   0,   0,   0,   0,   0,   0 }, // UNDEF
    {         0,   0,   0,   0,   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   0,   0,   0,   0,   0,   0,   0 } // UNDEF
  }, {
    // UNDEFKEY, FES, CES, GES, DES, AS, ES,  B,  F,  C,  G,  D,  A,  E,  H, FIS, CIS, GIS, DIS, AIS, EIS, HIS:  <- MINOR = base key and genus
    {         0,   0,   0,   0,   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   0,   0,   0,   0,   0,   0,   0 }, // UNDEF
    {         0,   1,   1,   1,   2,  3,  4,  5,  6,  6,  6,  5,  4,  3,  2,   1,   1,   1,   1,   1,   1,   1 }, // quest for C MINOR
    {         0,   1,   1,   1,   1,  1,  1,  2,  3,  4,  3,  6,  6,  6,  4,   3,   2,   1,   1,   1,   1,   1 }, // quest for C MAJOR
    {         0,   2,   2,   2,   2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,   2,   2,   2,   2,   2,   2,   2 }  // quest for C DIMINISHED
  }, {
    // UNDEFKEY, FES, CES, GES, DES, AS, ES,  B,  F,  C,  G,  D,  A,  E,  H, FIS, CIS, GIS, DIS, AIS, EIS, HIS:  <- MAJOR = base key and genus
    {         0,   0,   0,   0,   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   0,   0,   0,   0,   0,   0,   0 }, // UNDEF
    {         0,   1,   1,   2,   3,  4,  6,  5,  4,  4,  6,  1,  1,  1,  1,   1,   1,   1,   1,   1,   1,   1 }, // quest for C MINOR
    {         0,   1,   1,   1,   2,  3,  4,  5,  6,  6,  6,  5,  4,  3,  2,   1,   1,   1,   1,   1,   1,   1 }, // quest for C MAJOR
    {         0,   2,   2,   2,   2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,   2,   2,   2,   2,   2,   2,   2 }  // quest for C DIMINISHED
  }, {
    // UNDEFKEY, FES, CES, GES, DES, AS, ES,  B,  F,  C,  G,  D,  A,  E,  H, FIS, CIS, GIS, DIS, AIS, EIS, HIS:  <- DIMINISHED = base key and genus
    {         0,   0,   0,   0,   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   0,   0,   0,   0,   0,   0,   0 }, // UNDEF
    {         0,   1,   1,   1,   1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,   1,   1,   1,   1,   1,   1,   1 }, // quest for C MINOR
    {         0,   1,   1,   1,   1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,   1,   1,   1,   1,   1,   1,   1 }, // quest for C MAJOR
    {         0,   1,   1,   1,   1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,   1,   1,   1,   1,   1,   1,   1 }  // quest for C DIMINISHED
  }
};


Key keyOfStep(int step, int enh) {
  return key_of_step[step][enh+2];
}

int toneOfStep(Key base, int step_abs) {
  // step_abs in Halftones
  return tone_of_step[ (step_abs - step_of_key[base] + 12) % 12 ];
}

int weight(Key qkey, Genus qgenus, Key k, int mult) {
  return single_c_matrix[qgenus] [ (( k-qkey + C + KEY ) % KEY) ] + (mult>1 ? double_c_matrix[qgenus] [ (( k-qkey + C + KEY ) % KEY) ] : 0);
}

int harmonic_correlation(Key qkey, Genus qgenus, Key base, Genus genus) {
  return harmonic_weight[genus] [qgenus] [ (( base-qkey + C + KEY) % KEY) ];
}






#endif
