#ifndef _CHORD_CPP_
#define _CHORD_CPP_

#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>

#include "chord.h"

Chord::Chord() : _dim(0), _key(0), _mult(0) {}

Chord::Chord(Position pos, int * stp, int * enh, int * m, int d) : Event(pos,0), _dim(d) {
  _key = new Key[_dim];
  _mult = new int[_dim];
  for (int i=0; i<_dim; i++) {
    _key[i] = keyOfStep(stp[i],enh[i]);
    _mult[i] = m[i];
  }
}

Chord::Chord(const Chord & c) : Event(c) {
  _dim = c._dim;
  _key = new Key[_dim];
  _mult = new int[_dim];
  for (int i=0; i<_dim; i++) {
    _key[i] = c._key[i];
    _mult[i] = c._mult[i];
  }
}

Chord::~Chord() {
  if (_key!=0) delete _key;
  if (_mult!=0) delete _mult;
}


void Chord::operator=(const Chord & c) {
  setInternalStart(c.internalStart());
  if (_key!=0) delete _key;
  if (_mult!=0) delete _mult;
  _dim = c._dim;
  _key = new Key[_dim];
  _mult = new int[_dim];
  for (int i=0; i<_dim; i++) {
    _key[i] = c._key[i];
    _mult[i] = c._mult[i];
  }
}


ostream & Chord::print(int dep, ostream & s) const {
  s << spc(dep) << "<CHORD pos=\"" << internalStart().ticks() << "\" dim=\"" << _dim << "\" key=\"";
  for (int i=0; i<_dim; i++) {
    s << sKey[_key[i]];
    if (i!=_dim-1) s << ", ";
  }
  s << "\" mult=\"";
  for (int i=0; i<_dim; i++) {
    s << _mult[i];
    if (i!=_dim-1) s << ", ";
  }
  s << "\"  />" << endl;
  return s;
}

void Chord::flush(const char * c) const {
  cout << c << "CHORD" << endl;
}

Element * Chord::copy() const {
  return new Chord(*this);
}


// *********************************
// **                             **
// **          Iterator           **
// **                             **
// *********************************


Chord::Iterator::Iterator(const Iterator& i) : _chord(i._chord), _dim(i._dim), _key(i._key), _mult(i._mult), _index(i._index) { }

Chord::Iterator::Iterator(const Chord & c) : _chord(&c), _dim(c._dim), _key(c._key[0]), _mult(c._mult[0]), _index(0) { }

Chord::Iterator::~Iterator()
{
}

bool Chord::Iterator::operator!=(const Iterator& i) const {
  return (_chord != i._chord) || (_index != i._index);
}

bool Chord::Iterator::operator==(const Iterator& i) const {
  return (_chord== i._chord) && (_index == i._index);
}

bool Chord::Iterator::done() const {
  return (_index==_dim);
}

Key Chord::Iterator::key() {
  return _key;
}

int Chord::Iterator::mult() {
  return _mult;
}

Chord::Iterator& Chord::Iterator::operator++() {
  if(!_chord) {
    cerr << ("NO CHORD\n");
    return *this;
  }
  
  _index++;
  _key  = _chord->_key[_index];
  _mult = _chord->_mult[_index];

  return *this;
}

Chord::Iterator Chord::Iterator::operator++(int) {
  Iterator __tmp = *this;
  ++*this;
  return __tmp;
}



#endif
