// distribution boxbackup-0.11rc2 (svn version: 2072)
//  
// Copyright (c) 2003 - 2008
//      Ben Summers and contributors.  All rights reserved.
//  
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. All use of this software and associated advertising materials must 
//    display the following acknowledgment:
//        This product includes software developed by Ben Summers.
// 4. The names of the Authors may not be used to endorse or promote
//    products derived from this software without specific prior written
//    permission.
// 
// [Where legally impermissible the Authors do not disclaim liability for 
// direct physical injury or death caused solely by defects in the software 
// unless it is modified by a third party.]
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT,
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
// ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
//  
//  
//  
// --------------------------------------------------------------------------
//
// File
//		Name:    intercept.h
//		Purpose: Syscall interception code for unit tests
//		Created: 2006/11/29
//
// --------------------------------------------------------------------------

#ifndef INTERCEPT_H
#define INTERCEPT_H
#ifndef PLATFORM_CLIB_FNS_INTERCEPTION_IMPOSSIBLE

#include <dirent.h>

#include <sys/types.h>
#include <sys/stat.h>

extern "C"
{
	typedef DIR           *(opendir_t) (const char *name);
	typedef struct dirent *(readdir_t) (DIR *dir);
	typedef struct dirent *(readdir_t) (DIR *dir);
	typedef int            (closedir_t)(DIR *dir);
#if defined __GNUC__ && __GNUC__ >= 2
#define LINUX_WEIRD_LSTAT
#define STAT_STRUCT struct stat /* should be stat64 */
	typedef int            (lstat_t)   (int ver, const char *file_name, 
	                                    STAT_STRUCT *buf);
#else
#define STAT_STRUCT struct stat
	typedef int            (lstat_t)   (const char *file_name, 
	                                    STAT_STRUCT *buf);
#endif
}

void intercept_setup_error(const char *filename, unsigned int errorafter, 
	int errortoreturn, int syscalltoerror);
void intercept_setup_delay(const char *filename, unsigned int delay_after,
	int delay_ms, int syscall_to_delay, int num_delays);
bool intercept_triggered();

void intercept_setup_readdir_hook(const char *dirname,  readdir_t hookfn);
void intercept_setup_lstat_hook  (const char *filename, lstat_t   hookfn);

#endif // !PLATFORM_CLIB_FNS_INTERCEPTION_IMPOSSIBLE
#endif // !INTERCEPT_H
