[-- template default.template --]
[-- define title=The Main Screen --]
[-- define chapter_title=3. Using BookmarkBridge --]
[-- define prev_link=# --]
[-- define prev_title=None --]
[-- define next_link=bookmarkbridge_settings.html --]
[-- define next_title=BookmarkBridge Settings --]

<p>
The screenshot below, taken from the Linux version of BookmarkBridge running on
KDE 3 with RedHat Linux 8, shows the main screen of BookmarkBridge.
</p>

<img src="main_screen.png" border="0" width="597" height="508">

<p>
As you can see from the screenshot, running BookmarkBridge actually just consists of
three steps: selecting source browsers, selecting destination browsers, and selecting
an action.  Since BookmarkBridge remembers your selection of source and destination
browsers from one session to the next, you can usually just skip to step 3 and select
an action.
</p>

<h3>Source and Destination Browsers</h3>
<p>
Steps 1 and 2 consist of selecting your source and destination browsers.  The source
browsers are the browsers from which BookmarkBridge reads bookmarks.  The destination
browsers are the browsers to which BookmarkBridge saves bookmarks.  With the
configuration shown in the screenshot above, BookmarkBridge will read bookmarks from
both Internet Explorer and Mozilla, combine those bookmarks into one list and save
the combined list back out to both browsers.  If a new bookmark is added to one of
the browsers, BookmarkBridge will save it to the other browser.  If a bookmark is
later removed from a browser, BookmarkBridge will remove it from the other browser.
If a browser is listed as a source but not a destination then no changes are ever
written to that browser but any bookmarks added to or removed from the browser will
be added to or removed from any browser listed as a destination.  Conversly, if a
browser is listed as a destination but not a source, any changes made to the bookmarks
of that browser, that are not also made to a browser listed as a source, will be
undone by BookmarkBridge.
</p>

<p>
If you wish to add a browser as a source or destination, click the appropriate
<b>Add</b> button.  You are presented with a list of available browsers.  It is not
possible to list a browser multiple times as a source or destination.  If all
configured browsers are already listed as a source or destination, clicking on the
<b>Add</b> button will display a message box explaining why you cannot add another
browser.  If a particular browser is installed on your system in more than one
location, it is possible for BookmarkBridge to merge between these multiple
locations.  Please see the section on
<a href="bookmarkbridge_settings.html">BookmarkBridge Settings</a> for more
information.
</p>

<p>
If you wish to remove a browser as a source or destination, highlight the desired
browser, and click on the appropriate <b>Delete</b> button.  You are asked to
confirm the removal.
</p>

<h3>Viewing Bookmarks</h3>
<p>
Clicking on the <b>View</b> button, reads all bookmarks from the browsers listed as
sources and displays in a separate window.  See the section
<a href="viewing_your_bookmarks.html">Viewing Your Bookmarks</a> for more
information.
</p>

<h3>Merging Bookmarks</h3>
<p>
Clicking on the <b>Merge</b> button, reads all bookmarks from the browsers listed as
a source, combines them into one single list, then saves those bookmarks out to each
browser listed as a destination. See the section
<a href="merging_your_bookmarks.html">Merging Your Bookmarks</a> for more
information.
</p>
