/***************************************************************************
                          opera.h  -  Opera Browser Class
                             -------------------
    begin                : Tue Feb 18 2003
    copyright            : (C) 2003 by Ken Schenke
    email                : kenschenke@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   In addition, as a special exception, Ken Schenke gives permission to  *
 *   link the code of this program with the Qt non-commercial edition (or  *
 *   with modified versions of the Qt non-commercial edition that use the  *
 *   same license as the Qt non-commercial edition, and distribute linked  *
 *   combinations including the two.  You must obey the GNU General Public *
 *   License in all respects for all of the code used other than the Qt    *
 *   Non-Commercial edition.  If you modify this file, you may extend this *
 *   exception to your version of the file, but you are not obligated to   *
 *   do so.  If you do not wish to do so, delete this exception statement  *
 *   from your version.                                                    *
 *                                                                         *
 ***************************************************************************/

#ifndef OPERA_H
#define OPERA_H

#include "browserbk.h"

#include <qdir.h>
#include <qtextstream.h>

class Opera : public BrowserBk
{
public:
	Opera() { m_Root = NULL; }
	virtual ~Opera() { delete m_Root; }

	virtual bool    AreBookmarksValid(const QString &bookmarks);
	virtual bool    BrowseForBookmarks(
		const BridgeCfg &cfg, QString &bookmarks, QWidget *parent=0);
	virtual bool	DetectBrowser(const BridgeCfg &cfg, QStringList &paths);
	virtual void	readBookmarks(const QString &path, BRWSNUM browserOrd)
						throw(BkException);
	static	void	saveBookmarks(const QString &path, BkFolder &root, BRWSNUM browserOrd)
						throw(BkException);
	static BrowserBk *classFactory(void);

protected:
	virtual BkFolder & root(void) { return *m_Root; }

	bool	findBookmarkFile(const char *path, QString &bookmarkFile);

	void	readAttributes(QTextStream &stream, BkNode &node, QString &line,
						BRWSNUM browserOrd) throw(BkException);
	void	readFolder(QTextStream &stream, BkFolder &folder, BRWSNUM browserOrd)
						throw(BkException);

private:

	BkFolder	*m_Root;
};

#endif  // end of OPERA_H
