/***************************************************************************
                          bkexcept.h  -  description
                             -------------------
    begin                : Thu Feb 06 2003
    copyright            : (C) 2002 by Ken Schenke
    email                : kenschenke at yahoo dot com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   In addition, as a special exception, Ken Schenke gives permission to  *
 *   link the code of this program with the Qt non-commercial edition (or  *
 *   with modified versions of the Qt non-commercial edition that use the  *
 *   same license as the Qt non-commercial edition, and distribute linked  *
 *   combinations including the two.  You must obey the GNU General Public *
 *   License in all respects for all of the code used other than the Qt    *
 *   Non-Commercial edition.  If you modify this file, you may extend this *
 *   exception to your version of the file, but you are not obligated to   *
 *   do so.  If you do not wish to do so, delete this exception statement  *
 *   from your version.                                                    *
 *                                                                         *
 ***************************************************************************/

#ifndef BKEXCEPT_H
#define BKEXCEPT_H

#include <string>

#define BKEXCEPT(em) throw(BkException(em, __FILE__, __LINE__))

/***************************************************************************
 *                                                                         *
 *   The BkException class is used throughout BookmarkBridge to            *
 *   communicate exceptions containing error messages and other pertinant  *
 *   information concerning an exception.                                  *
 *                                                                         *
 ***************************************************************************/

class BkException
{
public:
	BkException(const char *msg, const char *file, int line)
		: m_msg(msg), m_file(file), m_line(line) { };

	BkException & operator=(const BkException &bk)
	{
		m_msg = bk.m_msg;
		m_file = bk.m_file;
		m_line = bk.m_line;
		return *this;
	}

	const char *msg(void) const		{ return m_msg.c_str(); }
	const char *file(void) const	{ return m_file.c_str(); }
	int line(void) const			{ return m_line; }

private:
	std::string	m_msg;
	std::string	m_file;
	int			m_line;
};

#endif	// end of BKEXCEPT_H
