/*
   bogosort - sorts or doesn't sort files or its standard input

   Copyright (C) 2000 Ulrik Haugen

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
*/
/* $Id: getlines.c,v 1.1 2000/09/17 19:11:29 qha Exp $ */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <sys/types.h>
#include "system.h"

#include <stdio.h>
#include "getlines.h"

#define CHARSTEP 80
#define LINESTEP 1024

char *xmalloc();
char *xrealloc();
char *xstrdup();

/*
 * getlines: return a pointer to a newly allocated array of newly allocated
 * strings containing steam. the last string is followed by a NULL-pointer.
 */
char **
getlines(FILE *stream)
{
    int numlines = 0, allocated = 0;
    char *s = NULL;
    char **ss = NULL;

    /* read all lines available */
    while ((s = getline(stream)) != NULL) {
	if (numlines == allocated)		/* make more room if needed */
	    ss = (char **)xrealloc(ss,
		    (allocated += LINESTEP) * sizeof (char *));
	ss[numlines++] = s;
    }

    if (numlines == allocated)			/* make more room if needed */
	ss = (char **)xrealloc(ss, ++allocated * sizeof (char *));
    ss[numlines] = NULL;

    return ss;
}


/*
 * getmorelines: fill out lines whith stream and return a pointer to the
 * reallocated array of some old and some newly allocated strings. the last
 * string is followed by a NULL-pointer.
 */
char **
getmorelines(FILE *stream, char **lines)
{
    int numlines = 0, allocated = 0;
    char *s = NULL;
    char **ss = lines;

    /* count the lines in ss */
    for (; ss[numlines] != NULL; numlines++) ;
    allocated = numlines + 1;	/* this is a lie, but it's close enough */

    /* read all lines available */
    while ((s = getline(stream)) != NULL) {
	if (numlines == allocated)		/* make more room if needed */
	    ss = (char **)xrealloc(ss,
		    (allocated += LINESTEP) * sizeof (char *));
	ss[numlines++] = s;
    }

    if (numlines == allocated)			/* make more room if needed */
	ss = (char **)xrealloc(ss, ++allocated * sizeof (char *));
    ss[numlines] = NULL;

    return ss;
}

/*
 * getline: return a pointer to a newly allocated string containing the next
 * line in stream, return NULL on EOF
 */
char *
getline(FILE *stream)
{
    int c, numlines = 0, allocated = 0;
    char *s = NULL;

    /* read all chars available */
    while (((c = getc(stream)) != EOF) && (c != '\n')) {
	if (numlines == allocated)		/* make more room if needed */
	    s = xrealloc(s, (allocated += CHARSTEP) * sizeof (char));
	s[numlines++] = (char) c;
    }

    if (c == EOF) return NULL;

    if (numlines == allocated)			/* make more room if needed */
	s = xrealloc(s, (allocated += 2) * sizeof (char));
    s[numlines++] = '\n';
    s[numlines] = '\0';

    return s;
}
