/* Bluefish HTML Editor
 * wml.c - WML support dialogs
 *
 * Keep in mind that wml-stuff is case-sensitive!
 *
 * Copyright (C) 
 * 1999-2000 Olivier Sessink, Roland Steinbach
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include "default_include.h"

#include "html_diag.h"
#include "bluefish.h"
#include "gtk_easy.h"
#include "wml.h"
#include "document.h"

/********************************************************************/

void general_wml_cb(GtkWidget * widget, gpointer data)
{
	switch (GPOINTER_TO_INT(data)) {
	case 1:
		insert_dbl_text("<p>", "</p>");
		break;
	case 2:
		insert_dbl_text("<br/>", "");
		break;
	case 3:
		insert_dbl_text("<i>", "</i>");
		break;
	case 4:
		insert_dbl_text("$nbsp", "");
		break;
	case 5:
		insert_dbl_text("<b>", "</b>");
		break;
	case 6:
		insert_dbl_text
			("<?xml version=\"1.0\"?>\n<!DOCTYPE wml PUBLIC \"-//WAPFORUM/DTD wml 1.2//EN\" \"http://www.wapforum.org/DTD/wml_1.2.xml\">\n<wml>\n",
			 "\n</wml>");
		break;
	case 7:
		insert_dbl_text("<prev/>", "");
		break;
	case 8:
		insert_dbl_text("<refresh/>", "");
		break;
	case 9:
		insert_dbl_text("<noop/>", "");
		break;
	default:
		break;
	}
}

/*******************************************************************************/


static void carddialogok_lcb(GtkWidget * widget, Thtml_diag *dg) {
	gchar *thestring, *finalstring;

	thestring = g_strdup("<card");
	thestring = insert_string_if_entry(dg->entry[0], "id", thestring, NULL);
	thestring = insert_string_if_entry(dg->entry[1], "title", thestring, NULL);
	thestring = insert_string_if_entry(dg->entry[2], "ontimer", thestring, NULL);
	finalstring = g_strconcat(thestring,">", NULL);
	g_free(thestring);

	if (dg->range.len == -1) {
		insert_dbl_text(finalstring, "\n</card>");
	} else {
		replace_text(finalstring, dg->range.pos, dg->range.len);
	}
	g_free(finalstring);
	html_diag_destroy_cb(NULL, NULL, dg);
}

void carddialog_cb(GtkWidget * widget, gpointer data) {
	static gchar *tagitems[] = { "id", "title", "ontimer", NULL };
	gchar *tagvalues[4];
	gchar *custom = NULL;
	GtkWidget *dgtable;
	Thtml_diag *dg;

	dg = html_diag_new(_("WML Card"));
	fill_dialogvalues(tagitems, tagvalues, &custom, (Ttagpopup *) data, widget, dg);

	dgtable = gtk_table_new(3, 12, 0);
	gtk_box_pack_start(GTK_BOX(dg->vbox), dgtable, FALSE, FALSE, 0);

	dg->entry[0] = entry_with_text(tagvalues[0], 256);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), gtk_label_new(_("ID")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), dg->entry[0], 1, 2, 0, 1);

	dg->entry[1] = entry_with_text(tagvalues[1], 256);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), gtk_label_new(_("Title")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), dg->entry[1], 1, 2, 1, 2);

	dg->entry[2] = entry_with_text(tagvalues[2], 256);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), gtk_label_new(_("OnTimer")), 0, 1, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), dg->entry[2], 1, 2, 2, 3);

	html_diag_finish(dg, carddialogok_lcb);
	if (custom)	g_free(custom);
}
/*******************************************************************************/

static void post_and_var_dialogok_lcb(gint type, GtkWidget * widget, Thtml_diag *dg) {
	gchar *thestring, *finalstring;

	if (type == 0) {
		thestring = g_strdup("<postfield");
	} else {
		thestring = g_strdup("<setvar");
	}
	thestring = insert_string_if_entry(dg->entry[0], "id", thestring, NULL);
	thestring = insert_string_if_entry(dg->entry[1], "name", thestring, NULL);
	thestring = insert_string_if_entry(dg->entry[2], "value", thestring, NULL);
	finalstring = g_strconcat(thestring," />", NULL);
	g_free(thestring);

	if (dg->range.len == -1) {
		insert_dbl_text(finalstring, NULL);
	} else {
		replace_text(finalstring, dg->range.pos, dg->range.len);
	}
	g_free(finalstring);
	html_diag_destroy_cb(NULL, NULL, dg);
}

static void postfielddialogok_lcb(GtkWidget * widget, Thtml_diag *dg) {
	post_and_var_dialogok_lcb(0, widget, dg);
}

static void vardialogok_lcb(GtkWidget * widget, Thtml_diag *dg) {
	post_and_var_dialogok_lcb(1, widget, dg);
}

static void post_and_var_dialog(gint type, GtkWidget * widget, gpointer data) {
	static gchar *tagitems[] = { "id", "name", "value", NULL };
	gchar *tagvalues[4];
	gchar *custom = NULL;
	GtkWidget *dgtable;
	Thtml_diag *dg;

	if (type == 0) {
		dg = html_diag_new(_("WML Postfield"));
	} else {
		dg = html_diag_new(_("WML Variable"));
	}
	fill_dialogvalues(tagitems, tagvalues, &custom, (Ttagpopup *) data, widget, dg);
	
	dgtable = gtk_table_new(3, 12, 0);
	gtk_box_pack_start(GTK_BOX(dg->vbox), dgtable, FALSE, FALSE, 0);

	dg->entry[0] = entry_with_text(tagvalues[0], 256);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), gtk_label_new(_("ID")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), dg->entry[0], 1, 2, 0, 1);

	dg->entry[1] = entry_with_text(tagvalues[1], 256);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), gtk_label_new(_("Name")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), dg->entry[1], 1, 2, 1, 2);

	dg->entry[2] = entry_with_text(tagvalues[2], 256);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), gtk_label_new(_("Value")), 0, 1, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), dg->entry[2], 1, 2, 2, 3);
	if (type == 0) {
		html_diag_finish(dg, postfielddialogok_lcb);
	} else {
		html_diag_finish(dg, vardialogok_lcb);
	}
	if (custom)	g_free(custom);
}

void postfielddialog_cb(GtkWidget * widget, gpointer data) {
	post_and_var_dialog(0, widget, data);
}

void vardialog_cb(GtkWidget * widget, gpointer data) {
	post_and_var_dialog(1, widget, data);
}
/*******************************************************************************/
static void godialogok_lcb(GtkWidget * widget, Thtml_diag *dg) {
	gchar *thestring, *finalstring;

	thestring = g_strdup("<go");
	thestring = insert_string_if_entry(dg->entry[0], "id", thestring, NULL);
	thestring = insert_string_if_entry(dg->entry[1], "href", thestring, NULL);
	thestring = insert_string_if_entry(GTK_COMBO(dg->combo[0])->entry, "sendreferer", thestring, NULL);
	thestring = insert_string_if_entry(GTK_COMBO(dg->combo[1])->entry, "method", thestring, NULL);
	thestring = insert_string_if_entry(GTK_COMBO(dg->combo[2])->entry, "enctype", thestring, NULL);
	finalstring = g_strconcat(thestring, ">", NULL);
	g_free(thestring);

	if (dg->range.len == -1) {
		insert_dbl_text(finalstring, "</go>");
	} else {
		replace_text(finalstring, dg->range.pos, dg->range.len);
	}
	g_free(finalstring);
	html_diag_destroy_cb(NULL, NULL, dg);
}

void godialog_cb(GtkWidget * widget, gpointer data)
{
	GList *tmplist = NULL;
	
	static gchar *tagitems[] = { "id", "href", "sendreferer", "method", "enctype", NULL };
	gchar *tagvalues[6];
	gchar *custom = NULL;
	GtkWidget *dgtable;
	Thtml_diag *dg;

	dg = html_diag_new(_("Go Dialog"));
	fill_dialogvalues(tagitems, tagvalues, &custom, (Ttagpopup *) data, widget, dg);

	dgtable = gtk_table_new(3, 6, 0);
	gtk_box_pack_start(GTK_BOX(dg->vbox), dgtable, FALSE, FALSE, 0);

	dg->entry[0] = entry_with_text(tagvalues[0], 256);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), gtk_label_new(_("ID")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), dg->entry[0], 1, 2, 0, 1);

	dg->entry[1] = entry_with_text(tagvalues[1], 256);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), gtk_label_new(_("HREF")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), dg->entry[1], 1, 2, 1, 2);

	tmplist = g_list_append(NULL, "false");
	tmplist = g_list_append(tmplist, "true");
	dg->combo[0] = combo_with_popdown(tagvalues[2], tmplist, 1);
	g_list_free(tmplist);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), gtk_label_new(_("Sendreferer")), 0, 1, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), dg->combo[0], 1, 2, 2, 3);

	tmplist = g_list_append(NULL, "get");
	tmplist = g_list_append(tmplist, "post");
	dg->combo[1] = combo_with_popdown(tagvalues[3], tmplist, 1);
	g_list_free(tmplist);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), gtk_label_new(_("Method")), 0, 1, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), dg->combo[1], 1, 2, 3, 4);

	tmplist = g_list_append(NULL, "application/x-www-form-urlencoded");
	tmplist = g_list_append(tmplist, "multipart/form-data");
	dg->combo[2] = combo_with_popdown(tagvalues[4], tmplist, 1);
	g_list_free(tmplist);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), gtk_label_new(_("Enctype")), 0, 1, 4, 5);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), dg->combo[2], 1, 2, 4, 5);
	html_diag_finish(dg, godialogok_lcb);
	
	if (custom)	g_free(custom);
}
/*******************************************************************************/
static void dodialogok_lcb(GtkWidget * widget, Thtml_diag *dg) {
	gchar *thestring, *finalstring;

	thestring = g_strdup("<do");
	thestring = insert_string_if_entry(dg->entry[0], "id", thestring, NULL);
	thestring = insert_string_if_entry(GTK_COMBO(dg->combo[0])->entry, "type", thestring, NULL);
	thestring = insert_string_if_entry(dg->entry[1], "label", thestring, NULL);
	thestring = insert_string_if_entry(dg->entry[2], "name", thestring, NULL);
	thestring = insert_string_if_entry(GTK_COMBO(dg->combo[1])->entry, "optional", thestring, NULL);	
	finalstring = g_strconcat(thestring, ">", NULL);
	g_free(thestring);

	if (dg->range.len == -1) {
		insert_dbl_text(finalstring, "</do>");
	} else {
		replace_text(finalstring, dg->range.pos, dg->range.len);
	}
	g_free(finalstring);
	html_diag_destroy_cb(NULL, NULL, dg);
}

void dodialog_cb(GtkWidget * widget, gpointer data)
{
	GList *tmplist = NULL;
	
	static gchar *tagitems[] = { "id", "type", "label", "name", "optional", NULL };
	gchar *tagvalues[6];
	gchar *custom = NULL;
	GtkWidget *dgtable;
	Thtml_diag *dg;

	dg = html_diag_new(_("Do Dialog"));
	fill_dialogvalues(tagitems, tagvalues, &custom, (Ttagpopup *) data, widget, dg);

	dgtable = gtk_table_new(3, 8, 0);
	gtk_box_pack_start(GTK_BOX(dg->vbox), dgtable, FALSE, FALSE, 0);

	dg->entry[0] = entry_with_text(tagvalues[0], 256);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), gtk_label_new(_("ID")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), dg->entry[0], 1, 2, 0, 1);

	tmplist = g_list_append(NULL, "accept");
	tmplist = g_list_append(tmplist, "prev");
	tmplist = g_list_append(tmplist, "help");
	tmplist = g_list_append(tmplist, "reset");
	tmplist = g_list_append(tmplist, "options");
	tmplist = g_list_append(tmplist, "delete");
	dg->combo[0] = combo_with_popdown(tagvalues[1], tmplist, 1);
	g_list_free(tmplist);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), gtk_label_new(_("Type")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), dg->combo[0], 1, 2, 1, 2);

	dg->entry[1] = entry_with_text(tagvalues[2], 256);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), gtk_label_new(_("Label")), 0, 1, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), dg->entry[1], 1, 2, 2, 3);

	dg->entry[2] = entry_with_text(tagvalues[3], 256);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), gtk_label_new(_("Name")), 0, 1, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), dg->entry[2], 1, 2, 3, 4);

	tmplist = g_list_append(NULL, "false");
	tmplist = g_list_append(tmplist, "true");
	dg->combo[1] = combo_with_popdown(tagvalues[4], tmplist, 1);
	g_list_free(tmplist);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), gtk_label_new(_("Is Optional")), 0, 1, 4, 5);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), dg->combo[1], 1, 2, 4, 5);

	html_diag_finish(dg, dodialogok_lcb);

	if (custom)	g_free(custom);
}
/*******************************************************************************/
static void anchordialogok_lcb(GtkWidget * widget, Thtml_diag *dg) {
	gchar *thestring, *finalstring;

	thestring = g_strdup("<anchor");
	thestring = insert_string_if_entry(dg->entry[0], "id", thestring, NULL);
	thestring = insert_string_if_entry(dg->entry[1], "title", thestring, NULL);
	thestring = insert_string_if_entry(dg->entry[2], "accesskey", thestring, NULL);
	finalstring = g_strconcat(thestring, ">", NULL);
	g_free(thestring);

	if (dg->range.len == -1) {
		insert_dbl_text(finalstring, "</anchor>");
	} else {
		replace_text(finalstring, dg->range.pos, dg->range.len);
	}
	g_free(finalstring);
	html_diag_destroy_cb(NULL, NULL, dg);
}


void anchordialog_cb(GtkWidget * widget, gpointer data)
{
	static gchar *tagitems[] = { "id", "title", "accesskey", NULL };
	gchar *tagvalues[4];
	gchar *custom = NULL;
	GtkWidget *dgtable;
	Thtml_diag *dg;

	dg = html_diag_new(_("Anchor Dialog"));
	fill_dialogvalues(tagitems, tagvalues, &custom, (Ttagpopup *) data, widget, dg);

	dgtable = gtk_table_new(3, 8, 0);
	gtk_box_pack_start(GTK_BOX(dg->vbox), dgtable, FALSE, FALSE, 0);

	dg->entry[0] = entry_with_text(tagvalues[0], 256);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), gtk_label_new(_("ID")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), dg->entry[0], 1, 2, 0, 1);

	dg->entry[1] = entry_with_text(tagvalues[1], 256);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), gtk_label_new(_("Title")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), dg->entry[1], 1, 2, 1, 2);

	dg->entry[2] = entry_with_text(tagvalues[2], 1);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), gtk_label_new(_("Accesskey")), 0, 1, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), dg->entry[2], 1, 2, 2, 3);
	html_diag_finish(dg, anchordialogok_lcb);

	if (custom)	g_free(custom);
}
/*******************************************************************************/
static void accessdialogok_lcb(GtkWidget * widget, Thtml_diag *dg) {
	gchar *thestring, *finalstring;

	thestring = g_strdup("<access");
	thestring = insert_string_if_entry(dg->entry[0], "id", thestring, NULL);
	thestring = insert_string_if_entry(dg->entry[1], "domain", thestring, NULL);
	thestring = insert_string_if_entry(dg->entry[2], "path", thestring, NULL);
	finalstring = g_strconcat(thestring, ">", NULL);
	g_free(thestring);

	if (dg->range.len == -1) {
		insert_dbl_text(finalstring, "</access>");
	} else {
		replace_text(finalstring, dg->range.pos, dg->range.len);
	}
	g_free(finalstring);
	html_diag_destroy_cb(NULL, NULL, dg);
}


void accessdialog_cb(GtkWidget * widget, gpointer data)
{
	static gchar *tagitems[] = { "id", "domain", "path", NULL };
	gchar *tagvalues[4];
	gchar *custom = NULL;
	GtkWidget *dgtable;
	Thtml_diag *dg;

	dg = html_diag_new(_("WML Access Dialog"));
	fill_dialogvalues(tagitems, tagvalues, &custom, (Ttagpopup *) data, widget, dg);
	dgtable = gtk_table_new(3, 8, 0);
	gtk_box_pack_start(GTK_BOX(dg->vbox), dgtable, FALSE, FALSE, 0);

	dg->entry[0] = entry_with_text(tagvalues[0], 256);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), gtk_label_new(_("ID")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), dg->entry[0], 1, 2, 0, 1);

	dg->entry[1] = entry_with_text(tagvalues[1], 256);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), gtk_label_new(_("Domain")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), dg->entry[1], 1, 2, 1, 2);

	dg->entry[2] = entry_with_text(tagvalues[2], 1);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), gtk_label_new(_("Path")), 0, 1, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dgtable), dg->entry[2], 1, 2, 2, 3);

	html_diag_finish(dg, accessdialogok_lcb);
	if (custom)	g_free(custom);
}

