/*=============================================================================
Blobby Volley 2
Copyright (C) 2006 Jonathan Sieber (jonathan_sieber@yahoo.de)

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
=============================================================================*/

#pragma once

#include <SDL/SDL.h>

#include "InputSource.h"
#include "InputDevice.h"
#include "UserConfig.h"
#include "Vector.h"

struct InputKeyMap
{
        const char *keyname;
        SDLKey key;
};

class InputManager
{
private:
	static InputManager* mSingleton;
	
	// Keyboard
	static InputKeyMap mKeyMap[];	// Type for String <-convert-> SDLKey

	// GUI storage (because we need event based input for the GUI)
	bool mUp;
	bool mDown;
	bool mLeft;
	bool mRight;
	bool mSelect;
	bool mExit;
	bool mClick;
	bool mUnclick;
	
	int mMouseX;
	int mMouseY;
	
	SDLKey mLastInputKey;
	int mLastMouseButton; 
	std::string mLastJoyAction;

	PlayerInput mInput[MAX_PLAYERS];	
	InputDevice *mInputDevice[MAX_PLAYERS];	
	bool mRunning;
	
	InputManager();
	
public:
	static InputManager* createInputManager();
	static InputManager* getSingleton();
	~InputManager();

	void beginGame(PlayerSide side);
	void endGame();

	bool running();
	PlayerInput getGameInput(int player);
	void updateInput();

	// For GUI navigation (Gamepad, Joystick or Keyboard)
	bool up();
	bool down();
	bool left();
	bool right();
	bool select();
	bool exit(); // extention for mouse included, so that right click = exit

	std::string getLastTextKey();
	std::string getLastActionKey();
	int getLastMouseButton() { return mLastMouseButton; }
	std::string getLastJoyAction();

	// For GUI navigation (Mouse)
	Vector2 position();
	bool click();
	bool unclick();
	
	// config conversion methods
	std::string keyToString(SDLKey key);
	SDLKey stringToKey(const std::string& keyname);
};
