
//* @package glow.object

#ifndef GLOW_OBJECT_H
#define GLOW_OBJECT_H

#include <list>

//* Object class with simple messaging and id scheme
class Object {
 public:
  //* Default constructor
  Object();

  //* Default destructor
  ~Object();

  /** Returns this object's id.
      @return the unique Object ID of this instance
   */
  int getId();

  /** delivers a message to object whose id is <b>id</b>.
      @param   id   the destination's object id.
      @param   msg  the message (ASCIIZ)
   */
  void sendMessage(int id,char *msg);

  /** delivers a message to an object.
      @param   o    a pointer to the destination object.
      @param   msg  the message (ASCIIZ)
   */
  void sendMessage(Object *o,char *msg);

  /** This method is called to deliver a message. Any objects willing to
      receive messages should override this.
      @param   msg  the message (ASCIIZ)
  */
  virtual void receiveMessage(char *msg);

 private:
  static int Count;
  static list<Object *> Universe;

  int ObjID;
};

#endif
