

import smiles
import molfile
from time import time


def test( function, times):
    t1 = time()
    for i in range( times):
        function()
    return time() - t1

def test_method( obj, method, args, times):
    t1 = time()
    for i in range( times):
        getattr( obj, method)( *args)
    return time() - t1



def is_edge_a_bridge_speed():
    mol = smiles.text_to_mol( "CCCC(CCC)CCCC1CC2CC1C2")
    t1 = time()
    for i in range( 100):
        b = 0
        for e in mol.edges:
            b += mol.is_edge_a_bridge( e)
    print b
    return time() - t1


sssr_smiles = "C1CC2CC1CC2"

def sssr_old():
    mol = smiles.text_to_mol( sssr_smiles)
    t1 = time()
    cs = mol.get_smallest_independent_cycles_e()
    print len( cs)
    return time() - t1

def sssr():
    mol = smiles.text_to_mol( sssr_smiles)
    t1 = time()
    cs = mol.get_smallest_independent_cycles_e_new()
    print len( cs)
    return time() - t1

    


def find_all_cycles_speed():
    pass


def stereo():
    sms = ["C\C=C\C","C\C=C/C"]
    c = smiles.converter()
    c.configuration['R_GENERATE_COORDS'] = True
    for i,sm in enumerate( sms):
        fname = "pokus%d.mol" % i
        m = c.read_text( sm)[0]
        print [(a.x,a.y) for a in m.vertices]
        f = file( fname, "w")
        molfile.mol_to_file( m, f)

def stereo2():
    sms = ["C\C=C\C","C\C=C/C"]
    c = smiles.converter()
    c.configuration['R_GENERATE_COORDS'] = True
    for i,sm in enumerate( sms):
        m = c.read_text( sm)[0]
        print m.stereochemistry


def stereo_from_coords():
    f = file( "ez_stereo2.mol", "r")
    mol = molfile.file_to_mol( f)
    f.close()
    mol.detect_stereochemistry_from_coords()
    print smiles.mol_to_text( mol)

def stereo_from_coords2():
    f = file( "cis_trans_cycles.mol", "r")
    mol = molfile.file_to_mol( f)
    f.close()
    c = smiles.converter()
    print c.mols_to_text( [mol])


def aromaticity():
    mol = smiles.text_to_mol( "C1=C[CH][CH]C=C1")
    #print [v.multiplicity for v in mol.vertices]
    mol.mark_aromatic_bonds()
    print [e.aromatic for e in mol.edges]
    
def smiles_from_db():
    import structure_database
    import time, sys
    c = smiles.converter()
    c.configuration['R_GENERATE_COORDS'] = True
    i = 0
    errors, ok = 0, 0
    t = time.time()
    for hit in structure_database.get_compounds_from_database():
        i += 1
        try:
            mol = c.read_text( hit[3])
        except:
            print >> sys.stderr, "CRASH:", hit[3]
            errors += 1
        else:
            ok += 1
        if i % 100 == 0:
            tm = time.time() - t
            print "%d, %d ok, %d crashes;  %.1f per second" % (i, ok, errors, i/tm)

def smiles_compression():
    import structure_database
    import time, sys, zlib
    sms = []
    f = file( "smiles.txt", "r")
    for line in f:
        sms.append( line.strip())
    f.close()
    i = 0
    length = 0
    comp_length = 0
    c = zlib.compressobj()
    for sm in sms:
        length += len( sm)
        i += 1
        comp_length += len( c.compress( sm))
    comp_length += len( c.flush(zlib.Z_SYNC_FLUSH))
    print "Ratio:", 1.0 * comp_length / length

    import random
    total_compressed = 0
    total_sm = 0
    for sm in random.sample( sms, 10000):
        total_sm += len( sm)
        compressed = c.compress( sm)
        compressed += c.flush(zlib.Z_SYNC_FLUSH)
        total_compressed += len( compressed)
        #print "RAW", 1.0*len( compressed) / len( sm)
    print "Radio for individual SMILES:", 1.0*total_compressed / total_sm


def cairo_out_test():
    import molfile
    import time
    cid = 22646404
    #cid = 1373132
    #cid = 18305969
    #cid = 19815256
    f = file( "%d.rot.mol" % cid, "r")
    mol = molfile.file_to_mol( f)
    f.close()
    import cairo_out
    mol.normalize_bond_length( 25)
    mol.remove_unimportant_hydrogens()
    c = cairo_out.cairo_out( scaling=1.0, margin=10, font_size=16,
                             bond_second_line_shortening=0.15, bond_width=6,
                             line_width=2.0, antialias_drawing=True,
                             antialias_text=True)
    #c.background_color = (1,1,0.6)
    c.show_hydrogens_on_hetero = True
    t = time.time()
    c.mol_to_cairo( mol, "%d.png" % cid)
    print time.time()-t


def cairo_out_test2():
    import smiles
    #mol = smiles.text_to_mol( "COC(=O)CNC(C1=CC=CC=C1)C2=C(C=CC(=C2)Br)NC(=O)C3=CC(=CC=C3)Cl")
    #mol = smiles.text_to_mol( "c1nccc2c1cncn2")
    mol = smiles.text_to_mol( "BNOLi")
    import cairo_out
    mol.normalize_bond_length( 30)
    mol.remove_unimportant_hydrogens()
    c = cairo_out.cairo_out( color_bonds=True, color_atoms=True)
    c.show_hydrogens_on_hetero = True
    c.font_size = 20
    c.mol_to_cairo( mol, "test.png")

def cairo_out_test_wedge():
    import molfile
    import time
    f = file( "untitled0.mol", "r")
    mol = molfile.file_to_mol( f)
    f.close()
    import cairo_out
    mol.normalize_bond_length( 30)
    mol.remove_unimportant_hydrogens()
    c = cairo_out.cairo_out( scaling=1.0, antialias_text=True, color_bonds=True, color_atoms=True)
    t = time.time()
    c.mol_to_cairo( mol, "untitled0.png")
    print time.time()-t

def test_inchi_stereo():
    import inchi
    f = file( "stereobonds.txt", "r")
    for line in f:
        orig = line.strip()
        try:
            mol = inchi.text_to_mol( orig, calc_coords=True, include_hydrogens=False)
        except:
            #print "cannot read inchi", orig
            continue
        new = inchi.mol_to_text( mol)
        if new != orig:
            pass
            print "problem"
            print orig
            print new
            print "------------------------------"
        else:
            pass
            #print "ok", orig
    f.close()


#print "new", sssr()
#print "old", sssr_old()
#print is_edge_a_bridge_speed()

#stereo_from_coords2()
#aromaticity()

#smiles_from_db()
#smiles_compression()

#cairo_out_test()
#cairo_out_test2()
#cairo_out_test_wedge()

test_inchi_stereo()
