/*

    Bist: a chemical drawing tool
    Copyright (C) 2008 Valerio Benfante

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
/**
 *prefs.h -- static Preferences class
 */


#define PREFS_FIXED_ARROW "FIXED_ARROW"
#define PREFS_FIXED_BOND "FIXED_BOND"
#define PREFS_FIX_HYDROGENS "FIX_HYDROGENS"
#define PREFS_SPLASH "SPLASH"
#define PREFS_TRUE "TRUE"
#define PREFS_FALSE "FALSE"
#define PREFS_ARROW_LENGTH "ARROW_LENGTH"
#define PREFS_ARROW_ANGLE "ARROW_ANGLE"
#define PREFS_BOND_LENGTH "BOND_LENGTH"
#define PREFS_BOND_ANGLE "BOND_ANGLE"
#define PREFS_DBOND_OFFSET "DBOND_OFFSET"
#define PREFS_ARR_W "ARR_W"
#define PREFS_ARR_H "ARR_H"
#define PREFS_ARR_GAP "ARR_GAP"
#define PREFS_MULTIPLE_BOND_GAP "MULTIPLE_BOND_GAP"
#define PREFS_SENSIB_LEG "SENSIB_LEG"
#define PREFS_WIDTH_SINGLE_BOND "WIDTH_SINGLE_BOND"
#define PREFS_LARG_MAX_CUNEO "LARG_MAX_CUNEO"
#define PREFS_LARG_MIN_CUNEO "LARG_MIN_CUNEO"
#define PREFS_AMPIEZZA_STEREO_SCON "AMPIEZZA_STEREO_SCON"
#define PREFS_FREQUENZA_STEREO_SCON "FREQUENZA_STEREO_SCON"
#define PREFS_TRATTEGGIO_LEGAME "TRATTEGGIO_LEGAME"
#define PREFS_NUM_BARRETTE_STEREO_DOWN "NUM_BARRETTE_STEREO_DOWN"
#define PREFS_MAGNETIC_POINT_GAP "MAGNETIC_POINT_GAP"
#define PREFS_SANS_FONT  "SANS_FONT "
#define PREFS_MONO_FONT  "MONO_FONT "
#define PREFS_SERIF_FONT  "SERIF_FONT "
#define PREFS_SANS_FONT_ITALIC  "SANS_FONT_ITALIC "
#define PREFS_MONO_FONT_ITALIC  "MONO_FONT_ITALIC "
#define PREFS_SERIF_FONT_ITALIC  "SERIF_FONT_ITALIC "
#define PREFS_SANS_FONT_BOLD  "SANS_FONT_BOLD "
#define PREFS_MONO_FONT_BOLD  "MONO_FONT_BOLD "
#define PREFS_SERIF_FONT_BOLD  "SERIF_FONT_BOLD "
#define PREFS_SANS_FONT_BOLD_ITALIC  "SANS_FONT_BOLD_ITALIC "
#define PREFS_MONO_FONT_BOLD_ITALIC  "MONO_FONT_BOLD_ITALIC "
#define PREFS_SERIF_FONT_BOLD_ITALIC  "SERIF_FONT_BOLD_ITALIC "
#define PREFS_SYMBOL_FONT  "SYMBOL_FONT "
#define PREFS_DINGBATS_FONT  "DINGBATS_FONT "
#define PREFS_PAPER_SIZE "PAPER_SIZE"
#define PREFS_PAPER_ORIENT "PAPER_ORIENT"
#define PREFS_PAPER_WIDTH "PAPER_WIDTH"
#define PREFS_PAPER_HEIGHT "PAPER_HEIGHT"
#define PREFS_UNITS "UNITS"
#define PREFS_DRAWGRID "DRAWGRID"
#define PREFS_SNAPGRID "SNAPGRID"
#define PREFS_DYKCOUNT "DYKCOUNT"
#define PREFS_GRIDMODE "GRIDMODE"
#define PREFS_GRIDSPACE "GRIDSPACE"
#define PREFS_LAST_OPENED_FILES "LAST_OPENED_FILES"
#define PREFS_TEXT_DELIM "\""

#define PREFS_RECENT_FILES_LABEL "Recent files"


class Preferences {
 public:
  Preferences();
  void Defaults();

  void setFile(std::string fn, bool fb) ;
  void setSaveFile(std::string fn) ;
  bool LoadPrefs() ;
  bool SavePrefs() ;
  float get_arr_w();
  void set_arr_w(float nw);
  float get_ampiezza_stereo_scon();
  void set_ampiezza_stereo_scon(float nw);
  float get_frequenza_stereo_scon();
  void set_frequenza_stereo_scon(float nw);
  float get_arr_h();
  void set_arr_h(float nw);
  float get_arr_gap();
  void set_arr_gap(float nw);
  float get_multiple_bond_gap();
  void set_multiple_bond_gap(float nw);
  void  set_sensib_leg(int nw);
  void  set_tratteggio_legame(int nw);
  void  set_num_barrette_stereo_down(int nw);
  float get_larg_max_cuneo();
  void set_larg_max_cuneo(float nw);
  float get_larg_min_cuneo();
  float get_width_single_bond();
  void set_width_single_bond(float nw);
  void set_larg_min_cuneo(float nw);
  bool getArrow_fixed() ;
  bool getBond_fixed() ;
  bool getAntialiased() ;
  bool getFixHydrogens() ;
  void setPageSize(int n1) ;
  void setPageOrientation(int n1) ;
  void setFixHydrogens(bool n1) ;
  void setArrow_fixed(bool n1) ;
  void setArrow_fixedlength(double n1) ;
  void setArrow_fixedangle(double n1) ;
  void setBond_fixed(bool n1) ;
  void setBond_fixedlength(double n1) ;
  void setBond_fixedangle(double n1) ;
  void setAntialiased(bool n1) ;
  void setDoubleBondOffset(double n1) ;
  void setPageWidth(int n1) ;
  void setPageHeight(int n1) ;
  void setUnits(int n1) ;
  void setGridMode(int n1) ;
  void setDrawGrid(int n1) ;
  void setSnapGrid(int n1) ;
  void setGridSpacing(int n1) ;
  bool getSplash() ;
  void setSplash(bool n1) ;
  void setDYKCount(int n1) ;
  float getZoom() ;
  void setZoom(float z1) ;
  void setMagnetic_point_gap(int mag_gap) ;

  std::string get_mono_font();
  std::string get_sans_font();
  std::string get_serif_font();
  std::string get_mono_font_bold();
  std::string get_sans_font_bold();
  std::string get_serif_font_bold();
  std::string get_mono_font_italic();
  std::string get_sans_font_italic();
  std::string get_serif_font_italic();
  std::string get_symbol_font();
  std::string get_dingbats_font();
  std::string get_mono_font_bold_italic();
  std::string get_sans_font_bold_italic();
  std::string get_serif_font_bold_italic();



  void set_mono_font(std::string nw);
  void set_sans_font(std::string nw);
  void set_serif_font(std::string nw);
  void set_mono_font_bold(std::string nw);
  void set_sans_font_bold(std::string nw);
  void set_serif_font_bold(std::string nw);
  void set_mono_font_italic(std::string nw);
  void set_sans_font_italic(std::string nw);
  void set_serif_font_italic(std::string nw);
  void set_symbol_font(std::string nw);
  void set_dingbats_font(std::string nw);
  void set_mono_font_bold_italic(std::string nw);
  void set_sans_font_bold_italic(std::string nw);
  void set_serif_font_bold_italic(std::string nw);



  int get_sensib_leg();

  int get_tratteggio_legame();

  int get_num_barrette_stereo_down();

  double getArrow_fixedlength() ;
  double getArrow_fixedangle() ;
  double getBond_fixedlength() ;
  double getBond_fixedangle() ;
  int getPageSize() ;
  int getPageOrientation() ;

  double getDoubleBondOffset() ;

  int getPageWidth() ;

  int getPageHeight() ;

  int getUnits() ;

  int getGridMode() ;

  int getDrawGrid() ;

  int getSnapGrid() ;

  int getGridSpacing() ;

  int getDYKCount() ;

  int getMagnetic_point_gap() ;

  std::vector<std::string> get_last_opened_files();
  void set_last_opened_files(std::string nw);


  static const unsigned int max_opened_files;

 private:

  bool fixed_arrow, fixed_bond, fix_hydrogens;
  bool antialiased;
  bool fallback; // true = file from library directory
  bool splash;  // true = show splashpage
  int dykcount;  // which Did You Know? tip to show
  std::string fileName;  // prefs file name
  std::string saveFileName;  // save file name
  //std::string customRingDir;  // custom ring directory
  double arrow_fixedlength;
  double arrow_fixedangle;
  double bond_fixedlength;
  double bond_fixedangle;
  double dbond_offset;
  int paper_size, paper_orient, paper_dpi;
  int paper_width, paper_height;  // ALWAYS in pixels - convert as needed.
  int units;  // PIXELS, ENGLISH, METRIC - see defs.h
  int gridmode, gridspace, drawgrid, snapgrid;
  float zoom;  // not saved.

  float arr_w;
  float arr_h;
  float arr_gap;
  float multiple_bond_gap;

  int sensib_leg; 
  int tratteggio_legame;
  int num_barrette_stereo_down;

  float ampiezza_stereo_scon;
  float frequenza_stereo_scon;

  float larg_max_cuneo;
  float larg_min_cuneo;

  float width_single_bond;

  int  magnetic_point_gap;

  std::string mono_font;
  std::string sans_font;
  std::string serif_font;


  std::string mono_font_bold;
  std::string sans_font_bold;
  std::string serif_font_bold;


  std::string mono_font_italic;
  std::string sans_font_italic;
  std::string serif_font_italic;


  std::string mono_font_bold_italic;
  std::string sans_font_bold_italic;
  std::string serif_font_bold_italic;


  std::string symbol_font;

  std::string dingbats_font;
 
  std::vector<std::string> _last_opended_files;

  

};


