/*

    Bist: a chemical drawing tool
    Copyright (C) 2008 Valerio Benfante

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#define W_D 630
#define H_D 220
#define W_TREE 288
#define H_TREE 186
#define GAP_ELE 2
#define GAP_BOX 18

void lib_dialog_tree_callback(Fl_Widget* w, void* );



/**
 *Questa  classe rappresenta la  finestra per  sfogliare la  libreria di
 *template
 *
 */


class lib_dialog : public Fl_Double_Window , public finestra_pr {

  friend void lib_dialog_tree_callback(Fl_Widget* w, void* );

public:
  /**
   *Costruttore di default
   */

  lib_dialog();

  void make_tree(string pt);

  /**
   *Distruttore
   */
  virtual ~lib_dialog();
  

  string get_template_file();
  
  virtual Fl_Scroll*  ritorna_scroll();
  virtual immagine*   ritorna_immagine();
  virtual mol_canvas* ritorna_mol_canvas();
  

protected:
  Flu_Tree_Browser* _tree;
  mol_canvas  _preview;
  immagine* _imm;
  Fl_Scroll* _grp;
  string _template_file;
  const static string home_bra;
  const static string share_bra;

};
