/*=====================================================================*/
/*    serrano/prgm/project/bigloo/bde/bmem2.6b/lib/thread.c            */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Wed Jul  2 16:26:24 2003                          */
/*    Last change :  Wed Jul  2 17:05:18 2003 (serrano)                */
/*    Copyright   :  2003 Manuel Serrano                               */
/*    -------------------------------------------------------------    */
/*    Threads monitoring                                               */
/*=====================================================================*/
#define THE_GC NO_GC
#include <bigloo.h>
#include <bmem.h>

/*---------------------------------------------------------------------*/
/*    Number of context switches                                       */
/*---------------------------------------------------------------------*/
static long context_switches = 0;
static long scheduler_awake = 0;

/*---------------------------------------------------------------------*/
/*    void                                                             */
/*    bglasync_scheduler_notify ...                                    */
/*    -------------------------------------------------------------    */
/*    Accumulate the number of times a scheduler is notified           */
/*    by an asynchronous signal.                                       */
/*---------------------------------------------------------------------*/
void
bglasync_scheduler_notify( void *scdl ) {
   scheduler_awake++;
   ____bglasync_scheduler_notify( scdl );
}

/*---------------------------------------------------------------------*/
/*    void                                                             */
/*    bglthread_switch ...                                             */
/*    -------------------------------------------------------------    */
/*    Accumulates the number of fair context switches.                 */
/*---------------------------------------------------------------------*/
void
bglthread_switch( void *this, void *next ) {
   context_switches++;
   ____bglthread_switch( this, next );
}

/*---------------------------------------------------------------------*/
/*    void                                                             */
/*    thread_dump_statistics ...                                       */
/*---------------------------------------------------------------------*/
void
thread_dump_statistics( FILE *f ) {
   if( context_switches || scheduler_awake ) {
      fprintf( f, "  (thread (context-switches %d) (scheduler-awake %d))\n",
	       context_switches, scheduler_awake );
      fprintf( stderr, "thread...(context switches=%d, scheduler awake=%d)\n",
	       context_switches,
	       scheduler_awake );
   }
}


      

   
