;*=====================================================================*/
;*    serrano/prgm/project/bigloo/api/multimedia/src/Llib/mpd.scm      */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Jul 30 16:23:00 2005                          */
;*    Last change :  Thu Sep  7 06:02:24 2006 (serrano)                */
;*    Copyright   :  2005-06 Manuel Serrano                            */
;*    -------------------------------------------------------------    */
;*    MPC implementation                                               */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __multimedia-mpd

   (import __multimedia-music)

   (export (class mpd::music
	      (host read-only (default "localhost"))
	      (port read-only (default 6600))
	      (timeout read-only (default 0))
	      (mpd (default #f))
	      (%socket (default #f)))))

;*---------------------------------------------------------------------*/
;*    mpd-skip-line ...                                                */
;*---------------------------------------------------------------------*/
(define (mpd-skip-line ip)
   (let ((grammar (regular-grammar ((xall (or (out #\Newline #\Return) #a000)))
		     ((: (+ xall) (or #\Newline #\Return))
		      #t)
		     ((: (+ xall) #\Return #\Newline)
		      #t)
		     ((+ xall)
		      #t)
		     ((or #\Newline #\Return (: #\Return #\Newline))
		      #t)
		     (else
		      (the-failure)))))
      (read/rp grammar ip)))

;*---------------------------------------------------------------------*/
;*    mpd-connect! ...                                                 */
;*---------------------------------------------------------------------*/
(define (mpd-connect! mpd::mpd cmd)
   (with-access::mpd mpd (host port timeout %socket)
      (define (ack)
	 (let ((pi (socket-input %socket)))
	    (let loop ((ms 1000))
	       (if (not (char-ready? pi))
		   (if (<=fx ms 0)
		       (begin
			  (socket-close %socket)
			  (raise
			   (instantiate::&io-error
			      (proc cmd)
			      (msg "Can't establish connection")
			      (obj mpd))))
		       (begin
			  (sleep ms)
			  (loop 0)))
		   (let ((l (read-line pi)))
		      (unless (and (string? l) (substring-at? l "OK MPD" 0))
			 (raise
			  (instantiate::&io-parse-error
			     (proc cmd)
			     (msg "Illegal MPD acknowledge")
			     (obj l))))
		      (substring l 6 (string-length l)))))))
      (if (and (socket? %socket) (not (socket-down? %socket)))
	  (begin
	     ;; check if the connection is still up
	     (mpd-cmd mpd "ping")
	     (let ((l (mpd-skip-line (socket-input (mpd-%socket mpd)))))
		(when (eof-object? l)
		   (set! %socket (make-client-socket host port :timeout timeout))
		   (mpd-mpd-set! mpd (ack)))))
	  (begin
	     (set! %socket (make-client-socket host port))
	     (mpd-mpd-set! mpd (ack))))))

;*---------------------------------------------------------------------*/
;*    *mpd-string-grammar* ...                                         */
;*---------------------------------------------------------------------*/
(define *mpd-string-grammar*
   (regular-grammar ()
      ((* blank)
       (ignore))
      ((: (out " \r\n") (+ (out "\n")) #\Newline)
       (the-substring 0 -1))
      (else
       (raise
	(instantiate::&io-parse-error
	   (proc 'mpd)
	   (msg "Illegal string value")
	   (obj (the-failure)))))))

;*---------------------------------------------------------------------*/
;*    *mpd-symbol-grammar* ...                                         */
;*---------------------------------------------------------------------*/
(define *mpd-symbol-grammar*
   (regular-grammar ()
      ((* blank)
       (ignore))
      ((: (out " \r\n") (+ (out "\n")) #\Newline)
       (the-subsymbol 0 -1))
      (else
       (raise
	(instantiate::&io-parse-error
	   (proc 'mpd)
	   (msg "Illegal string value")
	   (obj (the-failure)))))))

;*---------------------------------------------------------------------*/
;*    *mpd-ignore-grammar* ...                                         */
;*---------------------------------------------------------------------*/
(define *mpd-ignore-grammar*
   (regular-grammar ()
      ((* blank)
       (ignore))
      ((: (* all) #\Newline)
       #unspecified)
      (else
       (raise
	(instantiate::&io-parse-error
	   (proc 'mpd)
	   (msg "Illegal ignore value")
	   (obj (the-failure)))))))

;*---------------------------------------------------------------------*/
;*    *mpd-value-grammar* ...                                          */
;*---------------------------------------------------------------------*/
(define *mpd-value-grammar*
   (regular-grammar ()
      ((* blank)
       (ignore))
      ((: (* all) #\Newline)
       (the-substring 0 -1))
      (else
       (raise
	(instantiate::&io-parse-error
	   (proc 'mpd)
	   (msg "Illegal ignore value")
	   (obj (the-failure)))))))

;*---------------------------------------------------------------------*/
;*    *mpd-integer-grammar* ...                                        */
;*---------------------------------------------------------------------*/
(define *mpd-integer-grammar*
   (regular-grammar ()
      ((* blank)
       (ignore))
      ((: (+ digit) #\Newline)
       (the-fixnum))
      (else
       (raise
	(instantiate::&io-parse-error
	   (proc 'mpd)
	   (msg "Illegal integer")
	   (obj (the-failure)))))))

;*---------------------------------------------------------------------*/
;*    *mpd-time-grammar* ...                                           */
;*---------------------------------------------------------------------*/
(define *mpd-time-grammar*
   (regular-grammar ()
      ((* blank)
       (ignore))
      ((: (+ digit) ":")
       (let* ((tm (the-fixnum))
	      (len (read/rp *mpd-integer-grammar* (the-port))))
	  (values tm len)))
      (else
       (raise
	(instantiate::&io-parse-error
	   (proc 'mpd)
	   (msg "Illegal integer")
	   (obj (the-failure)))))))

;*---------------------------------------------------------------------*/
;*    *mpd-ellapsed-grammar* ...                                       */
;*---------------------------------------------------------------------*/
(define *mpd-ellapsed-grammar*
   (regular-grammar ()
      ((* blank)
       (ignore))
      ((: (+ digit) ":")
       (let ((v (the-fixnum)))
	  (read/rp *mpd-integer-grammar* (the-port))
	  v))
      (else
       (raise
	(instantiate::&io-parse-error
	   (proc 'mpd)
	   (msg "Illegal integer")
	   (obj (the-failure)))))))

;*---------------------------------------------------------------------*/
;*    *mpd-playlist-grammar* ...                                       */
;*---------------------------------------------------------------------*/
(define *mpd-playlist-grammar*
   (regular-grammar ()
      ((: (+ digit) #\:)
       (read/rp *mpd-string-grammar* (the-port)))
      ("OK\n"
       'ok)
      (else
       (raise
	(instantiate::&io-parse-error
	   (proc 'mpd-playlist-get)
	   (msg "Illegal playlist value")
	   (obj (the-failure)))))))

;*---------------------------------------------------------------------*/
;*    *mpd-song-grammar* ...                                           */
;*---------------------------------------------------------------------*/
(define *mpd-song-grammar*
   (regular-grammar ()
      ((: (+ alpha) #\:)
       (let ((k (the-keyword)))
	  (case k
	     ((file:)
	      (cons k (read/rp *mpd-string-grammar* (the-port))))
	     ((Title:)
	      (cons title: (read/rp *mpd-string-grammar* (the-port))))
	     ((Name:)
	      (cons name: (read/rp *mpd-string-grammar* (the-port))))
	     ((Id:)
	      (cons id: (read/rp *mpd-integer-grammar* (the-port))))
	     ((Pos:)
	      (cons pos: (read/rp *mpd-integer-grammar* (the-port))))
	     ((Track:)
	      (cons track: (read/rp *mpd-integer-grammar* (the-port))))
	     ((Time:)
	      (cons time: (read/rp *mpd-integer-grammar* (the-port))))
	     (else
	      (read/rp *mpd-ignore-grammar* (the-port))
	      (ignore)))))
      ("OK\n"
       'ok)
      (else
       (raise
	(instantiate::&io-parse-error
	   (proc 'mpd-song)
	   (msg "Illegal song status")
	   (obj (string-append (string (the-failure)) (read-line (the-port)))))))))

;*---------------------------------------------------------------------*/
;*    *mpd-khz-grammar* ...                                            */
;*---------------------------------------------------------------------*/
(define *mpd-khz-grammar*
   (regular-grammar ()
      ((+ (in " \t"))
       (ignore))
      ((+ digit)
       (let ((n (the-fixnum)))
	  (read/rp *mpd-ignore-grammar* (the-port))
	  n))
      (else
       (raise
	(instantiate::&io-parse-error
	   (proc 'mpd-song)
	   (msg "Illegal khz")
	   (obj (string-append (string (the-failure)) (read-line (the-port)))))))))

;*---------------------------------------------------------------------*/
;*    *mpd-info-grammar* ...                                           */
;*---------------------------------------------------------------------*/
(define *mpd-info-grammar*
   (regular-grammar (playlist song pos len volume state err bitrate khz)
      ("OK\n"
       (values state playlist song pos len volume err bitrate khz))
      ((: (+ alpha) #\:)
       (let ((k (the-keyword)))
	  (case k
	     ((state:)
	      (set! state (read/rp *mpd-symbol-grammar* (the-port)))
	      (ignore))
	     ((song:)
	      (set! song (read/rp *mpd-integer-grammar* (the-port)))
	      (ignore))
	     ((time:)
	      (multiple-value-bind (p l)
		 (read/rp *mpd-time-grammar* (the-port))
		 (set! pos p)
		 (set! len l)
		 (ignore)))
	     ((volume:)
	      (set! volume (read/rp *mpd-integer-grammar* (the-port)))
	      (ignore))
	     ((playlistlength:)
	      (set! playlist (read/rp *mpd-integer-grammar* (the-port)))
	      (ignore))
	     ((error:)
	      (set! err (read/rp *mpd-value-grammar* (the-port)))
	      (ignore))
	     ((bitrate:)
	      (set! bitrate (read (the-port)))
	      (ignore))
	     ((audio:)
	      (set! khz (read/rp *mpd-khz-grammar* (the-port)))
	      (ignore))
	     (else
	      (read/rp *mpd-ignore-grammar* (the-port))
	      (ignore)))))
      ((+ #\Newline)
       (ignore))
      (else
       (raise
	(instantiate::&io-parse-error
	   (proc 'mpd-info)
	   (msg "Illegal info")
	   (obj (string-append (string (the-failure)) (read-line (the-port)))))))))

;*---------------------------------------------------------------------*/
;*    *mpd-status-time-grammar* ...                                    */
;*---------------------------------------------------------------------*/
(define *mpd-status-time-grammar*
   (regular-grammar ()
      ((: (+ alpha) #\:)
       (let ((k (the-keyword)))
	  (case k
	     ((time:)
	      (read/rp *mpd-ellapsed-grammar* (the-port)))
	     (else
	      (read/rp *mpd-ignore-grammar* (the-port))
	      (ignore)))))
      ("OK\n"
       'ok)
      (else
       (raise
	(instantiate::&io-parse-error
	   (proc 'mpd-time)
	   (msg "Illegal status")
	   (obj (string-append (string (the-failure)) (read-line (the-port)))))))))

;*---------------------------------------------------------------------*/
;*    *mpd-status-volume-grammar* ...                                  */
;*---------------------------------------------------------------------*/
(define *mpd-status-volume-grammar*
   (regular-grammar ()
      ((: (+ alpha) #\:)
       (let ((k (the-keyword)))
	  (case k
	     ((volume:)
	      (read/rp *mpd-integer-grammar* (the-port)))
	     (else
	      (read/rp *mpd-ignore-grammar* (the-port))
	      (ignore)))))
      ("OK\n"
       'ok)
      (else
       (raise
	(instantiate::&io-parse-error
	   (proc 'mpd-volume)
	   (msg "Illegal status")
	   (obj (string-append (string (the-failure)) (read-line (the-port)))))))))

;*---------------------------------------------------------------------*/
;*    mpd-ok ...                                                       */
;*---------------------------------------------------------------------*/
(define (mpd-ok mpd::mpd)
   (let* ((pi (socket-input (mpd-%socket mpd)))
	  (l (read-line pi)))
      (substring-at? l "OK" 0)))
   
;*---------------------------------------------------------------------*/
;*    mpd-cmd ...                                                      */
;*---------------------------------------------------------------------*/
(define (mpd-cmd mpd::mpd cmd::bstring)
   (let ((po (socket-output (mpd-%socket mpd))))
      (display-string cmd po)
      (newline po)
      (flush-output-port po)))
    
;*---------------------------------------------------------------------*/
;*    music-close ::mpd ...                                            */
;*---------------------------------------------------------------------*/
(define-method (music-close mpd::mpd)
   (with-access::mpd mpd (%socket)
      (when (socket? %socket)
	 (mpd-cmd mpd "ping")
	 (let ((l (read-line (socket-input (mpd-%socket mpd)))))
	    (unless (eof-object? l)
	       (mpd-cmd mpd "close"))
	    (socket-close %socket)
	    (set! %socket #f)))))

;*---------------------------------------------------------------------*/
;*    music-abort ::mpd ...                                            */
;*---------------------------------------------------------------------*/
(define-method (music-abort mpd::mpd)
   (with-access::mpd mpd (%socket)
      (when (socket? %socket)
	 (socket-close %socket)
	 (set! %socket #f))))

;*---------------------------------------------------------------------*/
;*    music-playlist-get ::mpd ...                                     */
;*---------------------------------------------------------------------*/
(define-method (music-playlist-get mpd::mpd)
   (mpd-connect! mpd 'music-playlist-get)
   (mpd-cmd mpd "playlist")
   (let ((ip (socket-input (mpd-%socket mpd))))
      (let loop ((ser '()))
	 (let ((l (read/rp *mpd-playlist-grammar* ip)))
	    (if (eq? l 'ok)
		(reverse! ser)
		(loop (cons l ser)))))))

;*---------------------------------------------------------------------*/
;*    music-playlist-add! ::mpd ...                                    */
;*---------------------------------------------------------------------*/
(define-method (music-playlist-add! mpd::mpd song)
   (mpd-connect! mpd 'music-playlist-add!)
   (mpd-cmd mpd (string-append "add \"" song "\""))
   (mpd-ok mpd))

;*---------------------------------------------------------------------*/
;*    music-playlist-delete! ::mpd ...                                 */
;*---------------------------------------------------------------------*/
(define-method (music-playlist-delete! mpd::mpd num)
   (mpd-connect! mpd 'music-playlist-delete!)
   (mpd-cmd mpd (string-append "delete " (integer->string num)))
   (mpd-ok mpd))

;*---------------------------------------------------------------------*/
;*    music-playlist-clear! ::mpd ...                                  */
;*---------------------------------------------------------------------*/
(define-method (music-playlist-clear! mpd::mpd)
   (mpd-connect! mpd 'music-playlist-clear!)
   (mpd-cmd mpd "clear")
   (mpd-ok mpd))

;*---------------------------------------------------------------------*/
;*    music-properties ::mpd ...                                       */
;*---------------------------------------------------------------------*/
(define-method (music-properties mpd::mpd)
   (multiple-value-bind (state playlist song pos len vol err bitrate khz)
      (music-info mpd)
      (list (cons :state state)
	    (cons :playlist playlist)
	    (cons :song song)
	    (cons :pos pos)
	    (cons :len len)
	    (cons :vol vol)
	    (cons :err err)
	    (cons :bitrate bitrate)
	    (cons :khz khz))))

;*---------------------------------------------------------------------*/
;*    music-info ::mpd ...                                             */
;*---------------------------------------------------------------------*/
(define-method (music-info mpd::mpd)
   (mpd-connect! mpd 'music-info)
   (mpd-cmd mpd "status")
   (let ((ip (socket-input (mpd-%socket mpd))))
      (read/rp *mpd-info-grammar* ip 0 0 0 1 -1
	       #unspecified #unspecified #unspecified 0)))

;*---------------------------------------------------------------------*/
;*    music-song ::mpd ...                                             */
;*---------------------------------------------------------------------*/
(define-method (music-song mpd::mpd)
   (mpd-connect! mpd 'music-song)
   (mpd-cmd mpd "currentsong")
   (let ((ip (socket-input (mpd-%socket mpd))))
      (let loop ((ser '()))
	 (let ((l (read/rp *mpd-song-grammar* ip)))
	    (if (eq? l 'ok)
		(reverse! ser)
		(loop (cons l ser)))))))

;*---------------------------------------------------------------------*/
;*    music-time ::mpd ...                                             */
;*---------------------------------------------------------------------*/
(define-method (music-time::int mpd::mpd)
   (mpd-connect! mpd 'music-time)
   (mpd-cmd mpd "status")
   (let ((ip (socket-input (mpd-%socket mpd))))
      (let loop ((tm -1))
	 (let ((l (read/rp *mpd-status-time-grammar* ip)))
	    (cond
	       ((integer? l)
		(loop l))
	       ((eq? l 'ok)
		tm)
	       (else
		(loop tm)))))))

;*---------------------------------------------------------------------*/
;*    music-play ::mpd ...                                             */
;*---------------------------------------------------------------------*/
(define-method (music-play mpd::mpd . song)
   (mpd-connect! mpd 'music-play)
   (mpd-cmd mpd (if (null? song) "play" (format "play ~a" (car song))))
   (mpd-ok mpd))

;*---------------------------------------------------------------------*/
;*    music-seek ::mpd ...                                             */
;*---------------------------------------------------------------------*/
(define-method (music-seek mpd::mpd time::obj . song)
   (mpd-connect! mpd 'music-seek)
   (multiple-value-bind (_ s t _ _ _)
      (music-info mpd)
      (let ((song (if (null? song) s (car song)))
	    (time (if (fixnum? time)
		      time
		      (+ (if (pair? t) (car t) t) (flonum->fixnum time)))))
	 (mpd-cmd mpd (format "seek ~a ~a" song time))))
   (mpd-ok mpd))

;*---------------------------------------------------------------------*/
;*    music-stop ::mpd ...                                             */
;*---------------------------------------------------------------------*/
(define-method (music-stop mpd::mpd)
   (mpd-connect! mpd 'music-stop)
   (mpd-cmd mpd "stop")
   (mpd-ok mpd)
   (mpd-cmd mpd "clearerror")
   (mpd-ok mpd))

;*---------------------------------------------------------------------*/
;*    music-pause ::mpd ...                                            */
;*---------------------------------------------------------------------*/
(define-method (music-pause mpd::mpd)
   (mpd-connect! mpd 'music-pause)
   (mpd-cmd mpd "pause")
   (mpd-ok mpd))

;*---------------------------------------------------------------------*/
;*    music-next ::mpd ...                                             */
;*---------------------------------------------------------------------*/
(define-method (music-next mpd::mpd)
   (mpd-connect! mpd 'music-next)
   (mpd-cmd mpd "next")
   (mpd-ok mpd))

;*---------------------------------------------------------------------*/
;*    music-prev ::mpd ...                                             */
;*---------------------------------------------------------------------*/
(define-method (music-prev mpd::mpd)
   (mpd-connect! mpd 'music-prev)
   (mpd-cmd mpd "previous")
   (mpd-ok mpd))

;*---------------------------------------------------------------------*/
;*    music-volume-get ::mpd ...                                       */
;*---------------------------------------------------------------------*/
(define-method (music-volume-get mpd::mpd)
   (mpd-connect! mpd 'music-volume-get)
   (mpd-cmd mpd "status")
   (let ((ip (socket-input (mpd-%socket mpd))))
      (let loop ((tm -1))
	 (let ((l (read/rp *mpd-status-volume-grammar* ip)))
	    (cond
	       ((integer? l)
		(loop l))
	       ((eq? l 'ok)
		tm)
	       (else
		(loop tm)))))))

;*---------------------------------------------------------------------*/
;*    music-volume-set! ::mpd ...                                      */
;*---------------------------------------------------------------------*/
(define-method (music-volume-set! mpd::mpd vol::int)
   (mpd-connect! mpd 'music-volume-set!)
   (mpd-cmd mpd (string-append "setvol " (integer->string vol)))
   (mpd-ok mpd))



   
