/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime/Clib/ceval.c                 */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Fri Sep 24 10:20:30 1993                          */
/*    Last change :  Fri Nov 14 17:35:45 2003 (serrano)                */
/*    -------------------------------------------------------------    */
/*    Quelques petites fonctions pour l'interprete (principalement     */
/*    des fonctions de debug et de trace)                              */
/*=====================================================================*/
#include <bigloo.h>

/*---------------------------------------------------------------------*/
/*    Une recup ...                                                    */
/*---------------------------------------------------------------------*/
extern long  bgl_list_length();

/*---------------------------------------------------------------------*/
/*    void                                                             */
/*    bgl_init_eval_cnst ...                                           */
/*---------------------------------------------------------------------*/
void
bgl_init_eval_cnst() {
   ;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    funcall_0 ...                                                    */
/*---------------------------------------------------------------------*/
obj_t
eval_funcall_0( obj_t fun ) {
   return PROCEDURE_ENTRY( fun )( fun, BEOA );
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    funcall_1 ...                                                    */
/*---------------------------------------------------------------------*/
obj_t
eval_funcall_1( obj_t fun, obj_t a0 ) {
   return PROCEDURE_ENTRY( fun )( fun, a0, BEOA );
}
       
/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    funcall_2 ...                                                    */
/*---------------------------------------------------------------------*/
obj_t
eval_funcall_2( obj_t fun, obj_t a0, obj_t a1 ) {
   return PROCEDURE_ENTRY( fun )( fun, a0, a1, BEOA );
}
       
/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    funcall_3 ...                                                    */
/*---------------------------------------------------------------------*/
obj_t
eval_funcall_3( obj_t fun, obj_t a0, obj_t a1, obj_t a2 ) {
   return PROCEDURE_ENTRY( fun )( fun, a0, a1, a2, BEOA );
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    funcall_4 ...                                                    */
/*---------------------------------------------------------------------*/
obj_t
eval_funcall_4( obj_t fun, obj_t a0, obj_t a1, obj_t a2, obj_t a3 ) {
   return PROCEDURE_ENTRY( fun )( fun, a0, a1, a2, a3, BEOA );
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    eval_apply ...                                                   */
/*---------------------------------------------------------------------*/
BGL_RUNTIME_DEF
obj_t
eval_apply( obj_t fun, obj_t list ) {
   return apply( fun, list );
}
