;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bde/afile/afile.scm                  */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar 17 10:49:15 1993                          */
;*    Last change :  Fri Jul  4 14:56:39 2003 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Module access file generator.                                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module afile (main main))

;*---------------------------------------------------------------------*/
;*    Global variables                                                 */
;*---------------------------------------------------------------------*/
(define *verbose*    #f)
(define *suffixes*   '("scm" "sch" "bgl"))
(define *gui-suffix* "bld")
 
;*---------------------------------------------------------------------*/
;*    main ...                                                         */
;*---------------------------------------------------------------------*/
(define (main argv)
   (if (or (null?    (cdr argv))
	   (string=? (cadr argv) "-help"))
       (usage)
       (let loop ((files        (cdr argv))
		  (access-list '())
		  (output-file '())
		  (paths       '("" ".")))
	  (cond
	     ((null? files)
	      (output access-list output-file paths))
	     ((string=? (car files) "-v")
	      (set! *verbose* #t)
	      (loop (cdr files) 
		    access-list
		    output-file
		    paths))
	     ((string=? (car files) "-o")
	      (if (null? (cdr files))
		  (usage)
		  (loop (cddr files)
			access-list
			(cadr files)
			paths)))
	     ((string=? (car files) "-I")
	      (if (null? (cdr files))
		  (usage)
		  (loop (cddr files)
			access-list
			output-file
			(cons (cadr files) paths))))
	     ((string=? (car files) "-suffix")
	      (if (null? (cdr files))
		  (usage)
		  (begin
		     (set! *suffixes* (cons (cadr files) *suffixes*))
		     (loop (cddr files)
			   access-list
			   output-file
			   paths))))
	     ((string=? (car files) "-gui-suffix")
	      (set! *gui-suffix* (car files))
	      (loop (cddr files)
		    access-list
		    output-file
		    paths))
	     (else
	      (loop (cdr files)
		    (cons (car files) access-list)
		    output-file
		    paths))))))

;*---------------------------------------------------------------------*/
;*    my-open-input-file ...                                           */
;*---------------------------------------------------------------------*/
(define (my-open-input-file file-name)
   (if *verbose*
       (print file-name ":"))
   (open-input-file file-name))
 
;*---------------------------------------------------------------------*/
;*    output ...                                                       */
;*---------------------------------------------------------------------*/
(define (output access-list output-file path)
   (let ((port (let ((p (if (string? output-file)
			    (begin
			       (if (file-exists? output-file)
				   (rename-file output-file
						(string-append output-file
							       "~")))
			       (open-output-file output-file))
			    #f)))
		  (if (not (output-port? p))
		      (current-output-port)
		      p))))
      (fprint port
	      ";; " (pwd) #\Newline
	      ";; " (date) #\Newline #\Newline
	      #\()
      (let loop ((access-list access-list))
	 (if (null? access-list)
	     (fprint port #\) #\Newline)
	     (let ((suf (suffix (car access-list))))
		(cond
		   ((member suf *suffixes*)
		    (let ((f (find-file/path (car access-list) path)))
		       (fprint port
			       "  ("
			       (string-downcase
				(symbol->string
				 (find-module-name
				  f
				  (car access-list))))
			       " "
			       #\" f #\" #\))))
		   ((string=? suf *gui-suffix*)
		    (let ((f (find-file/path (car access-list) path)))
		       (fprint port
			       "  ("
			       (string-downcase
				(symbol->string
				 (find-gui-module-name f)))
			       " "
			       #\" (string-append (prefix f) ".scm")
			       #\" #\)))))
		(loop (cdr access-list)))))))
	  
;*---------------------------------------------------------------------*/
;*    find-module-name ...                                             */
;*---------------------------------------------------------------------*/
(define (find-module-name file name)
   (if (not (and (string? file) (file-exists? file)))
       (begin
	  (fprint (current-error-port) "*** ERROR:afile:" #\Newline
		  "Can't find file -- " (if (string? file) file name))
	  'no-such-module)
       (let ((port (my-open-input-file file)))
	  (if (not (input-port? port))
	      (begin
		 (fprint (current-error-port) "*** ERROR:afile:" #\Newline
			 "Can't open file -- " file)
		 'no-such-module)
	      (let ((exp (read port)))
		 (match-case exp
		    ((module ?module-name . ?-)
		     (close-input-port port)
		     module-name)
		    (else
		     (close-input-port port)
		     (fprint (current-error-port) "*** ERROR:afile:" #\Newline
			     "Illegal file format -- " file)
		     'illegal-file-format)))))))

;*---------------------------------------------------------------------*/
;*    find-gui-module-name ...                                         */
;*---------------------------------------------------------------------*/
(define (find-gui-module-name file)
   (if (not (file-exists? file))
       (begin
	  (fprint (current-error-port) "*** ERROR:afile:" #\Newline
		  "Can't find file -- " file)
	  'no-such-module)
       (with-input-from-file file
	  (lambda ()
	     (read)))))
   
;*---------------------------------------------------------------------*/
;*    usage ...                                                        */
;*---------------------------------------------------------------------*/
(define (usage)
   (print "usage: afile [-o output] [-suffix suf] [-gui-suffix suf] [-I path] file ...")
   (exit -1))
