/*===========================================================================*/
/*   (Ieee/string.scm)                                                       */
/*   Bigloo (2.4b)                                                           */
/*   Manuel Serrano (c)       Mon Dec 10 19:08:43 CET 2001                   */
/*===========================================================================*/

/* GC selection */
#define THE_GC BOEHM_GC

#include <bigloo.h>
#include <signal.h>

static obj_t BGl__blitzd2stringz12zc0zz__r4_strings_6_7z00(obj_t, obj_t, obj_t, obj_t, obj_t, obj_t);
extern obj_t BGl_stringz00zz__r4_strings_6_7z00(obj_t);
extern obj_t BGl_modulezd2initializa7ationz75zz__r4_strings_6_7z00(long, char *);
extern obj_t BGl_modulezd2initializa7ationz75zz__errorz00(long, char *);
extern bool_t BGl_stringzc3zf3z30zz__r4_strings_6_7z00(obj_t, obj_t);
static obj_t BGl__makezd2stringzd2zz__r4_strings_6_7z00(obj_t, obj_t, obj_t);
extern unsigned char BGl_stringzd2refzd2urz00zz__r4_strings_6_7z00(obj_t, int);
extern obj_t make_string(int, unsigned char);
extern obj_t BGl_stringzd2capitaliza7ez75zz__r4_strings_6_7z00(obj_t);
extern bool_t BGl_stringzd3zf3z20zz__r4_strings_6_7z00(obj_t, obj_t);
static obj_t BGl__stringzd2upcasezd2zz__r4_strings_6_7z00(obj_t, obj_t);
extern obj_t BGl_stringzd2copyzd2zz__r4_strings_6_7z00(obj_t);
static obj_t BGl__stringzd2cizc3zd3zf3z31zz__r4_strings_6_7z00(obj_t, obj_t, obj_t);
extern obj_t BGl_listzd2ze3stringz31zz__r4_strings_6_7z00(obj_t);
extern bool_t BGl_stringze3zf3z10zz__r4_strings_6_7z00(obj_t, obj_t);
static obj_t BGl__stringzf3zf3zz__r4_strings_6_7z00(obj_t, obj_t);
extern bool_t bigloo_strncmp(obj_t, obj_t, int);
extern long bgl_list_length(obj_t);
extern bool_t BGl_stringzd2cizc3zf3ze2zz__r4_strings_6_7z00(obj_t, obj_t);
static obj_t BGl__substringz00zz__r4_strings_6_7z00(obj_t, obj_t, obj_t, obj_t);
extern bool_t BGl_stringze3zd3zf3zc3zz__r4_strings_6_7z00(obj_t, obj_t);
static obj_t BGl__stringzc3zf3z30zz__r4_strings_6_7z00(obj_t, obj_t, obj_t);
static obj_t BGl__stringzd2upcasez12zc0zz__r4_strings_6_7z00(obj_t, obj_t);
extern bool_t BGl_stringzd2cizd3zf3zf2zz__r4_strings_6_7z00(obj_t, obj_t);
extern obj_t BGl_stringzd2forzd2readz00zz__r4_strings_6_7z00(obj_t);
static obj_t BGl__stringzd3zf3z20zz__r4_strings_6_7z00(obj_t, obj_t, obj_t);
extern obj_t string_for_read(obj_t);
extern bool_t BGl_stringzd2cize3zf3zc2zz__r4_strings_6_7z00(obj_t, obj_t);
extern bool_t BGl_stringzf3zf3zz__r4_strings_6_7z00(obj_t);
extern bool_t string_ge(obj_t, obj_t);
extern obj_t BGl_stringzd2capitaliza7ez12z67zz__r4_strings_6_7z00(obj_t);
static obj_t BGl__stringze3zf3z10zz__r4_strings_6_7z00(obj_t, obj_t, obj_t);
extern bool_t string_cige(obj_t, obj_t);
extern bool_t bigloo_strcmp(obj_t, obj_t);
extern bool_t string_gt(obj_t, obj_t);
extern obj_t BGl_stringzd2setz12zc0zz__r4_strings_6_7z00(obj_t, int, unsigned char);
extern bool_t string_cigt(obj_t, obj_t);
extern obj_t BGl_stringzd2downcasezd2zz__r4_strings_6_7z00(obj_t);
static obj_t BGl__stringzd2capitaliza7ez12z67zz__r4_strings_6_7z00(obj_t, obj_t);
extern obj_t c_substring(obj_t, int, int);
static obj_t BGl__stringzd2downcasezd2zz__r4_strings_6_7z00(obj_t, obj_t);
extern obj_t BGl_stringzd2upcasez12zc0zz__r4_strings_6_7z00(obj_t);
static obj_t BGl__stringzd2copyzd2zz__r4_strings_6_7z00(obj_t, obj_t);
static obj_t BGl__stringzc3zd3zf3ze3zz__r4_strings_6_7z00(obj_t, obj_t, obj_t);
extern obj_t BGl_stringzd2upcasezd2zz__r4_strings_6_7z00(obj_t);
static obj_t BGl__stringzd2refzd2urz00zz__r4_strings_6_7z00(obj_t, obj_t, obj_t);
extern obj_t BGl_substringzd2urzd2zz__r4_strings_6_7z00(obj_t, int, int);
static obj_t BGl__emptyzd2stringzf3z21zz__r4_strings_6_7z00(obj_t, obj_t);
extern bool_t bigloo_strncmp_ci(obj_t, obj_t, int);
extern bool_t string_le(obj_t, obj_t);
static obj_t BGl__stringzd2cizc3zf3ze2zz__r4_strings_6_7z00(obj_t, obj_t, obj_t);
extern bool_t string_cile(obj_t, obj_t);
static obj_t BGl__substringzd2cizd3zf3zf2zz__r4_strings_6_7z00(obj_t, obj_t, obj_t, obj_t);
static obj_t BGl__stringz00zz__r4_strings_6_7z00(obj_t, obj_t);
static obj_t BGl__stringzd2cizd3zf3zf2zz__r4_strings_6_7z00(obj_t, obj_t, obj_t);
static obj_t BGl__stringzd2forzd2readz00zz__r4_strings_6_7z00(obj_t, obj_t);
extern unsigned char BGl_stringzd2refzd2zz__r4_strings_6_7z00(obj_t, int);
extern bool_t BGl_substringzd3zf3z20zz__r4_strings_6_7z00(obj_t, obj_t, int);
static obj_t BGl__stringzd2cize3zd3zf3z11zz__r4_strings_6_7z00(obj_t, obj_t, obj_t);
extern bool_t string_lt(obj_t, obj_t);
static obj_t BGl__stringzd2ze3listz31zz__r4_strings_6_7z00(obj_t, obj_t);
extern bool_t string_cilt(obj_t, obj_t);
extern obj_t BGl_stringzd2appendzd2zz__r4_strings_6_7z00(obj_t);
static obj_t BGl_importedzd2moduleszd2initz00zz__r4_strings_6_7z00();
static obj_t BGl__stringzd2fillz12zc0zz__r4_strings_6_7z00(obj_t, obj_t, obj_t);
static obj_t BGl__blitzd2stringzd2urz12z12zz__r4_strings_6_7z00(obj_t, obj_t, obj_t, obj_t, obj_t, obj_t);
static obj_t BGl__stringzd2cize3zf3zc2zz__r4_strings_6_7z00(obj_t, obj_t, obj_t);
static obj_t BGl__stringzd2lengthzd2zz__r4_strings_6_7z00(obj_t, obj_t);
extern obj_t BGl_blitzd2stringz12zc0zz__r4_strings_6_7z00(obj_t, int, obj_t, int, int);
extern bool_t BGl_stringzc3zd3zf3ze3zz__r4_strings_6_7z00(obj_t, obj_t);
extern obj_t blit_string(obj_t, int, obj_t, int, int);
static obj_t BGl__stringzd2setz12zc0zz__r4_strings_6_7z00(obj_t, obj_t, obj_t, obj_t);
static obj_t BGl_requirezd2initializa7ationz75zz__r4_strings_6_7z00 = BUNSPEC;
extern bool_t BGl_stringzd2cizc3zd3zf3z31zz__r4_strings_6_7z00(obj_t, obj_t);
static obj_t BGl__listzd2ze3stringz31zz__r4_strings_6_7z00(obj_t, obj_t);
static obj_t BGl__stringzd2setzd2urz12z12zz__r4_strings_6_7z00(obj_t, obj_t, obj_t, obj_t);
static obj_t BGl__stringzd2refzd2zz__r4_strings_6_7z00(obj_t, obj_t, obj_t);
extern obj_t BGl_makezd2stringzd2zz__r4_strings_6_7z00(int, obj_t);
extern bool_t strcicmp(obj_t, obj_t);
extern obj_t BGl_stringzd2downcasez12zc0zz__r4_strings_6_7z00(obj_t);
extern obj_t make_string_sans_fill(int);
static obj_t BGl__substringzd3zf3z20zz__r4_strings_6_7z00(obj_t, obj_t, obj_t, obj_t);
static obj_t BGl__stringze3zd3zf3zc3zz__r4_strings_6_7z00(obj_t, obj_t, obj_t);
extern bool_t BGl_substringzd2cizd3zf3zf2zz__r4_strings_6_7z00(obj_t, obj_t, int);
extern obj_t BGl_substringz00zz__r4_strings_6_7z00(obj_t, int, int);
extern obj_t BGl_stringzd2setzd2urz12z12zz__r4_strings_6_7z00(obj_t, int, unsigned char);
static obj_t BGl__stringzd2downcasez12zc0zz__r4_strings_6_7z00(obj_t, obj_t);
extern obj_t BGl_blitzd2stringzd2urz12z12zz__r4_strings_6_7z00(obj_t, int, obj_t, int, int);
extern bool_t BGl_emptyzd2stringzf3z21zz__r4_strings_6_7z00(obj_t);
static obj_t BGl__substringzd2urzd2zz__r4_strings_6_7z00(obj_t, obj_t, obj_t, obj_t);
static obj_t BGl__stringzd2capitaliza7ez75zz__r4_strings_6_7z00(obj_t, obj_t);
extern bool_t BGl_stringzd2cize3zd3zf3z11zz__r4_strings_6_7z00(obj_t, obj_t);
extern int BGl_stringzd2lengthzd2zz__r4_strings_6_7z00(obj_t);
extern obj_t BGl_stringzd2ze3listz31zz__r4_strings_6_7z00(obj_t);
extern obj_t BGl_stringzd2fillz12zc0zz__r4_strings_6_7z00(obj_t, unsigned char);
static obj_t BGl__stringzd2appendzd2zz__r4_strings_6_7z00(obj_t, obj_t);
static obj_t *__cnst;

DEFINE_EXPORT_PROCEDURE( BGl_substringzd2urzd2envz00zz__r4_strings_6_7z00, BgL_bgl__substringza7d2urza7d2za7za7__r4_strings_6_7za7001250za7, BGl__substringzd2urzd2zz__r4_strings_6_7z00, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( BGl_stringzd2fillz12zd2envz12zz__r4_strings_6_7z00, BgL_bgl__stringza7d2fillza712za7c0za7za7__r4_strings_6_7za7001251z00, BGl__stringzd2fillz12zc0zz__r4_strings_6_7z00, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( BGl_blitzd2stringz12zd2envz12zz__r4_strings_6_7z00, BgL_bgl__blitza7d2stringza712za7c0za7za7__r4_strings_6_7za7001252z00, BGl__blitzd2stringz12zc0zz__r4_strings_6_7z00, 0L, 5 );
DEFINE_EXPORT_PROCEDURE( BGl_listzd2ze3stringzd2envze3zz__r4_strings_6_7z00, BgL_bgl__listza7d2za7e3stringza731za7za7__r4_strings_6_7za7001253z00, BGl__listzd2ze3stringz31zz__r4_strings_6_7z00, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( BGl_stringzd2copyzd2envz00zz__r4_strings_6_7z00, BgL_bgl__stringza7d2copyza7d2za7za7__r4_strings_6_7za7001254za7, BGl__stringzd2copyzd2zz__r4_strings_6_7z00, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( BGl_stringzd2cizc3zd3zf3zd2envze3zz__r4_strings_6_7z00, BgL_bgl__stringza7d2ciza7c3za7d3za7f3za731za7za7__r4_strings_6_7za7001255z00, BGl__stringzd2cizc3zd3zf3z31zz__r4_strings_6_7z00, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( BGl_stringzd2upcasez12zd2envz12zz__r4_strings_6_7z00, BgL_bgl__stringza7d2upcaseza712za7c0za7za7__r4_strings_6_7za7001256z00, BGl__stringzd2upcasez12zc0zz__r4_strings_6_7z00, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( BGl_emptyzd2stringzf3zd2envzf3zz__r4_strings_6_7z00, BgL_bgl__emptyza7d2stringza7f3za721za7za7__r4_strings_6_7za7001257z00, BGl__emptyzd2stringzf3z21zz__r4_strings_6_7z00, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( BGl_stringzd2envzd2zz__r4_strings_6_7z00, BgL_bgl__stringza700za7za7__r4_strings_6_7za7001258z00, va_generic_entry, BGl__stringz00zz__r4_strings_6_7z00, -1 );
DEFINE_EXPORT_PROCEDURE( BGl_stringzd2ze3listzd2envze3zz__r4_strings_6_7z00, BgL_bgl__stringza7d2za7e3listza731za7za7__r4_strings_6_7za7001259z00, BGl__stringzd2ze3listz31zz__r4_strings_6_7z00, 0L, 1 );
DEFINE_STRING( BGl_string1245z00zz__r4_strings_6_7z00, BgL_bgl_string1245za700za7za7__r4_strings_6_7za7001260z00, "blit-string!:Index and length out of range", 42 );
DEFINE_EXPORT_PROCEDURE( BGl_stringzd2cize3zf3zd2envz10zz__r4_strings_6_7z00, BgL_bgl__stringza7d2ciza7e3za7f3za7c2za7za7__r4_strings_6_7za7001261za7, BGl__stringzd2cize3zf3zc2zz__r4_strings_6_7z00, 0L, 2 );
DEFINE_STRING( BGl_string1244z00zz__r4_strings_6_7z00, BgL_bgl_string1244za700za7za7__r4_strings_6_7za7001262z00, "[src:", 5 );
DEFINE_STRING( BGl_string1243z00zz__r4_strings_6_7z00, BgL_bgl_string1243za700za7za7__r4_strings_6_7za7001263z00, "] [dest:", 8 );
DEFINE_STRING( BGl_string1242z00zz__r4_strings_6_7z00, BgL_bgl_string1242za700za7za7__r4_strings_6_7za7001264z00, "]", 1 );
DEFINE_EXPORT_PROCEDURE( BGl_stringzd2capitaliza7ezd2envza7zz__r4_strings_6_7z00, BgL_bgl__stringza7d2capitaliza7a7eza775za7za7__r4_strings_6_7za7001265z00, BGl__stringzd2capitaliza7ez75zz__r4_strings_6_7z00, 0L, 1 );
DEFINE_STRING( BGl_string1241z00zz__r4_strings_6_7z00, BgL_bgl_string1241za700za7za7__r4_strings_6_7za7001266z00, "", 0 );
DEFINE_STRING( BGl_string1240z00zz__r4_strings_6_7z00, BgL_bgl_string1240za700za7za7__r4_strings_6_7za7001267z00, "Illegal index", 13 );
DEFINE_STRING( BGl_string1239z00zz__r4_strings_6_7z00, BgL_bgl_string1239za700za7za7__r4_strings_6_7za7001268z00, "substring", 9 );
DEFINE_STRING( BGl_string1238z00zz__r4_strings_6_7z00, BgL_bgl_string1238za700za7za7__r4_strings_6_7za7001269z00, "string-set!", 11 );
DEFINE_STRING( BGl_string1237z00zz__r4_strings_6_7z00, BgL_bgl_string1237za700za7za7__r4_strings_6_7za7001270z00, "index out of range", 18 );
DEFINE_STRING( BGl_string1236z00zz__r4_strings_6_7z00, BgL_bgl_string1236za700za7za7__r4_strings_6_7za7001271z00, "string-ref", 10 );
DEFINE_EXPORT_PROCEDURE( BGl_stringzc3zf3zd2envze2zz__r4_strings_6_7z00, BgL_bgl__stringza7c3za7f3za730za7za7__r4_strings_6_7za7001272z00, BGl__stringzc3zf3z30zz__r4_strings_6_7z00, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( BGl_stringzd2cize3zd3zf3zd2envzc3zz__r4_strings_6_7z00, BgL_bgl__stringza7d2ciza7e3za7d3za7f3za711za7za7__r4_strings_6_7za7001273z00, BGl__stringzd2cize3zd3zf3z11zz__r4_strings_6_7z00, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( BGl_stringzd2downcasez12zd2envz12zz__r4_strings_6_7z00, BgL_bgl__stringza7d2downcaseza712za7c0za7za7__r4_strings_6_7za7001274z00, BGl__stringzd2downcasez12zc0zz__r4_strings_6_7z00, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( BGl_stringzf3zd2envz21zz__r4_strings_6_7z00, BgL_bgl__stringza7f3za7f3za7za7__r4_strings_6_7za7001275za7, BGl__stringzf3zf3zz__r4_strings_6_7z00, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( BGl_stringzd2refzd2envz00zz__r4_strings_6_7z00, BgL_bgl__stringza7d2refza7d2za7za7__r4_strings_6_7za7001276za7, BGl__stringzd2refzd2zz__r4_strings_6_7z00, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( BGl_stringzd2appendzd2envz00zz__r4_strings_6_7z00, BgL_bgl__stringza7d2appendza7d2za7za7__r4_strings_6_7za7001277za7, va_generic_entry, BGl__stringzd2appendzd2zz__r4_strings_6_7z00, -1 );
DEFINE_EXPORT_PROCEDURE( BGl_stringzd2refzd2urzd2envzd2zz__r4_strings_6_7z00, BgL_bgl__stringza7d2refza7d2urza700za7za7__r4_strings_6_7za7001278z00, BGl__stringzd2refzd2urz00zz__r4_strings_6_7z00, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( BGl_stringzd2cizc3zf3zd2envz30zz__r4_strings_6_7z00, BgL_bgl__stringza7d2ciza7c3za7f3za7e2za7za7__r4_strings_6_7za7001279za7, BGl__stringzd2cizc3zf3ze2zz__r4_strings_6_7z00, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( BGl_substringzd2cizd3zf3zd2envz20zz__r4_strings_6_7z00, BgL_bgl__substringza7d2ciza7d3za7f3za7f2za7za7__r4_strings_6_7za7001280za7, BGl__substringzd2cizd3zf3zf2zz__r4_strings_6_7z00, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( BGl_stringzd3zf3zd2envzf2zz__r4_strings_6_7z00, BgL_bgl__stringza7d3za7f3za720za7za7__r4_strings_6_7za7001281z00, BGl__stringzd3zf3z20zz__r4_strings_6_7z00, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( BGl_makezd2stringzd2envz00zz__r4_strings_6_7z00, BgL_bgl__makeza7d2stringza7d2za7za7__r4_strings_6_7za7001282za7, va_generic_entry, BGl__makezd2stringzd2zz__r4_strings_6_7z00, -2 );
DEFINE_EXPORT_PROCEDURE( BGl_stringzd2setz12zd2envz12zz__r4_strings_6_7z00, BgL_bgl__stringza7d2setza712za7c0za7za7__r4_strings_6_7za7001283z00, BGl__stringzd2setz12zc0zz__r4_strings_6_7z00, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( BGl_stringzc3zd3zf3zd2envz31zz__r4_strings_6_7z00, BgL_bgl__stringza7c3za7d3za7f3za7e3za7za7__r4_strings_6_7za7001284za7, BGl__stringzc3zd3zf3ze3zz__r4_strings_6_7z00, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( BGl_stringzd2forzd2readzd2envzd2zz__r4_strings_6_7z00, BgL_bgl__stringza7d2forza7d2readza700za7za7__r4_strings_6_7za7001285z00, BGl__stringzd2forzd2readz00zz__r4_strings_6_7z00, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( BGl_blitzd2stringzd2urz12zd2envzc0zz__r4_strings_6_7z00, BgL_bgl__blitza7d2stringza7d2urza712za712za7za7__r4_strings_6_7za7001286za7, BGl__blitzd2stringzd2urz12z12zz__r4_strings_6_7z00, 0L, 5 );
DEFINE_EXPORT_PROCEDURE( BGl_stringzd2setzd2urz12zd2envzc0zz__r4_strings_6_7z00, BgL_bgl__stringza7d2setza7d2urza712za712za7za7__r4_strings_6_7za7001287za7, BGl__stringzd2setzd2urz12z12zz__r4_strings_6_7z00, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( BGl_stringze3zd3zf3zd2envz11zz__r4_strings_6_7z00, BgL_bgl__stringza7e3za7d3za7f3za7c3za7za7__r4_strings_6_7za7001288za7, BGl__stringze3zd3zf3zc3zz__r4_strings_6_7z00, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( BGl_stringzd2lengthzd2envz00zz__r4_strings_6_7z00, BgL_bgl__stringza7d2lengthza7d2za7za7__r4_strings_6_7za7001289za7, BGl__stringzd2lengthzd2zz__r4_strings_6_7z00, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( BGl_substringzd2envzd2zz__r4_strings_6_7z00, BgL_bgl__substringza700za7za7__r4_strings_6_7za7001290z00, BGl__substringz00zz__r4_strings_6_7z00, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( BGl_stringzd2upcasezd2envz00zz__r4_strings_6_7z00, BgL_bgl__stringza7d2upcaseza7d2za7za7__r4_strings_6_7za7001291za7, BGl__stringzd2upcasezd2zz__r4_strings_6_7z00, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( BGl_stringzd2downcasezd2envz00zz__r4_strings_6_7z00, BgL_bgl__stringza7d2downcaseza7d2za7za7__r4_strings_6_7za7001292za7, BGl__stringzd2downcasezd2zz__r4_strings_6_7z00, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( BGl_stringzd2cizd3zf3zd2envz20zz__r4_strings_6_7z00, BgL_bgl__stringza7d2ciza7d3za7f3za7f2za7za7__r4_strings_6_7za7001293za7, BGl__stringzd2cizd3zf3zf2zz__r4_strings_6_7z00, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( BGl_stringzd2capitaliza7ez12zd2envzb5zz__r4_strings_6_7z00, BgL_bgl__stringza7d2capitaliza7a7eza712za767za7za7__r4_strings_6_7za7001294za7, BGl__stringzd2capitaliza7ez12z67zz__r4_strings_6_7z00, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( BGl_stringze3zf3zd2envzc2zz__r4_strings_6_7z00, BgL_bgl__stringza7e3za7f3za710za7za7__r4_strings_6_7za7001295z00, BGl__stringze3zf3z10zz__r4_strings_6_7z00, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( BGl_substringzd3zf3zd2envzf2zz__r4_strings_6_7z00, BgL_bgl__substringza7d3za7f3za720za7za7__r4_strings_6_7za7001296z00, BGl__substringzd3zf3z20zz__r4_strings_6_7z00, 0L, 3 );



/* module-initialization */
obj_t BGl_modulezd2initializa7ationz75zz__r4_strings_6_7z00(long BgL_checksumz00_1063, char * BgL_fromz00_1064)
{ AN_OBJECT;
{ 
if(
CBOOL(BGl_requirezd2initializa7ationz75zz__r4_strings_6_7z00))
{ 
BGl_requirezd2initializa7ationz75zz__r4_strings_6_7z00 = 
BBOOL(((bool_t)0)); 
BGl_importedzd2moduleszd2initz00zz__r4_strings_6_7z00(); 
return BUNSPEC;}  else 
{ 
return BUNSPEC;} } 
}



/* string? */
bool_t BGl_stringzf3zf3zz__r4_strings_6_7z00(obj_t BgL_objz00_1)
{ AN_OBJECT;
{ /* Ieee/string.scm 196 */
return 
STRINGP(BgL_objz00_1);} 
}



/* _string? */
obj_t BGl__stringzf3zf3zz__r4_strings_6_7z00(obj_t BgL_envz00_896, obj_t BgL_objz00_897)
{ AN_OBJECT;
{ /* Ieee/string.scm 196 */
{ /* Ieee/string.scm 196 */
bool_t BgL_auxz00_1070;
BgL_auxz00_1070 = 
STRINGP(BgL_objz00_897); 
return 
BBOOL(BgL_auxz00_1070);} } 
}



/* make-string */
obj_t BGl_makezd2stringzd2zz__r4_strings_6_7z00(int BgL_kz00_2, obj_t BgL_charz00_3)
{ AN_OBJECT;
{ /* Ieee/string.scm 202 */
if(
NULLP(BgL_charz00_3))
{ /* Ieee/string.scm 203 */
return 
make_string(BgL_kz00_2, ((unsigned char)' '));}  else 
{ /* Ieee/string.scm 203 */
unsigned char BgL_auxz00_1076;
{ /* Ieee/string.scm 203 */
obj_t BgL_auxz00_1077;
BgL_auxz00_1077 = 
CAR(BgL_charz00_3); 
BgL_auxz00_1076 = 
(unsigned char)CCHAR(BgL_auxz00_1077); } 
return 
make_string(BgL_kz00_2, BgL_auxz00_1076);} } 
}



/* _make-string */
obj_t BGl__makezd2stringzd2zz__r4_strings_6_7z00(obj_t BgL_envz00_898, obj_t BgL_kz00_899, obj_t BgL_charz00_900)
{ AN_OBJECT;
{ /* Ieee/string.scm 202 */
{ /* Ieee/string.scm 202 */
obj_t BgL_res1246z00_1007;
{ /* Ieee/string.scm 202 */
int BgL_kz00_1005;
BgL_kz00_1005 = 
CINT(BgL_kz00_899); 
if(
NULLP(BgL_charz00_900))
{ /* Ieee/string.scm 202 */
BgL_res1246z00_1007 = 
make_string(BgL_kz00_1005, ((unsigned char)' ')); }  else 
{ /* Ieee/string.scm 202 */
unsigned char BgL_auxz00_1085;
{ /* Ieee/string.scm 202 */
obj_t BgL_auxz00_1086;
BgL_auxz00_1086 = 
CAR(BgL_charz00_900); 
BgL_auxz00_1085 = 
(unsigned char)CCHAR(BgL_auxz00_1086); } 
BgL_res1246z00_1007 = 
make_string(BgL_kz00_1005, BgL_auxz00_1085); } } 
return BgL_res1246z00_1007;} } 
}



/* string */
obj_t BGl_stringz00zz__r4_strings_6_7z00(obj_t BgL_charsz00_4)
{ AN_OBJECT;
{ /* Ieee/string.scm 210 */
return 
BGl_listzd2ze3stringz31zz__r4_strings_6_7z00(BgL_charsz00_4);} 
}



/* _string */
obj_t BGl__stringz00zz__r4_strings_6_7z00(obj_t BgL_envz00_901, obj_t BgL_charsz00_902)
{ AN_OBJECT;
{ /* Ieee/string.scm 210 */
return 
BGl_listzd2ze3stringz31zz__r4_strings_6_7z00(BgL_charsz00_902);} 
}



/* string-length */
int BGl_stringzd2lengthzd2zz__r4_strings_6_7z00(obj_t BgL_stringz00_5)
{ AN_OBJECT;
{ /* Ieee/string.scm 216 */
return 
STRING_LENGTH(BgL_stringz00_5);} 
}



/* _string-length */
obj_t BGl__stringzd2lengthzd2zz__r4_strings_6_7z00(obj_t BgL_envz00_903, obj_t BgL_stringz00_904)
{ AN_OBJECT;
{ /* Ieee/string.scm 216 */
{ /* Ieee/string.scm 216 */
int BgL_auxz00_1093;
BgL_auxz00_1093 = 
STRING_LENGTH(BgL_stringz00_904); 
return 
BINT(BgL_auxz00_1093);} } 
}



/* string-ref */
unsigned char BGl_stringzd2refzd2zz__r4_strings_6_7z00(obj_t BgL_stringz00_6, int BgL_kz00_7)
{ AN_OBJECT;
{ /* Ieee/string.scm 222 */
{ /* Ieee/string.scm 223 */
bool_t BgL_testz00_1096;
{ /* Ieee/string.scm 223 */
int BgL_auxz00_1097;
BgL_auxz00_1097 = 
STRING_LENGTH(BgL_stringz00_6); 
BgL_testz00_1096 = 
BOUND_CHECK(BgL_kz00_7, BgL_auxz00_1097); } 
if(BgL_testz00_1096)
{ /* Ieee/string.scm 223 */
return 
STRING_REF(BgL_stringz00_6, BgL_kz00_7);}  else 
{ 
obj_t BgL_auxz00_1101;
BgL_auxz00_1101 = 
BINT(BgL_kz00_7); 
FAILURE(BGl_string1236z00zz__r4_strings_6_7z00,BGl_string1237z00zz__r4_strings_6_7z00,BgL_auxz00_1101);} } } 
}



/* _string-ref */
obj_t BGl__stringzd2refzd2zz__r4_strings_6_7z00(obj_t BgL_envz00_905, obj_t BgL_stringz00_906, obj_t BgL_kz00_907)
{ AN_OBJECT;
{ /* Ieee/string.scm 222 */
{ /* Ieee/string.scm 222 */
unsigned char BgL_auxz00_1104;
{ /* Ieee/string.scm 222 */
unsigned char BgL_res1247z00_1012;
{ /* Ieee/string.scm 222 */
int BgL_kz00_1011;
BgL_kz00_1011 = 
CINT(BgL_kz00_907); 
{ /* Ieee/string.scm 222 */
bool_t BgL_testz00_1106;
{ /* Ieee/string.scm 222 */
int BgL_auxz00_1107;
BgL_auxz00_1107 = 
STRING_LENGTH(BgL_stringz00_906); 
BgL_testz00_1106 = 
BOUND_CHECK(BgL_kz00_1011, BgL_auxz00_1107); } 
if(BgL_testz00_1106)
{ /* Ieee/string.scm 222 */
BgL_res1247z00_1012 = 
STRING_REF(BgL_stringz00_906, BgL_kz00_1011); }  else 
{ 
obj_t BgL_auxz00_1111;
BgL_auxz00_1111 = 
BINT(BgL_kz00_1011); 
FAILURE(BGl_string1236z00zz__r4_strings_6_7z00,BGl_string1237z00zz__r4_strings_6_7z00,BgL_auxz00_1111);} } } 
BgL_auxz00_1104 = BgL_res1247z00_1012; } 
return 
BCHAR(BgL_auxz00_1104);} } 
}



/* string-set! */
obj_t BGl_stringzd2setz12zc0zz__r4_strings_6_7z00(obj_t BgL_stringz00_8, int BgL_kz00_9, unsigned char BgL_charz00_10)
{ AN_OBJECT;
{ /* Ieee/string.scm 230 */
{ /* Ieee/string.scm 231 */
bool_t BgL_testz00_1115;
{ /* Ieee/string.scm 231 */
int BgL_auxz00_1116;
BgL_auxz00_1116 = 
STRING_LENGTH(BgL_stringz00_8); 
BgL_testz00_1115 = 
BOUND_CHECK(BgL_kz00_9, BgL_auxz00_1116); } 
if(BgL_testz00_1115)
{ /* Ieee/string.scm 231 */
return 
STRING_SET(BgL_stringz00_8, BgL_kz00_9, BgL_charz00_10);}  else 
{ 
obj_t BgL_auxz00_1120;
BgL_auxz00_1120 = 
BINT(BgL_kz00_9); 
FAILURE(BGl_string1238z00zz__r4_strings_6_7z00,BGl_string1237z00zz__r4_strings_6_7z00,BgL_auxz00_1120);} } } 
}



/* _string-set! */
obj_t BGl__stringzd2setz12zc0zz__r4_strings_6_7z00(obj_t BgL_envz00_908, obj_t BgL_stringz00_909, obj_t BgL_kz00_910, obj_t BgL_charz00_911)
{ AN_OBJECT;
{ /* Ieee/string.scm 230 */
{ /* Ieee/string.scm 230 */
int BgL_kz00_1014;
BgL_kz00_1014 = 
CINT(BgL_kz00_910); 
{ /* Ieee/string.scm 230 */
bool_t BgL_testz00_1124;
{ /* Ieee/string.scm 230 */
int BgL_auxz00_1125;
BgL_auxz00_1125 = 
STRING_LENGTH(BgL_stringz00_909); 
BgL_testz00_1124 = 
BOUND_CHECK(BgL_kz00_1014, BgL_auxz00_1125); } 
if(BgL_testz00_1124)
{ /* Ieee/string.scm 230 */
unsigned char BgL_auxz00_1128;
BgL_auxz00_1128 = 
(unsigned char)CCHAR(BgL_charz00_911); 
return 
STRING_SET(BgL_stringz00_909, BgL_kz00_1014, BgL_auxz00_1128);}  else 
{ 
obj_t BgL_auxz00_1131;
BgL_auxz00_1131 = 
BINT(BgL_kz00_1014); 
FAILURE(BGl_string1238z00zz__r4_strings_6_7z00,BGl_string1237z00zz__r4_strings_6_7z00,BgL_auxz00_1131);} } } } 
}



/* string-ref-ur */
unsigned char BGl_stringzd2refzd2urz00zz__r4_strings_6_7z00(obj_t BgL_stringz00_11, int BgL_kz00_12)
{ AN_OBJECT;
{ /* Ieee/string.scm 238 */
return 
STRING_REF(BgL_stringz00_11, BgL_kz00_12);} 
}



/* _string-ref-ur */
obj_t BGl__stringzd2refzd2urz00zz__r4_strings_6_7z00(obj_t BgL_envz00_912, obj_t BgL_stringz00_913, obj_t BgL_kz00_914)
{ AN_OBJECT;
{ /* Ieee/string.scm 238 */
{ /* Ieee/string.scm 238 */
unsigned char BgL_auxz00_1135;
{ /* Ieee/string.scm 238 */
int BgL_auxz00_1136;
BgL_auxz00_1136 = 
CINT(BgL_kz00_914); 
BgL_auxz00_1135 = 
STRING_REF(BgL_stringz00_913, BgL_auxz00_1136); } 
return 
BCHAR(BgL_auxz00_1135);} } 
}



/* string-set-ur! */
obj_t BGl_stringzd2setzd2urz12z12zz__r4_strings_6_7z00(obj_t BgL_stringz00_13, int BgL_kz00_14, unsigned char BgL_charz00_15)
{ AN_OBJECT;
{ /* Ieee/string.scm 244 */
return 
STRING_SET(BgL_stringz00_13, BgL_kz00_14, BgL_charz00_15);} 
}



/* _string-set-ur! */
obj_t BGl__stringzd2setzd2urz12z12zz__r4_strings_6_7z00(obj_t BgL_envz00_915, obj_t BgL_stringz00_916, obj_t BgL_kz00_917, obj_t BgL_charz00_918)
{ AN_OBJECT;
{ /* Ieee/string.scm 244 */
{ /* Ieee/string.scm 244 */
unsigned char BgL_auxz00_1143;int BgL_auxz00_1141;
BgL_auxz00_1143 = 
(unsigned char)CCHAR(BgL_charz00_918); 
BgL_auxz00_1141 = 
CINT(BgL_kz00_917); 
return 
STRING_SET(BgL_stringz00_916, BgL_auxz00_1141, BgL_auxz00_1143);} } 
}



/* string=? */
bool_t BGl_stringzd3zf3z20zz__r4_strings_6_7z00(obj_t BgL_string1z00_16, obj_t BgL_string2z00_17)
{ AN_OBJECT;
{ /* Ieee/string.scm 250 */
return 
bigloo_strcmp(BgL_string1z00_16, BgL_string2z00_17);} 
}



/* _string=? */
obj_t BGl__stringzd3zf3z20zz__r4_strings_6_7z00(obj_t BgL_envz00_919, obj_t BgL_string1z00_920, obj_t BgL_string2z00_921)
{ AN_OBJECT;
{ /* Ieee/string.scm 250 */
{ /* Ieee/string.scm 250 */
bool_t BgL_auxz00_1147;
BgL_auxz00_1147 = 
bigloo_strcmp(BgL_string1z00_920, BgL_string2z00_921); 
return 
BBOOL(BgL_auxz00_1147);} } 
}



/* substring=? */
bool_t BGl_substringzd3zf3z20zz__r4_strings_6_7z00(obj_t BgL_string1z00_18, obj_t BgL_string2z00_19, int BgL_lenz00_20)
{ AN_OBJECT;
{ /* Ieee/string.scm 256 */
return 
bigloo_strncmp(BgL_string1z00_18, BgL_string2z00_19, BgL_lenz00_20);} 
}



/* _substring=? */
obj_t BGl__substringzd3zf3z20zz__r4_strings_6_7z00(obj_t BgL_envz00_922, obj_t BgL_string1z00_923, obj_t BgL_string2z00_924, obj_t BgL_lenz00_925)
{ AN_OBJECT;
{ /* Ieee/string.scm 256 */
{ /* Ieee/string.scm 256 */
bool_t BgL_auxz00_1151;
{ /* Ieee/string.scm 256 */
int BgL_auxz00_1152;
BgL_auxz00_1152 = 
CINT(BgL_lenz00_925); 
BgL_auxz00_1151 = 
bigloo_strncmp(BgL_string1z00_923, BgL_string2z00_924, BgL_auxz00_1152); } 
return 
BBOOL(BgL_auxz00_1151);} } 
}



/* substring-ci=? */
bool_t BGl_substringzd2cizd3zf3zf2zz__r4_strings_6_7z00(obj_t BgL_string1z00_21, obj_t BgL_string2z00_22, int BgL_lenz00_23)
{ AN_OBJECT;
{ /* Ieee/string.scm 262 */
return 
bigloo_strncmp_ci(BgL_string1z00_21, BgL_string2z00_22, BgL_lenz00_23);} 
}



/* _substring-ci=? */
obj_t BGl__substringzd2cizd3zf3zf2zz__r4_strings_6_7z00(obj_t BgL_envz00_926, obj_t BgL_string1z00_927, obj_t BgL_string2z00_928, obj_t BgL_lenz00_929)
{ AN_OBJECT;
{ /* Ieee/string.scm 262 */
{ /* Ieee/string.scm 262 */
bool_t BgL_auxz00_1157;
{ /* Ieee/string.scm 262 */
int BgL_auxz00_1158;
BgL_auxz00_1158 = 
CINT(BgL_lenz00_929); 
BgL_auxz00_1157 = 
bigloo_strncmp_ci(BgL_string1z00_927, BgL_string2z00_928, BgL_auxz00_1158); } 
return 
BBOOL(BgL_auxz00_1157);} } 
}



/* empty-string? */
bool_t BGl_emptyzd2stringzf3z21zz__r4_strings_6_7z00(obj_t BgL_stringz00_24)
{ AN_OBJECT;
{ /* Ieee/string.scm 268 */
{ /* Ieee/string.scm 269 */
long BgL_auxz00_1162;
{ /* Ieee/string.scm 269 */
int BgL_auxz00_1163;
BgL_auxz00_1163 = 
STRING_LENGTH(BgL_stringz00_24); 
BgL_auxz00_1162 = 
(long)(BgL_auxz00_1163); } 
return 
(BgL_auxz00_1162==((long)0));} } 
}



/* _empty-string? */
obj_t BGl__emptyzd2stringzf3z21zz__r4_strings_6_7z00(obj_t BgL_envz00_930, obj_t BgL_stringz00_931)
{ AN_OBJECT;
{ /* Ieee/string.scm 268 */
{ /* Ieee/string.scm 268 */
bool_t BgL_auxz00_1167;
{ /* Ieee/string.scm 268 */
long BgL_auxz00_1168;
{ /* Ieee/string.scm 268 */
int BgL_auxz00_1169;
BgL_auxz00_1169 = 
STRING_LENGTH(BgL_stringz00_931); 
BgL_auxz00_1168 = 
(long)(BgL_auxz00_1169); } 
BgL_auxz00_1167 = 
(BgL_auxz00_1168==((long)0)); } 
return 
BBOOL(BgL_auxz00_1167);} } 
}



/* string-ci=? */
bool_t BGl_stringzd2cizd3zf3zf2zz__r4_strings_6_7z00(obj_t BgL_string1z00_25, obj_t BgL_string2z00_26)
{ AN_OBJECT;
{ /* Ieee/string.scm 274 */
return 
strcicmp(BgL_string1z00_25, BgL_string2z00_26);} 
}



/* _string-ci=? */
obj_t BGl__stringzd2cizd3zf3zf2zz__r4_strings_6_7z00(obj_t BgL_envz00_932, obj_t BgL_string1z00_933, obj_t BgL_string2z00_934)
{ AN_OBJECT;
{ /* Ieee/string.scm 274 */
{ /* Ieee/string.scm 274 */
bool_t BgL_auxz00_1175;
BgL_auxz00_1175 = 
strcicmp(BgL_string1z00_933, BgL_string2z00_934); 
return 
BBOOL(BgL_auxz00_1175);} } 
}



/* string<? */
bool_t BGl_stringzc3zf3z30zz__r4_strings_6_7z00(obj_t BgL_string1z00_27, obj_t BgL_string2z00_28)
{ AN_OBJECT;
{ /* Ieee/string.scm 280 */
return 
string_lt(BgL_string1z00_27, BgL_string2z00_28);} 
}



/* _string<? */
obj_t BGl__stringzc3zf3z30zz__r4_strings_6_7z00(obj_t BgL_envz00_935, obj_t BgL_string1z00_936, obj_t BgL_string2z00_937)
{ AN_OBJECT;
{ /* Ieee/string.scm 280 */
{ /* Ieee/string.scm 280 */
bool_t BgL_auxz00_1179;
BgL_auxz00_1179 = 
string_lt(BgL_string1z00_936, BgL_string2z00_937); 
return 
BBOOL(BgL_auxz00_1179);} } 
}



/* string>? */
bool_t BGl_stringze3zf3z10zz__r4_strings_6_7z00(obj_t BgL_string1z00_29, obj_t BgL_string2z00_30)
{ AN_OBJECT;
{ /* Ieee/string.scm 286 */
return 
string_gt(BgL_string1z00_29, BgL_string2z00_30);} 
}



/* _string>? */
obj_t BGl__stringze3zf3z10zz__r4_strings_6_7z00(obj_t BgL_envz00_938, obj_t BgL_string1z00_939, obj_t BgL_string2z00_940)
{ AN_OBJECT;
{ /* Ieee/string.scm 286 */
{ /* Ieee/string.scm 286 */
bool_t BgL_auxz00_1183;
BgL_auxz00_1183 = 
string_gt(BgL_string1z00_939, BgL_string2z00_940); 
return 
BBOOL(BgL_auxz00_1183);} } 
}



/* string<=? */
bool_t BGl_stringzc3zd3zf3ze3zz__r4_strings_6_7z00(obj_t BgL_string1z00_31, obj_t BgL_string2z00_32)
{ AN_OBJECT;
{ /* Ieee/string.scm 292 */
return 
string_le(BgL_string1z00_31, BgL_string2z00_32);} 
}



/* _string<=? */
obj_t BGl__stringzc3zd3zf3ze3zz__r4_strings_6_7z00(obj_t BgL_envz00_941, obj_t BgL_string1z00_942, obj_t BgL_string2z00_943)
{ AN_OBJECT;
{ /* Ieee/string.scm 292 */
{ /* Ieee/string.scm 292 */
bool_t BgL_auxz00_1187;
BgL_auxz00_1187 = 
string_le(BgL_string1z00_942, BgL_string2z00_943); 
return 
BBOOL(BgL_auxz00_1187);} } 
}



/* string>=? */
bool_t BGl_stringze3zd3zf3zc3zz__r4_strings_6_7z00(obj_t BgL_string1z00_33, obj_t BgL_string2z00_34)
{ AN_OBJECT;
{ /* Ieee/string.scm 298 */
return 
string_ge(BgL_string1z00_33, BgL_string2z00_34);} 
}



/* _string>=? */
obj_t BGl__stringze3zd3zf3zc3zz__r4_strings_6_7z00(obj_t BgL_envz00_944, obj_t BgL_string1z00_945, obj_t BgL_string2z00_946)
{ AN_OBJECT;
{ /* Ieee/string.scm 298 */
{ /* Ieee/string.scm 298 */
bool_t BgL_auxz00_1191;
BgL_auxz00_1191 = 
string_ge(BgL_string1z00_945, BgL_string2z00_946); 
return 
BBOOL(BgL_auxz00_1191);} } 
}



/* string-ci<? */
bool_t BGl_stringzd2cizc3zf3ze2zz__r4_strings_6_7z00(obj_t BgL_string1z00_35, obj_t BgL_string2z00_36)
{ AN_OBJECT;
{ /* Ieee/string.scm 304 */
return 
string_cilt(BgL_string1z00_35, BgL_string2z00_36);} 
}



/* _string-ci<? */
obj_t BGl__stringzd2cizc3zf3ze2zz__r4_strings_6_7z00(obj_t BgL_envz00_947, obj_t BgL_string1z00_948, obj_t BgL_string2z00_949)
{ AN_OBJECT;
{ /* Ieee/string.scm 304 */
{ /* Ieee/string.scm 304 */
bool_t BgL_auxz00_1195;
BgL_auxz00_1195 = 
string_cilt(BgL_string1z00_948, BgL_string2z00_949); 
return 
BBOOL(BgL_auxz00_1195);} } 
}



/* string-ci>? */
bool_t BGl_stringzd2cize3zf3zc2zz__r4_strings_6_7z00(obj_t BgL_string1z00_37, obj_t BgL_string2z00_38)
{ AN_OBJECT;
{ /* Ieee/string.scm 310 */
return 
string_cigt(BgL_string1z00_37, BgL_string2z00_38);} 
}



/* _string-ci>? */
obj_t BGl__stringzd2cize3zf3zc2zz__r4_strings_6_7z00(obj_t BgL_envz00_950, obj_t BgL_string1z00_951, obj_t BgL_string2z00_952)
{ AN_OBJECT;
{ /* Ieee/string.scm 310 */
{ /* Ieee/string.scm 310 */
bool_t BgL_auxz00_1199;
BgL_auxz00_1199 = 
string_cigt(BgL_string1z00_951, BgL_string2z00_952); 
return 
BBOOL(BgL_auxz00_1199);} } 
}



/* string-ci<=? */
bool_t BGl_stringzd2cizc3zd3zf3z31zz__r4_strings_6_7z00(obj_t BgL_string1z00_39, obj_t BgL_string2z00_40)
{ AN_OBJECT;
{ /* Ieee/string.scm 316 */
return 
string_cile(BgL_string1z00_39, BgL_string2z00_40);} 
}



/* _string-ci<=? */
obj_t BGl__stringzd2cizc3zd3zf3z31zz__r4_strings_6_7z00(obj_t BgL_envz00_953, obj_t BgL_string1z00_954, obj_t BgL_string2z00_955)
{ AN_OBJECT;
{ /* Ieee/string.scm 316 */
{ /* Ieee/string.scm 316 */
bool_t BgL_auxz00_1203;
BgL_auxz00_1203 = 
string_cile(BgL_string1z00_954, BgL_string2z00_955); 
return 
BBOOL(BgL_auxz00_1203);} } 
}



/* string-ci>=? */
bool_t BGl_stringzd2cize3zd3zf3z11zz__r4_strings_6_7z00(obj_t BgL_string1z00_41, obj_t BgL_string2z00_42)
{ AN_OBJECT;
{ /* Ieee/string.scm 322 */
return 
string_cige(BgL_string1z00_41, BgL_string2z00_42);} 
}



/* _string-ci>=? */
obj_t BGl__stringzd2cize3zd3zf3z11zz__r4_strings_6_7z00(obj_t BgL_envz00_956, obj_t BgL_string1z00_957, obj_t BgL_string2z00_958)
{ AN_OBJECT;
{ /* Ieee/string.scm 322 */
{ /* Ieee/string.scm 322 */
bool_t BgL_auxz00_1207;
BgL_auxz00_1207 = 
string_cige(BgL_string1z00_957, BgL_string2z00_958); 
return 
BBOOL(BgL_auxz00_1207);} } 
}



/* substring */
obj_t BGl_substringz00zz__r4_strings_6_7z00(obj_t BgL_stringz00_43, int BgL_startz00_44, int BgL_endz00_45)
{ AN_OBJECT;
{ /* Ieee/string.scm 328 */
{ /* Ieee/string.scm 330 */
bool_t BgL_testz00_1210;
{ /* Ieee/string.scm 330 */
bool_t BgL_testz00_1211;
{ /* Ieee/string.scm 330 */
long BgL_auxz00_1214;long BgL_auxz00_1212;
BgL_auxz00_1214 = 
(long)(BgL_startz00_44); 
BgL_auxz00_1212 = 
(long)(BgL_endz00_45); 
BgL_testz00_1211 = 
(BgL_auxz00_1212>=BgL_auxz00_1214); } 
if(BgL_testz00_1211)
{ /* Ieee/string.scm 330 */
bool_t BgL_testz00_1217;
{ /* Ieee/string.scm 330 */
int BgL_auxz00_1218;
{ /* Ieee/string.scm 330 */
long BgL_auxz00_1219;
{ /* Ieee/string.scm 330 */
long BgL_auxz00_1220;
{ /* Ieee/string.scm 330 */
int BgL_auxz00_1221;
BgL_auxz00_1221 = 
STRING_LENGTH(BgL_stringz00_43); 
BgL_auxz00_1220 = 
(long)(BgL_auxz00_1221); } 
BgL_auxz00_1219 = 
(BgL_auxz00_1220+((long)1)); } 
BgL_auxz00_1218 = 
(int)(BgL_auxz00_1219); } 
BgL_testz00_1217 = 
BOUND_CHECK(BgL_startz00_44, BgL_auxz00_1218); } 
if(BgL_testz00_1217)
{ /* Ieee/string.scm 330 */
int BgL_auxz00_1227;
{ /* Ieee/string.scm 330 */
long BgL_auxz00_1228;
{ /* Ieee/string.scm 330 */
long BgL_auxz00_1229;
{ /* Ieee/string.scm 330 */
int BgL_auxz00_1230;
BgL_auxz00_1230 = 
STRING_LENGTH(BgL_stringz00_43); 
BgL_auxz00_1229 = 
(long)(BgL_auxz00_1230); } 
BgL_auxz00_1228 = 
(BgL_auxz00_1229+((long)1)); } 
BgL_auxz00_1227 = 
(int)(BgL_auxz00_1228); } 
BgL_testz00_1210 = 
BOUND_CHECK(BgL_endz00_45, BgL_auxz00_1227); }  else 
{ /* Ieee/string.scm 330 */
BgL_testz00_1210 = ((bool_t)0)
; } }  else 
{ /* Ieee/string.scm 330 */
BgL_testz00_1210 = ((bool_t)0)
; } } 
if(BgL_testz00_1210)
{ /* Ieee/string.scm 330 */
return 
c_substring(BgL_stringz00_43, BgL_startz00_44, BgL_endz00_45);}  else 
{ /* Ieee/string.scm 330 */
obj_t BgL_arg1021z00_1048;
{ /* Ieee/string.scm 330 */
obj_t BgL_auxz00_1239;obj_t BgL_auxz00_1237;
BgL_auxz00_1239 = 
BINT(BgL_endz00_45); 
BgL_auxz00_1237 = 
BINT(BgL_startz00_44); 
BgL_arg1021z00_1048 = 
MAKE_PAIR(BgL_auxz00_1237, BgL_auxz00_1239); } 
FAILURE(BGl_string1239z00zz__r4_strings_6_7z00,BGl_string1240z00zz__r4_strings_6_7z00,BgL_arg1021z00_1048);} } } 
}



/* _substring */
obj_t BGl__substringz00zz__r4_strings_6_7z00(obj_t BgL_envz00_959, obj_t BgL_stringz00_960, obj_t BgL_startz00_961, obj_t BgL_endz00_962)
{ AN_OBJECT;
{ /* Ieee/string.scm 328 */
{ /* Ieee/string.scm 328 */
obj_t BgL_res1248z00_1053;
{ /* Ieee/string.scm 328 */
int BgL_startz00_1050;int BgL_endz00_1051;
BgL_startz00_1050 = 
CINT(BgL_startz00_961); 
BgL_endz00_1051 = 
CINT(BgL_endz00_962); 
{ /* Ieee/string.scm 328 */
bool_t BgL_testz00_1245;
{ /* Ieee/string.scm 328 */
bool_t BgL_testz00_1246;
{ /* Ieee/string.scm 328 */
long BgL_auxz00_1249;long BgL_auxz00_1247;
BgL_auxz00_1249 = 
(long)(BgL_startz00_1050); 
BgL_auxz00_1247 = 
(long)(BgL_endz00_1051); 
BgL_testz00_1246 = 
(BgL_auxz00_1247>=BgL_auxz00_1249); } 
if(BgL_testz00_1246)
{ /* Ieee/string.scm 328 */
bool_t BgL_testz00_1252;
{ /* Ieee/string.scm 328 */
int BgL_auxz00_1253;
{ /* Ieee/string.scm 328 */
long BgL_auxz00_1254;
{ /* Ieee/string.scm 328 */
long BgL_auxz00_1255;
{ /* Ieee/string.scm 328 */
int BgL_auxz00_1256;
BgL_auxz00_1256 = 
STRING_LENGTH(BgL_stringz00_960); 
BgL_auxz00_1255 = 
(long)(BgL_auxz00_1256); } 
BgL_auxz00_1254 = 
(BgL_auxz00_1255+((long)1)); } 
BgL_auxz00_1253 = 
(int)(BgL_auxz00_1254); } 
BgL_testz00_1252 = 
BOUND_CHECK(BgL_startz00_1050, BgL_auxz00_1253); } 
if(BgL_testz00_1252)
{ /* Ieee/string.scm 328 */
int BgL_auxz00_1262;
{ /* Ieee/string.scm 328 */
long BgL_auxz00_1263;
{ /* Ieee/string.scm 328 */
long BgL_auxz00_1264;
{ /* Ieee/string.scm 328 */
int BgL_auxz00_1265;
BgL_auxz00_1265 = 
STRING_LENGTH(BgL_stringz00_960); 
BgL_auxz00_1264 = 
(long)(BgL_auxz00_1265); } 
BgL_auxz00_1263 = 
(BgL_auxz00_1264+((long)1)); } 
BgL_auxz00_1262 = 
(int)(BgL_auxz00_1263); } 
BgL_testz00_1245 = 
BOUND_CHECK(BgL_endz00_1051, BgL_auxz00_1262); }  else 
{ /* Ieee/string.scm 328 */
BgL_testz00_1245 = ((bool_t)0)
; } }  else 
{ /* Ieee/string.scm 328 */
BgL_testz00_1245 = ((bool_t)0)
; } } 
if(BgL_testz00_1245)
{ /* Ieee/string.scm 328 */
BgL_res1248z00_1053 = 
c_substring(BgL_stringz00_960, BgL_startz00_1050, BgL_endz00_1051); }  else 
{ /* Ieee/string.scm 328 */
obj_t BgL_arg1021z00_1052;
{ /* Ieee/string.scm 328 */
obj_t BgL_auxz00_1274;obj_t BgL_auxz00_1272;
BgL_auxz00_1274 = 
BINT(BgL_endz00_1051); 
BgL_auxz00_1272 = 
BINT(BgL_startz00_1050); 
BgL_arg1021z00_1052 = 
MAKE_PAIR(BgL_auxz00_1272, BgL_auxz00_1274); } 
FAILURE(BGl_string1239z00zz__r4_strings_6_7z00,BGl_string1240z00zz__r4_strings_6_7z00,BgL_arg1021z00_1052);} } } 
return BgL_res1248z00_1053;} } 
}



/* substring-ur */
obj_t BGl_substringzd2urzd2zz__r4_strings_6_7z00(obj_t BgL_stringz00_46, int BgL_startz00_47, int BgL_endz00_48)
{ AN_OBJECT;
{ /* Ieee/string.scm 341 */
return 
c_substring(BgL_stringz00_46, BgL_startz00_47, BgL_endz00_48);} 
}



/* _substring-ur */
obj_t BGl__substringzd2urzd2zz__r4_strings_6_7z00(obj_t BgL_envz00_963, obj_t BgL_stringz00_964, obj_t BgL_startz00_965, obj_t BgL_endz00_966)
{ AN_OBJECT;
{ /* Ieee/string.scm 341 */
{ /* Ieee/string.scm 341 */
int BgL_auxz00_1281;int BgL_auxz00_1279;
BgL_auxz00_1281 = 
CINT(BgL_endz00_966); 
BgL_auxz00_1279 = 
CINT(BgL_startz00_965); 
return 
c_substring(BgL_stringz00_964, BgL_auxz00_1279, BgL_auxz00_1281);} } 
}



/* string-append */
obj_t BGl_stringzd2appendzd2zz__r4_strings_6_7z00(obj_t BgL_listz00_49)
{ AN_OBJECT;
{ /* Ieee/string.scm 351 */
if(
NULLP(BgL_listz00_49))
{ /* Ieee/string.scm 352 */
return BGl_string1241z00zz__r4_strings_6_7z00;}  else 
{ /* Ieee/string.scm 354 */
obj_t BgL_resz00_254;
{ /* Ieee/string.scm 361 */
int BgL_auxz00_1286;
{ /* Ieee/string.scm 361 */
long BgL_auxz00_1287;
{ 
obj_t BgL_listz00_524;long BgL_resz00_525;
BgL_listz00_524 = BgL_listz00_49; 
BgL_resz00_525 = ((long)0); 
BgL_stringzd2appendzd2_523:
if(
NULLP(BgL_listz00_524))
{ /* Ieee/string.scm 354 */
BgL_auxz00_1287 = BgL_resz00_525
; }  else 
{ 
long BgL_resz00_1292;obj_t BgL_listz00_1290;
BgL_listz00_1290 = 
CDR(BgL_listz00_524); 
{ /* Ieee/string.scm 354 */
long BgL_auxz00_1293;
{ /* Ieee/string.scm 354 */
int BgL_auxz00_1294;
{ /* Ieee/string.scm 354 */
obj_t BgL_auxz00_1295;
BgL_auxz00_1295 = 
CAR(BgL_listz00_524); 
BgL_auxz00_1294 = 
STRING_LENGTH(BgL_auxz00_1295); } 
BgL_auxz00_1293 = 
(long)(BgL_auxz00_1294); } 
BgL_resz00_1292 = 
(BgL_resz00_525+BgL_auxz00_1293); } 
BgL_resz00_525 = BgL_resz00_1292; 
BgL_listz00_524 = BgL_listz00_1290; 
goto BgL_stringzd2appendzd2_523;} } 
BgL_auxz00_1286 = 
(int)(BgL_auxz00_1287); } 
BgL_resz00_254 = 
make_string_sans_fill(BgL_auxz00_1286); } 
{ /* Ieee/string.scm 361 */

{ 
obj_t BgL_listz00_567;long BgL_wz00_568;
BgL_listz00_567 = BgL_listz00_49; 
BgL_wz00_568 = ((long)0); 
BgL_stringzd2appendzd2_566:
if(
NULLP(BgL_listz00_567))
{ /* Ieee/string.scm 362 */
return BgL_resz00_254;}  else 
{ /* Ieee/string.scm 362 */
obj_t BgL_sz00_575;
BgL_sz00_575 = 
CAR(BgL_listz00_567); 
{ /* Ieee/string.scm 362 */
int BgL_lz00_576;
BgL_lz00_576 = 
STRING_LENGTH(BgL_sz00_575); 
{ /* Ieee/string.scm 362 */

{ /* Ieee/string.scm 362 */
int BgL_auxz00_1308;int BgL_auxz00_1306;
BgL_auxz00_1308 = 
(int)(BgL_wz00_568); 
BgL_auxz00_1306 = 
(int)(((long)0)); 
blit_string(BgL_sz00_575, BgL_auxz00_1306, BgL_resz00_254, BgL_auxz00_1308, BgL_lz00_576); } 
{ 
long BgL_wz00_1313;obj_t BgL_listz00_1311;
BgL_listz00_1311 = 
CDR(BgL_listz00_567); 
{ /* Ieee/string.scm 362 */
long BgL_auxz00_1314;
BgL_auxz00_1314 = 
(long)(BgL_lz00_576); 
BgL_wz00_1313 = 
(BgL_wz00_568+BgL_auxz00_1314); } 
BgL_wz00_568 = BgL_wz00_1313; 
BgL_listz00_567 = BgL_listz00_1311; 
goto BgL_stringzd2appendzd2_566;} } } } } } } } 
}



/* _string-append */
obj_t BGl__stringzd2appendzd2zz__r4_strings_6_7z00(obj_t BgL_envz00_967, obj_t BgL_listz00_968)
{ AN_OBJECT;
{ /* Ieee/string.scm 351 */
return 
BGl_stringzd2appendzd2zz__r4_strings_6_7z00(BgL_listz00_968);} 
}



/* list->string */
obj_t BGl_listzd2ze3stringz31zz__r4_strings_6_7z00(obj_t BgL_listz00_50)
{ AN_OBJECT;
{ /* Ieee/string.scm 374 */
{ /* Ieee/string.scm 375 */
long BgL_lenz00_271;
BgL_lenz00_271 = 
bgl_list_length(BgL_listz00_50); 
{ /* Ieee/string.scm 375 */
obj_t BgL_stringz00_272;
{ /* Ieee/string.scm 376 */
int BgL_auxz00_1319;
BgL_auxz00_1319 = 
(int)(BgL_lenz00_271); 
BgL_stringz00_272 = 
make_string(BgL_auxz00_1319, ((unsigned char)' ')); } 
{ /* Ieee/string.scm 376 */

{ 
long BgL_iz00_632;obj_t BgL_lz00_633;
BgL_iz00_632 = ((long)0); 
BgL_lz00_633 = BgL_listz00_50; 
BgL_loopz00_631:
if(
(BgL_iz00_632==BgL_lenz00_271))
{ /* Ieee/string.scm 377 */
return BgL_stringz00_272;}  else 
{ /* Ieee/string.scm 377 */
{ /* Ieee/string.scm 377 */
unsigned char BgL_auxz00_1326;int BgL_auxz00_1324;
{ /* Ieee/string.scm 377 */
obj_t BgL_auxz00_1327;
BgL_auxz00_1327 = 
CAR(BgL_lz00_633); 
BgL_auxz00_1326 = 
(unsigned char)CCHAR(BgL_auxz00_1327); } 
BgL_auxz00_1324 = 
(int)(BgL_iz00_632); 
STRING_SET(BgL_stringz00_272, BgL_auxz00_1324, BgL_auxz00_1326); } 
{ 
obj_t BgL_lz00_1333;long BgL_iz00_1331;
BgL_iz00_1331 = 
(BgL_iz00_632+((long)1)); 
BgL_lz00_1333 = 
CDR(BgL_lz00_633); 
BgL_lz00_633 = BgL_lz00_1333; 
BgL_iz00_632 = BgL_iz00_1331; 
goto BgL_loopz00_631;} } } } } } } 
}



/* _list->string */
obj_t BGl__listzd2ze3stringz31zz__r4_strings_6_7z00(obj_t BgL_envz00_969, obj_t BgL_listz00_970)
{ AN_OBJECT;
{ /* Ieee/string.scm 374 */
return 
BGl_listzd2ze3stringz31zz__r4_strings_6_7z00(BgL_listz00_970);} 
}



/* string->list */
obj_t BGl_stringzd2ze3listz31zz__r4_strings_6_7z00(obj_t BgL_stringz00_51)
{ AN_OBJECT;
{ /* Ieee/string.scm 388 */
{ 
long BgL_iz00_683;obj_t BgL_resz00_684;
{ /* Ieee/string.scm 390 */
long BgL_auxz00_1348;
{ /* Ieee/string.scm 390 */
int BgL_auxz00_1349;
BgL_auxz00_1349 = 
STRING_LENGTH(BgL_stringz00_51); 
BgL_auxz00_1348 = 
(long)(BgL_auxz00_1349); } 
BgL_iz00_683 = 
(BgL_auxz00_1348-((long)1)); } 
BgL_resz00_684 = BNIL; 
BgL_loopz00_682:
if(
(BgL_iz00_683==((long)-1)))
{ /* Ieee/string.scm 390 */
return BgL_resz00_684;}  else 
{ /* Ieee/string.scm 390 */
long BgL_arg1054z00_690;obj_t BgL_arg1056z00_691;
BgL_arg1054z00_690 = 
(BgL_iz00_683-((long)1)); 
{ /* Ieee/string.scm 390 */
obj_t BgL_auxz00_1339;
{ /* Ieee/string.scm 390 */
unsigned char BgL_auxz00_1340;
{ /* Ieee/string.scm 390 */
int BgL_auxz00_1341;
BgL_auxz00_1341 = 
(int)(BgL_iz00_683); 
BgL_auxz00_1340 = 
STRING_REF(BgL_stringz00_51, BgL_auxz00_1341); } 
BgL_auxz00_1339 = 
BCHAR(BgL_auxz00_1340); } 
BgL_arg1056z00_691 = 
MAKE_PAIR(BgL_auxz00_1339, BgL_resz00_684); } 
{ 
obj_t BgL_resz00_1347;long BgL_iz00_1346;
BgL_iz00_1346 = BgL_arg1054z00_690; 
BgL_resz00_1347 = BgL_arg1056z00_691; 
BgL_resz00_684 = BgL_resz00_1347; 
BgL_iz00_683 = BgL_iz00_1346; 
goto BgL_loopz00_682;} } } } 
}



/* _string->list */
obj_t BGl__stringzd2ze3listz31zz__r4_strings_6_7z00(obj_t BgL_envz00_971, obj_t BgL_stringz00_972)
{ AN_OBJECT;
{ /* Ieee/string.scm 388 */
return 
BGl_stringzd2ze3listz31zz__r4_strings_6_7z00(BgL_stringz00_972);} 
}



/* string-copy */
obj_t BGl_stringzd2copyzd2zz__r4_strings_6_7z00(obj_t BgL_stringz00_52)
{ AN_OBJECT;
{ /* Ieee/string.scm 400 */
{ /* Ieee/string.scm 401 */
int BgL_lenz00_291;
BgL_lenz00_291 = 
STRING_LENGTH(BgL_stringz00_52); 
{ /* Ieee/string.scm 401 */
obj_t BgL_newz00_292;
BgL_newz00_292 = 
make_string(BgL_lenz00_291, ((unsigned char)' ')); 
{ /* Ieee/string.scm 402 */

{ 
long BgL_iz00_293;
{ /* Ieee/string.scm 403 */
long BgL_auxz00_1367;
BgL_auxz00_1367 = 
(long)(BgL_lenz00_291); 
BgL_iz00_293 = 
(BgL_auxz00_1367-((long)1)); } 
BgL_loopz00_294:
if(
(BgL_iz00_293==((long)-1)))
{ /* Ieee/string.scm 404 */
return BgL_newz00_292;}  else 
{ /* Ieee/string.scm 404 */
{ /* Ieee/string.scm 407 */
unsigned char BgL_auxz00_1360;int BgL_auxz00_1358;
{ /* Ieee/string.scm 407 */
int BgL_auxz00_1361;
BgL_auxz00_1361 = 
(int)(BgL_iz00_293); 
BgL_auxz00_1360 = 
STRING_REF(BgL_stringz00_52, BgL_auxz00_1361); } 
BgL_auxz00_1358 = 
(int)(BgL_iz00_293); 
STRING_SET(BgL_newz00_292, BgL_auxz00_1358, BgL_auxz00_1360); } 
{ 
long BgL_iz00_1365;
BgL_iz00_1365 = 
(BgL_iz00_293-((long)1)); 
BgL_iz00_293 = BgL_iz00_1365; 
goto BgL_loopz00_294;} } } } } } } 
}



/* _string-copy */
obj_t BGl__stringzd2copyzd2zz__r4_strings_6_7z00(obj_t BgL_envz00_973, obj_t BgL_stringz00_974)
{ AN_OBJECT;
{ /* Ieee/string.scm 400 */
return 
BGl_stringzd2copyzd2zz__r4_strings_6_7z00(BgL_stringz00_974);} 
}



/* string-fill! */
obj_t BGl_stringzd2fillz12zc0zz__r4_strings_6_7z00(obj_t BgL_stringz00_53, unsigned char BgL_charz00_54)
{ AN_OBJECT;
{ /* Ieee/string.scm 413 */
{ /* Ieee/string.scm 414 */
int BgL_lenz00_740;
BgL_lenz00_740 = 
STRING_LENGTH(BgL_stringz00_53); 
{ 
long BgL_iz00_747;
BgL_iz00_747 = ((long)0); 
BgL_loopz00_746:
{ /* Ieee/string.scm 414 */
bool_t BgL_testz00_1372;
{ /* Ieee/string.scm 414 */
long BgL_auxz00_1373;
BgL_auxz00_1373 = 
(long)(BgL_lenz00_740); 
BgL_testz00_1372 = 
(BgL_iz00_747==BgL_auxz00_1373); } 
if(BgL_testz00_1372)
{ /* Ieee/string.scm 414 */
return BUNSPEC;}  else 
{ /* Ieee/string.scm 414 */
{ /* Ieee/string.scm 414 */
int BgL_auxz00_1376;
BgL_auxz00_1376 = 
(int)(BgL_iz00_747); 
STRING_SET(BgL_stringz00_53, BgL_auxz00_1376, BgL_charz00_54); } 
{ 
long BgL_iz00_1379;
BgL_iz00_1379 = 
(BgL_iz00_747+((long)1)); 
BgL_iz00_747 = BgL_iz00_1379; 
goto BgL_loopz00_746;} } } } } } 
}



/* _string-fill! */
obj_t BGl__stringzd2fillz12zc0zz__r4_strings_6_7z00(obj_t BgL_envz00_975, obj_t BgL_stringz00_976, obj_t BgL_charz00_977)
{ AN_OBJECT;
{ /* Ieee/string.scm 413 */
return 
BGl_stringzd2fillz12zc0zz__r4_strings_6_7z00(BgL_stringz00_976, 
(unsigned char)CCHAR(BgL_charz00_977));} 
}



/* string-upcase */
obj_t BGl_stringzd2upcasezd2zz__r4_strings_6_7z00(obj_t BgL_stringz00_55)
{ AN_OBJECT;
{ /* Ieee/string.scm 425 */
{ /* Ieee/string.scm 426 */
int BgL_lenz00_305;
BgL_lenz00_305 = 
STRING_LENGTH(BgL_stringz00_55); 
{ /* Ieee/string.scm 426 */
obj_t BgL_resz00_306;
BgL_resz00_306 = 
make_string(BgL_lenz00_305, ((unsigned char)' ')); 
{ /* Ieee/string.scm 427 */

{ 
long BgL_iz00_307;
BgL_iz00_307 = ((long)0); 
BgL_loopz00_308:
{ /* Ieee/string.scm 429 */
bool_t BgL_testz00_1385;
{ /* Ieee/string.scm 429 */
long BgL_auxz00_1386;
BgL_auxz00_1386 = 
(long)(BgL_lenz00_305); 
BgL_testz00_1385 = 
(BgL_iz00_307==BgL_auxz00_1386); } 
if(BgL_testz00_1385)
{ /* Ieee/string.scm 429 */
return BgL_resz00_306;}  else 
{ /* Ieee/string.scm 429 */
{ /* Ieee/string.scm 432 */
unsigned char BgL_auxz00_1391;int BgL_auxz00_1389;
{ /* Ieee/string.scm 432 */
unsigned char BgL_auxz00_1392;
{ /* Ieee/string.scm 432 */
int BgL_auxz00_1393;
BgL_auxz00_1393 = 
(int)(BgL_iz00_307); 
BgL_auxz00_1392 = 
STRING_REF(BgL_stringz00_55, BgL_auxz00_1393); } 
BgL_auxz00_1391 = 
toupper(BgL_auxz00_1392); } 
BgL_auxz00_1389 = 
(int)(BgL_iz00_307); 
STRING_SET(BgL_resz00_306, BgL_auxz00_1389, BgL_auxz00_1391); } 
{ 
long BgL_iz00_1398;
BgL_iz00_1398 = 
(BgL_iz00_307+((long)1)); 
BgL_iz00_307 = BgL_iz00_1398; 
goto BgL_loopz00_308;} } } } } } } } 
}



/* _string-upcase */
obj_t BGl__stringzd2upcasezd2zz__r4_strings_6_7z00(obj_t BgL_envz00_978, obj_t BgL_stringz00_979)
{ AN_OBJECT;
{ /* Ieee/string.scm 425 */
return 
BGl_stringzd2upcasezd2zz__r4_strings_6_7z00(BgL_stringz00_979);} 
}



/* string-downcase */
obj_t BGl_stringzd2downcasezd2zz__r4_strings_6_7z00(obj_t BgL_stringz00_56)
{ AN_OBJECT;
{ /* Ieee/string.scm 438 */
{ /* Ieee/string.scm 439 */
int BgL_lenz00_314;
BgL_lenz00_314 = 
STRING_LENGTH(BgL_stringz00_56); 
{ /* Ieee/string.scm 439 */
obj_t BgL_resz00_315;
BgL_resz00_315 = 
make_string(BgL_lenz00_314, ((unsigned char)' ')); 
{ /* Ieee/string.scm 440 */

{ 
long BgL_iz00_316;
BgL_iz00_316 = ((long)0); 
BgL_loopz00_317:
{ /* Ieee/string.scm 442 */
bool_t BgL_testz00_1403;
{ /* Ieee/string.scm 442 */
long BgL_auxz00_1404;
BgL_auxz00_1404 = 
(long)(BgL_lenz00_314); 
BgL_testz00_1403 = 
(BgL_iz00_316==BgL_auxz00_1404); } 
if(BgL_testz00_1403)
{ /* Ieee/string.scm 442 */
return BgL_resz00_315;}  else 
{ /* Ieee/string.scm 442 */
{ /* Ieee/string.scm 445 */
unsigned char BgL_auxz00_1409;int BgL_auxz00_1407;
{ /* Ieee/string.scm 445 */
unsigned char BgL_auxz00_1410;
{ /* Ieee/string.scm 445 */
int BgL_auxz00_1411;
BgL_auxz00_1411 = 
(int)(BgL_iz00_316); 
BgL_auxz00_1410 = 
STRING_REF(BgL_stringz00_56, BgL_auxz00_1411); } 
BgL_auxz00_1409 = 
tolower(BgL_auxz00_1410); } 
BgL_auxz00_1407 = 
(int)(BgL_iz00_316); 
STRING_SET(BgL_resz00_315, BgL_auxz00_1407, BgL_auxz00_1409); } 
{ 
long BgL_iz00_1416;
BgL_iz00_1416 = 
(BgL_iz00_316+((long)1)); 
BgL_iz00_316 = BgL_iz00_1416; 
goto BgL_loopz00_317;} } } } } } } } 
}



/* _string-downcase */
obj_t BGl__stringzd2downcasezd2zz__r4_strings_6_7z00(obj_t BgL_envz00_980, obj_t BgL_stringz00_981)
{ AN_OBJECT;
{ /* Ieee/string.scm 438 */
return 
BGl_stringzd2downcasezd2zz__r4_strings_6_7z00(BgL_stringz00_981);} 
}



/* string-upcase! */
obj_t BGl_stringzd2upcasez12zc0zz__r4_strings_6_7z00(obj_t BgL_stringz00_57)
{ AN_OBJECT;
{ /* Ieee/string.scm 451 */
{ /* Ieee/string.scm 452 */
int BgL_lenz00_323;
BgL_lenz00_323 = 
STRING_LENGTH(BgL_stringz00_57); 
{ 
long BgL_iz00_324;
BgL_iz00_324 = ((long)0); 
BgL_loopz00_325:
{ /* Ieee/string.scm 454 */
bool_t BgL_testz00_1420;
{ /* Ieee/string.scm 454 */
long BgL_auxz00_1421;
BgL_auxz00_1421 = 
(long)(BgL_lenz00_323); 
BgL_testz00_1420 = 
(BgL_iz00_324==BgL_auxz00_1421); } 
if(BgL_testz00_1420)
{ /* Ieee/string.scm 454 */
return BgL_stringz00_57;}  else 
{ /* Ieee/string.scm 454 */
{ /* Ieee/string.scm 457 */
unsigned char BgL_auxz00_1426;int BgL_auxz00_1424;
{ /* Ieee/string.scm 457 */
unsigned char BgL_auxz00_1427;
{ /* Ieee/string.scm 457 */
int BgL_auxz00_1428;
BgL_auxz00_1428 = 
(int)(BgL_iz00_324); 
BgL_auxz00_1427 = 
STRING_REF(BgL_stringz00_57, BgL_auxz00_1428); } 
BgL_auxz00_1426 = 
toupper(BgL_auxz00_1427); } 
BgL_auxz00_1424 = 
(int)(BgL_iz00_324); 
STRING_SET(BgL_stringz00_57, BgL_auxz00_1424, BgL_auxz00_1426); } 
{ 
long BgL_iz00_1433;
BgL_iz00_1433 = 
(BgL_iz00_324+((long)1)); 
BgL_iz00_324 = BgL_iz00_1433; 
goto BgL_loopz00_325;} } } } } } 
}



/* _string-upcase! */
obj_t BGl__stringzd2upcasez12zc0zz__r4_strings_6_7z00(obj_t BgL_envz00_982, obj_t BgL_stringz00_983)
{ AN_OBJECT;
{ /* Ieee/string.scm 451 */
return 
BGl_stringzd2upcasez12zc0zz__r4_strings_6_7z00(BgL_stringz00_983);} 
}



/* string-downcase! */
obj_t BGl_stringzd2downcasez12zc0zz__r4_strings_6_7z00(obj_t BgL_stringz00_58)
{ AN_OBJECT;
{ /* Ieee/string.scm 463 */
{ /* Ieee/string.scm 464 */
int BgL_lenz00_330;
BgL_lenz00_330 = 
STRING_LENGTH(BgL_stringz00_58); 
{ 
long BgL_iz00_331;
BgL_iz00_331 = ((long)0); 
BgL_loopz00_332:
{ /* Ieee/string.scm 466 */
bool_t BgL_testz00_1437;
{ /* Ieee/string.scm 466 */
long BgL_auxz00_1438;
BgL_auxz00_1438 = 
(long)(BgL_lenz00_330); 
BgL_testz00_1437 = 
(BgL_iz00_331==BgL_auxz00_1438); } 
if(BgL_testz00_1437)
{ /* Ieee/string.scm 466 */
return BgL_stringz00_58;}  else 
{ /* Ieee/string.scm 466 */
{ /* Ieee/string.scm 469 */
unsigned char BgL_auxz00_1443;int BgL_auxz00_1441;
{ /* Ieee/string.scm 469 */
unsigned char BgL_auxz00_1444;
{ /* Ieee/string.scm 469 */
int BgL_auxz00_1445;
BgL_auxz00_1445 = 
(int)(BgL_iz00_331); 
BgL_auxz00_1444 = 
STRING_REF(BgL_stringz00_58, BgL_auxz00_1445); } 
BgL_auxz00_1443 = 
tolower(BgL_auxz00_1444); } 
BgL_auxz00_1441 = 
(int)(BgL_iz00_331); 
STRING_SET(BgL_stringz00_58, BgL_auxz00_1441, BgL_auxz00_1443); } 
{ 
long BgL_iz00_1450;
BgL_iz00_1450 = 
(BgL_iz00_331+((long)1)); 
BgL_iz00_331 = BgL_iz00_1450; 
goto BgL_loopz00_332;} } } } } } 
}



/* _string-downcase! */
obj_t BGl__stringzd2downcasez12zc0zz__r4_strings_6_7z00(obj_t BgL_envz00_984, obj_t BgL_stringz00_985)
{ AN_OBJECT;
{ /* Ieee/string.scm 463 */
return 
BGl_stringzd2downcasez12zc0zz__r4_strings_6_7z00(BgL_stringz00_985);} 
}



/* string-capitalize! */
obj_t BGl_stringzd2capitaliza7ez12z67zz__r4_strings_6_7z00(obj_t BgL_stringz00_59)
{ AN_OBJECT;
{ /* Ieee/string.scm 479 */
{ /* Ieee/string.scm 480 */
bool_t BgL_nonzd2firstzd2alphaz00_337;int BgL_stringzd2lenzd2_338;
BgL_nonzd2firstzd2alphaz00_337 = ((bool_t)0); 
BgL_stringzd2lenzd2_338 = 
STRING_LENGTH(BgL_stringz00_59); 
{ 
long BgL_iz00_340;
BgL_iz00_340 = ((long)0); 
BgL_zc3anonymousza31087ze3z83_341:
{ /* Ieee/string.scm 482 */
bool_t BgL_testz00_1454;
{ /* Ieee/string.scm 483 */
long BgL_auxz00_1455;
BgL_auxz00_1455 = 
(long)(BgL_stringzd2lenzd2_338); 
BgL_testz00_1454 = 
(BgL_iz00_340==BgL_auxz00_1455); } 
if(BgL_testz00_1454)
{ /* Ieee/string.scm 482 */
return BgL_stringz00_59;}  else 
{ /* Ieee/string.scm 482 */
{ /* Ieee/string.scm 484 */
unsigned char BgL_cz00_343;
{ /* Ieee/string.scm 484 */
int BgL_auxz00_1458;
BgL_auxz00_1458 = 
(int)(BgL_iz00_340); 
BgL_cz00_343 = 
STRING_REF(BgL_stringz00_59, BgL_auxz00_1458); } 
{ /* Ieee/string.scm 485 */
bool_t BgL_testz00_1461;
{ /* Ieee/string.scm 485 */
bool_t BgL__ortest_1006z00_842;
if(
(BgL_cz00_343>=((unsigned char)'A')))
{ /* Ieee/string.scm 485 */
BgL__ortest_1006z00_842 = 
(BgL_cz00_343<=((unsigned char)'Z')); }  else 
{ /* Ieee/string.scm 485 */
BgL__ortest_1006z00_842 = ((bool_t)0); } 
if(BgL__ortest_1006z00_842)
{ /* Ieee/string.scm 485 */
BgL_testz00_1461 = BgL__ortest_1006z00_842
; }  else 
{ /* Ieee/string.scm 485 */
if(
(BgL_cz00_343>=((unsigned char)'a')))
{ /* Ieee/string.scm 485 */
BgL_testz00_1461 = 
(BgL_cz00_343<=((unsigned char)'z'))
; }  else 
{ /* Ieee/string.scm 485 */
BgL_testz00_1461 = ((bool_t)0)
; } } } 
if(BgL_testz00_1461)
{ /* Ieee/string.scm 485 */
if(BgL_nonzd2firstzd2alphaz00_337)
{ /* Ieee/string.scm 487 */
unsigned char BgL_auxz00_1472;int BgL_auxz00_1470;
BgL_auxz00_1472 = 
tolower(BgL_cz00_343); 
BgL_auxz00_1470 = 
(int)(BgL_iz00_340); 
STRING_SET(BgL_stringz00_59, BgL_auxz00_1470, BgL_auxz00_1472); }  else 
{ /* Ieee/string.scm 486 */
BgL_nonzd2firstzd2alphaz00_337 = ((bool_t)1); 
{ /* Ieee/string.scm 490 */
unsigned char BgL_auxz00_1477;int BgL_auxz00_1475;
BgL_auxz00_1477 = 
toupper(BgL_cz00_343); 
BgL_auxz00_1475 = 
(int)(BgL_iz00_340); 
STRING_SET(BgL_stringz00_59, BgL_auxz00_1475, BgL_auxz00_1477); } } }  else 
{ /* Ieee/string.scm 485 */
BgL_nonzd2firstzd2alphaz00_337 = ((bool_t)0); } } } 
{ 
long BgL_iz00_1480;
BgL_iz00_1480 = 
(BgL_iz00_340+((long)1)); 
BgL_iz00_340 = BgL_iz00_1480; 
goto BgL_zc3anonymousza31087ze3z83_341;} } } } } } 
}



/* _string-capitalize! */
obj_t BGl__stringzd2capitaliza7ez12z67zz__r4_strings_6_7z00(obj_t BgL_envz00_986, obj_t BgL_stringz00_987)
{ AN_OBJECT;
{ /* Ieee/string.scm 479 */
return 
BGl_stringzd2capitaliza7ez12z67zz__r4_strings_6_7z00(BgL_stringz00_987);} 
}



/* string-capitalize */
obj_t BGl_stringzd2capitaliza7ez75zz__r4_strings_6_7z00(obj_t BgL_stringz00_60)
{ AN_OBJECT;
{ /* Ieee/string.scm 496 */
return 
BGl_stringzd2capitaliza7ez12z67zz__r4_strings_6_7z00(
BGl_stringzd2copyzd2zz__r4_strings_6_7z00(BgL_stringz00_60));} 
}



/* _string-capitalize */
obj_t BGl__stringzd2capitaliza7ez75zz__r4_strings_6_7z00(obj_t BgL_envz00_988, obj_t BgL_stringz00_989)
{ AN_OBJECT;
{ /* Ieee/string.scm 496 */
return 
BGl_stringzd2capitaliza7ez75zz__r4_strings_6_7z00(BgL_stringz00_989);} 
}



/* string-for-read */
obj_t BGl_stringzd2forzd2readz00zz__r4_strings_6_7z00(obj_t BgL_stringz00_61)
{ AN_OBJECT;
{ /* Ieee/string.scm 502 */
return 
string_for_read(BgL_stringz00_61);} 
}



/* _string-for-read */
obj_t BGl__stringzd2forzd2readz00zz__r4_strings_6_7z00(obj_t BgL_envz00_990, obj_t BgL_stringz00_991)
{ AN_OBJECT;
{ /* Ieee/string.scm 502 */
return 
string_for_read(BgL_stringz00_991);} 
}



/* blit-string-ur! */
obj_t BGl_blitzd2stringzd2urz12z12zz__r4_strings_6_7z00(obj_t BgL_s1z00_62, int BgL_o1z00_63, obj_t BgL_s2z00_64, int BgL_o2z00_65, int BgL_lz00_66)
{ AN_OBJECT;
{ /* Ieee/string.scm 508 */
return 
blit_string(BgL_s1z00_62, BgL_o1z00_63, BgL_s2z00_64, BgL_o2z00_65, BgL_lz00_66);} 
}



/* _blit-string-ur! */
obj_t BGl__blitzd2stringzd2urz12z12zz__r4_strings_6_7z00(obj_t BgL_envz00_992, obj_t BgL_s1z00_993, obj_t BgL_o1z00_994, obj_t BgL_s2z00_995, obj_t BgL_o2z00_996, obj_t BgL_lz00_997)
{ AN_OBJECT;
{ /* Ieee/string.scm 508 */
{ /* Ieee/string.scm 508 */
int BgL_auxz00_1493;int BgL_auxz00_1491;int BgL_auxz00_1489;
BgL_auxz00_1493 = 
CINT(BgL_lz00_997); 
BgL_auxz00_1491 = 
CINT(BgL_o2z00_996); 
BgL_auxz00_1489 = 
CINT(BgL_o1z00_994); 
return 
blit_string(BgL_s1z00_993, BgL_auxz00_1489, BgL_s2z00_995, BgL_auxz00_1491, BgL_auxz00_1493);} } 
}



/* blit-string! */
obj_t BGl_blitzd2stringz12zc0zz__r4_strings_6_7z00(obj_t BgL_s1z00_67, int BgL_o1z00_68, obj_t BgL_s2z00_69, int BgL_o2z00_70, int BgL_lz00_71)
{ AN_OBJECT;
{ /* Ieee/string.scm 514 */
{ /* Ieee/string.scm 515 */
bool_t BgL_testz00_1496;
{ /* Ieee/string.scm 515 */
bool_t BgL_testz00_1497;
{ /* Ieee/string.scm 515 */
int BgL_auxz00_1506;int BgL_auxz00_1498;
{ /* Ieee/string.scm 515 */
long BgL_auxz00_1507;
{ /* Ieee/string.scm 515 */
long BgL_auxz00_1508;
{ /* Ieee/string.scm 515 */
int BgL_auxz00_1509;
BgL_auxz00_1509 = 
STRING_LENGTH(BgL_s1z00_67); 
BgL_auxz00_1508 = 
(long)(BgL_auxz00_1509); } 
BgL_auxz00_1507 = 
(BgL_auxz00_1508+((long)1)); } 
BgL_auxz00_1506 = 
(int)(BgL_auxz00_1507); } 
{ /* Ieee/string.scm 515 */
long BgL_auxz00_1499;
{ /* Ieee/string.scm 515 */
long BgL_auxz00_1502;long BgL_auxz00_1500;
BgL_auxz00_1502 = 
(long)(BgL_o1z00_68); 
BgL_auxz00_1500 = 
(long)(BgL_lz00_71); 
BgL_auxz00_1499 = 
(BgL_auxz00_1500+BgL_auxz00_1502); } 
BgL_auxz00_1498 = 
(int)(BgL_auxz00_1499); } 
BgL_testz00_1497 = 
BOUND_CHECK(BgL_auxz00_1498, BgL_auxz00_1506); } 
if(BgL_testz00_1497)
{ /* Ieee/string.scm 516 */
int BgL_auxz00_1523;int BgL_auxz00_1515;
{ /* Ieee/string.scm 516 */
long BgL_auxz00_1524;
{ /* Ieee/string.scm 516 */
long BgL_auxz00_1525;
{ /* Ieee/string.scm 516 */
int BgL_auxz00_1526;
BgL_auxz00_1526 = 
STRING_LENGTH(BgL_s2z00_69); 
BgL_auxz00_1525 = 
(long)(BgL_auxz00_1526); } 
BgL_auxz00_1524 = 
(BgL_auxz00_1525+((long)1)); } 
BgL_auxz00_1523 = 
(int)(BgL_auxz00_1524); } 
{ /* Ieee/string.scm 516 */
long BgL_auxz00_1516;
{ /* Ieee/string.scm 516 */
long BgL_auxz00_1519;long BgL_auxz00_1517;
BgL_auxz00_1519 = 
(long)(BgL_o2z00_70); 
BgL_auxz00_1517 = 
(long)(BgL_lz00_71); 
BgL_auxz00_1516 = 
(BgL_auxz00_1517+BgL_auxz00_1519); } 
BgL_auxz00_1515 = 
(int)(BgL_auxz00_1516); } 
BgL_testz00_1496 = 
BOUND_CHECK(BgL_auxz00_1515, BgL_auxz00_1523); }  else 
{ /* Ieee/string.scm 515 */
BgL_testz00_1496 = ((bool_t)0)
; } } 
if(BgL_testz00_1496)
{ /* Ieee/string.scm 515 */
return 
blit_string(BgL_s1z00_67, BgL_o1z00_68, BgL_s2z00_69, BgL_o2z00_70, BgL_lz00_71);}  else 
{ /* Ieee/string.scm 518 */
obj_t BgL_arg1096z00_352;obj_t BgL_arg1097z00_353;
{ /* Ieee/string.scm 519 */
obj_t BgL_list1098z00_354;
{ /* Ieee/string.scm 519 */
obj_t BgL_arg1102z00_356;
{ /* Ieee/string.scm 519 */
obj_t BgL_arg1105z00_357;
{ /* Ieee/string.scm 519 */
obj_t BgL_arg1107z00_359;
{ /* Ieee/string.scm 519 */
obj_t BgL_arg1108z00_360;
BgL_arg1108z00_360 = 
MAKE_PAIR(BGl_string1242z00zz__r4_strings_6_7z00, BNIL); 
BgL_arg1107z00_359 = 
MAKE_PAIR(BgL_s2z00_69, BgL_arg1108z00_360); } 
BgL_arg1105z00_357 = 
MAKE_PAIR(BGl_string1243z00zz__r4_strings_6_7z00, BgL_arg1107z00_359); } 
BgL_arg1102z00_356 = 
MAKE_PAIR(BgL_s1z00_67, BgL_arg1105z00_357); } 
BgL_list1098z00_354 = 
MAKE_PAIR(BGl_string1244z00zz__r4_strings_6_7z00, BgL_arg1102z00_356); } 
BgL_arg1096z00_352 = 
BGl_stringzd2appendzd2zz__r4_strings_6_7z00(BgL_list1098z00_354); } 
{ /* Ieee/string.scm 520 */
int BgL_arg1110z00_361;int BgL_arg1112z00_362;
BgL_arg1110z00_361 = 
STRING_LENGTH(BgL_s1z00_67); 
BgL_arg1112z00_362 = 
STRING_LENGTH(BgL_s2z00_69); 
{ /* Ieee/string.scm 520 */
obj_t BgL_list1113z00_363;
{ /* Ieee/string.scm 520 */
obj_t BgL_arg1114z00_364;
{ /* Ieee/string.scm 520 */
obj_t BgL_arg1115z00_365;
{ /* Ieee/string.scm 520 */
obj_t BgL_arg1116z00_366;
{ /* Ieee/string.scm 520 */
obj_t BgL_arg1117z00_367;
{ /* Ieee/string.scm 520 */
obj_t BgL_auxz00_1541;
BgL_auxz00_1541 = 
BINT(BgL_lz00_71); 
BgL_arg1117z00_367 = 
MAKE_PAIR(BgL_auxz00_1541, BNIL); } 
{ /* Ieee/string.scm 520 */
obj_t BgL_auxz00_1544;
BgL_auxz00_1544 = 
BINT(BgL_o2z00_70); 
BgL_arg1116z00_366 = 
MAKE_PAIR(BgL_auxz00_1544, BgL_arg1117z00_367); } } 
{ /* Ieee/string.scm 520 */
obj_t BgL_auxz00_1547;
BgL_auxz00_1547 = 
BINT(BgL_arg1112z00_362); 
BgL_arg1115z00_365 = 
MAKE_PAIR(BgL_auxz00_1547, BgL_arg1116z00_366); } } 
{ /* Ieee/string.scm 520 */
obj_t BgL_auxz00_1550;
BgL_auxz00_1550 = 
BINT(BgL_o1z00_68); 
BgL_arg1114z00_364 = 
MAKE_PAIR(BgL_auxz00_1550, BgL_arg1115z00_365); } } 
{ /* Ieee/string.scm 520 */
obj_t BgL_auxz00_1553;
BgL_auxz00_1553 = 
BINT(BgL_arg1110z00_361); 
BgL_list1113z00_363 = 
MAKE_PAIR(BgL_auxz00_1553, BgL_arg1114z00_364); } } 
BgL_arg1097z00_353 = BgL_list1113z00_363; } } 
FAILURE(BGl_string1245z00zz__r4_strings_6_7z00,BgL_arg1096z00_352,BgL_arg1097z00_353);} } } 
}



/* _blit-string! */
obj_t BGl__blitzd2stringz12zc0zz__r4_strings_6_7z00(obj_t BgL_envz00_998, obj_t BgL_s1z00_999, obj_t BgL_o1z00_1000, obj_t BgL_s2z00_1001, obj_t BgL_o2z00_1002, obj_t BgL_lz00_1003)
{ AN_OBJECT;
{ /* Ieee/string.scm 514 */
return 
BGl_blitzd2stringz12zc0zz__r4_strings_6_7z00(BgL_s1z00_999, 
CINT(BgL_o1z00_1000), BgL_s2z00_1001, 
CINT(BgL_o2z00_1002), 
CINT(BgL_lz00_1003));} 
}



/* imported-modules-init */
obj_t BGl_importedzd2moduleszd2initz00zz__r4_strings_6_7z00()
{ AN_OBJECT;
{ /* Ieee/string.scm 18 */
return 
BGl_modulezd2initializa7ationz75zz__errorz00(((long)50663), "__r4_strings_6_7");} 
}

