/*=====================================================================*/
/*    .../prgm/project/bigloo/runtime/Jlib/input_pipe_port.java        */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Sat Dec  9 11:49:41 2000                          */
/*    Last change :  Tue Nov  6 10:09:21 2001 (serrano)                */
/*    Copyright   :  2000-01 Manuel Serrano                            */
/*    -------------------------------------------------------------    */
/*    Bigloo JVM input pipe ports.                                     */
/*=====================================================================*/
package bigloo;

import java.lang.*;
import java.io.*;

/*---------------------------------------------------------------------*/
/*    input_pipe_port ...                                              */
/*---------------------------------------------------------------------*/
public class input_pipe_port extends input_port {
    public InputStream in;

/*--- public constructors ---------------------------------------------*/
    public input_pipe_port( InputStream is, byte[] c ) {
	super( new String(c), (int)bigloo.foreign.default_io_bufsiz );
	in = is;
    }

    public input_pipe_port( byte[] cmd, int len ) {
	super( new String( cmd ), len );

	String scmd = new String( cmd, 2, cmd.length - 2 );
	Process process;
	try {
	    process = Runtime.getRuntime().exec( scmd );
	    in = process.getInputStream();
	}
	catch( IOException e ) {
	    foreign.fail( "open-input-file",
			  "Can't execute command",
			  scmd.getBytes() );
	}
    }

    public input_pipe_port( String cmd, int len ) {
	super( cmd, len );

	Process process;
	try {
	    process = Runtime.getRuntime().exec( cmd );
	    in = process.getInputStream();
	}
	catch( IOException e ) {
	    foreign.fail( "open-input-file",
			  "Can't execute command",
			  cmd.getBytes() );
	}
    }

/*--- public methods --------------------------------------------------*/
    public void close() throws IOException {
	eof = true;
	other_eof = true;
	in.close();
    }

    public boolean rgc_charready() {
	try{ 
	    return ((forward+1) < abufsiz) || (in.available()>0);
	} catch( Exception _ ) {
	    return false;
	}
    }

    public boolean rgc_fill_buffer() throws IOException {
	int bufsize = this.bufsiz;
	int abufsize = this.abufsiz;
	int matchstart = this.matchstart;
	byte[] buffer = this.buffer;
	if(matchstart > 0) {
	    int movesize = abufsize - matchstart;
	    // we shift the buffer left and we fill the buffer */
	    for(int i=0; i<movesize; i++) buffer[i] = buffer[matchstart + i];
	    abufsize -= matchstart;
	    this.matchstart = 0;
	    this.matchstop -= matchstart;
	    this.forward -= matchstart;
	    this.lastchar = buffer[ matchstart - 1 ];
	    return( rgc_size_fill_file_buffer( abufsize, bufsize-abufsize ) );
	}
      if(abufsize < bufsize)
	 return(rgc_size_fill_file_buffer(abufsize, bufsize - abufsize));
      // we current token is too large for the buffer */
      // we have to enlarge it.                       */
      rgc_enlarge_buffer();
      return(rgc_fill_buffer());
    }

    final boolean rgc_size_fill_file_buffer(int abufsize, int size)
	throws IOException {
	int nbread = in.read(buffer, abufsize-1, size);
	if(nbread == -1) {
	    nbread = 0;
	    eof = true;
	}
	abufsize += nbread;
	this.abufsiz = abufsize;
	if(abufsize > 0) {
	    buffer[abufsize - 1] = (byte) 0;
	    return(true);
	}
	return(false);
    }

    public void write(output_port p) {
	p.write( "#<input_pipe_port:" + name + ">");
    }

/*--- static methods --------------------------------------------------*/
    static boolean pipe_name_p( byte[] name ) {
	return( (name[ 0 ] == (byte)'|') && (name[ 1 ] == (byte)' ') );
    }
}

	
