;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Ieee/fixnum.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jan 20 10:06:37 1995                          */
;*    Last change :  Sun Jun  3 12:06:59 2001 (serrano)                */
;*    -------------------------------------------------------------    */
;*    6.5. Numbers (page 18, r4) The `fixnum' functions                */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __r4_numbers_6_5_fixnum
   
   (import  __error)
   
   (use     __type
	    __bigloo
	    __tvector
	    __r4_booleans_6_1
	    __r4_vectors_6_8
	    __r4_strings_6_7
	    __r4_characters_6_6
	    __r4_symbols_6_4
	    __r4_pairs_and_lists_6_3
	    
	    __evenv)

   (extern  (macro c-fixnum?::bool (::obj) "INTEGERP")
	    (macro c-elong?::bool (::obj) "ELONGP")
	    (macro c-llong?::bool (::obj) "LLONGP")
	    (infix macro c-=fx::bool (::long ::long) "==")
	    (infix macro c-<fx::bool (::long ::long) "<")
	    (infix macro c-<=fx::bool (::long ::long) "<=")
	    (infix macro c->fx::bool (::long ::long) ">")
	    (infix macro c->=fx::bool (::long ::long) ">=")
	    (macro c-even?::bool (::long) "EVENP_FX")
	    (macro c-odd?::bool (::long) "ODDP_FX")
	    (infix macro c-+fx::long (::long ::long) "+")
	    (infix macro c--fx::long (::long ::long) "-")
	    (infix macro c-*fx::long (::long ::long) "*")
	    (infix macro c-/fx::long (::long ::long) "/")
	    (macro c-negfx::long (::long) "NEG")
	    (infix macro c-quotient::long (::long ::long) "/")
	    (infix macro c-remainder::long (::long ::long) "%")
	    (macro strtol::long (::string ::long ::long) "strtol")
	    (c-int->string::bstring  (::long ::long) "integer_to_string")
	    (macro %%rand::int () "rand"))
   
   (java    (class foreign
	       (method static c-fixnum?::bool (::obj)
		       "INTEGERP")
	       (method static c-elong?::bool (::obj)
		       "ELONGP")
	       (method static c-llong?::bool (::obj)
		       "LLONGP")
	       (method static c-=fx::bool (::long ::long)
		       "EQ_FX")
	       (method static c-<fx::bool (::long ::long)
		       "LT_FX")
	       (method static c-<=fx::bool (::long ::long)
		       "LE_FX")
	       (method static c->fx::bool (::long ::long)
		       "GT_FX")
	       (method static c->=fx::bool (::long ::long)
		       "GE_FX")
	       (method static c-even?::bool (::long)
		       "EVENP_FX")
	       (method static c-odd?::bool (::long)
		       "ODDP_FX")
	       (method static c-+fx::long (::long ::long)
		       "PLUS_FX")
	       (method static c--fx::long (::long ::long)
		       "MINUS_FX")
	       (method static c-*fx::long (::long ::long)
		       "MUL_FX")
	       (method static c-/fx::long (::long ::long)
		       "DIV_FX")
	       (method static c-negfx::long (::long)
		       "NEG_FX")
	       (method static c-quotient::long (::long ::long)
		       "QUOTIENT_FX")
	       (method static c-remainder::long (::long ::long)
		       "REMAINDER_FX")
	       (method static strtol::long (::string ::long ::long)
		       "strtol")
	       (method static c-int->string::bstring (::long ::long)
		       "integer_to_string")
	       (method static %%rand::int ()
		       "rand")))
   
   (export  (inline integer?::bool ::obj)
	    (inline fixnum?::bool ::obj)
	    (inline elong?::bool ::obj)
	    (inline llong?::bool ::obj)
	    (inline make-elong::belong ::long)
	    (inline =fx::bool ::long ::long)
	    (inline >fx::bool ::long ::long)
	    (inline >=fx::bool ::long ::long)
	    (inline <fx::bool ::long ::long)
	    (inline <=fx::bool ::long ::long)
	    (inline zerofx?::bool ::long)
	    (inline positivefx?::bool ::long)
	    (inline negativefx?::bool ::long)
	    (inline odd?::bool ::long)
	    (inline even?::bool ::long)
	    (maxfx::long ::long . pair)
	    (minfx::long ::long . pair)
	    (inline +fx::long ::long ::long)
	    (inline -fx::long ::long ::long)
	    (inline *fx::long ::long ::long)
	    (inline /fx::long ::long ::long)
	    (inline negfx::long ::long)
	    (inline absfx::long ::long)
	    (inline quotient::long ::long ::long)
	    (inline remainder::long ::long ::long)
	    (modulo::long ::long ::long)
	    (gcd::long . pair)
	    (lcm::long . pair)
	    (integer->string::bstring ::long . pair)
	    (string->integer::long ::bstring . pair)
	    (string->elong::belong ::string . pair)
	    (string->llong::bllong ::string . pair)
	    (inline random::int ::int))
   
   (pragma  (fixnum? (predicate-of bint) no-cfa-top nesting)
	    (c-fixnum? (predicate-of bint) no-cfa-top nesting)
	    (c-elong? (predicate-of belong) no-cfa-top nesting)
	    (c-llong? (predicate-of bllong) no-cfa-top nesting)
	    (integer? side-effect-free no-cfa-top nesting)
	    (=fx side-effect-free no-cfa-top nesting)
	    (>fx side-effect-free no-cfa-top nesting)
	    (>=fx side-effect-free no-cfa-top nesting)
	    (<fx side-effect-free no-cfa-top nesting)
	    (<=fx side-effect-free no-cfa-top nesting)
	    (odd? side-effect-free no-cfa-top nesting)
	    (even? side-effect-free no-cfa-top nesting)
	    (+fx side-effect-free no-cfa-top nesting)
	    (-fx side-effect-free no-cfa-top nesting)
	    (*fx side-effect-free no-cfa-top nesting)
	    (/fx side-effect-free no-cfa-top nesting)
	    (remainder side-effect-free no-cfa-top nesting)
	    (integer->string side-effect-free no-cfa-top nesting)
	    (string->integer side-effect-free no-cfa-top nesting)
	    (modulo side-effect-free no-cfa-top nesting)
	    (gcd side-effect-free no-cfa-top nesting)
	    (lcm side-effect-free no-cfa-top nesting)
	    (quotient side-effect-free no-cfa-top nesting)
	    (positivefx? side-effect-free no-cfa-top nesting)
	    (negativefx? side-effect-free no-cfa-top nesting)
	    (zerofx? side-effect-free no-cfa-top nesting)
	    (negfx side-effect-free no-cfa-top nesting)
	    (c-=fx side-effect-free no-cfa-top nesting)
	    (c->fx side-effect-free no-cfa-top nesting)
	    (c->=fx side-effect-free no-cfa-top nesting)
	    (c-<fx side-effect-free no-cfa-top nesting)
	    (c-<=fx side-effect-free no-cfa-top nesting)
	    (c-odd? side-effect-free no-cfa-top nesting)
	    (c-even? side-effect-free no-cfa-top nesting)
	    (c-+fx side-effect-free no-cfa-top nesting)
	    (c--fx side-effect-free no-cfa-top nesting)
	    (c-*fx side-effect-free no-cfa-top nesting)
	    (c-/fx side-effect-free no-cfa-top nesting)
	    (c-negfx side-effect-free no-cfa-top nesting)
	    (random side-effect-free no-cfa-top nesting)))

;*---------------------------------------------------------------------*/
;*    integer? ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (integer? obj)
   (c-fixnum? obj))

;*---------------------------------------------------------------------*/
;*    fixnum? ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (fixnum? obj)
   (c-fixnum? obj))

;*---------------------------------------------------------------------*/
;*    elong? ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (elong? obj)
   (c-elong? obj))

;*---------------------------------------------------------------------*/
;*    llong? ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (llong? obj)
   (c-llong? obj))

;*---------------------------------------------------------------------*/
;*    make-elong ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (make-elong long)
   (long->belong long))

;*---------------------------------------------------------------------*/
;*    =fx ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (=fx n1 n2)
   (c-=fx n1 n2))

;*---------------------------------------------------------------------*/
;*    <fx ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (<fx n1 n2)
   (c-<fx n1 n2))

;*---------------------------------------------------------------------*/
;*    >fx ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (>fx n1 n2)
   (c->fx n1 n2))

;*---------------------------------------------------------------------*/
;*    <=fx ...                                                         */
;*---------------------------------------------------------------------*/
(define-inline (<=fx n1 n2)
   (c-<=fx n1 n2))

;*---------------------------------------------------------------------*/
;*    >=fx ...                                                         */
;*---------------------------------------------------------------------*/
(define-inline (>=fx n1 n2)
   (c->=fx n1 n2))

;*---------------------------------------------------------------------*/
;*    zerofx? ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (zerofx? n)
   (=fx n 0))

;*---------------------------------------------------------------------*/
;*    positivefx?  ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (positivefx? n)
   (>fx n 0))

;*---------------------------------------------------------------------*/
;*    negativefx? ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (negativefx? n)
   (<fx n 0))

;*---------------------------------------------------------------------*/
;*    odd? ...                                                         */
;*---------------------------------------------------------------------*/
(define-inline (odd? x)
   (c-odd? x))

;*---------------------------------------------------------------------*/
;*    even? ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (even? x)
   (c-even? x))

;*---------------------------------------------------------------------*/
;*    maxfx ...                                                        */
;*---------------------------------------------------------------------*/
(define (maxfx n1 . nn)
   (let loop ((max n1)
	      (nn  nn))
      (if (null? nn)
	  max
	  (if (>fx (car nn) max)
	      (loop (car nn) (cdr nn))
	      (loop max (cdr nn))))))

;*---------------------------------------------------------------------*/
;*    minfx ...                                                        */
;*---------------------------------------------------------------------*/
(define (minfx n1 . nn)
   (let loop ((min n1)
	      (nn  nn))
      (if (null? nn)
	  min
	  (if (<fx (car nn) min)
	      (loop (car nn) (cdr nn))
	      (loop min (cdr nn))))))

;*---------------------------------------------------------------------*/
;*    +fx ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (+fx z1 z2)
   (c-+fx z1 z2))

;*---------------------------------------------------------------------*/
;*    -fx ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (-fx z1 z2)
   (c--fx z1 z2))

;*---------------------------------------------------------------------*/
;*    *fx ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (*fx z1 z2)
   (c-*fx z1 z2))

;*---------------------------------------------------------------------*/
;*    /fx ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (/fx z1 z2)
   (c-/fx z1 z2))

;*---------------------------------------------------------------------*/
;*    negfx ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (negfx n1)
   (c-negfx n1))

;*---------------------------------------------------------------------*/
;*    absfx ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (absfx n)
   (if (<fx n 0)
       (negfx n)
       n))

;*---------------------------------------------------------------------*/
;*    quotient ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (quotient n1 n2)
   (c-quotient n1 n2))

;*---------------------------------------------------------------------*/
;*    remainder ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (remainder n1 n2)
   (c-remainder n1 n2))

;*---------------------------------------------------------------------*/
;*    modulo ...                                                       */
;*---------------------------------------------------------------------*/
(define (modulo x y)
   (let ((r (remainder x y)))
      (if (zerofx? r)
	  r
	  (if (positivefx? y)
	      (if (positivefx? r) r (+fx y r))
	      (if (negativefx? r) r (+fx y r))))))

;*---------------------------------------------------------------------*/
;*    gcd ...                                                          */
;*---------------------------------------------------------------------*/
(define (gcd . x)
    (define (gcd2 m n)
       (if (zerofx? n)
	   m
	   (let ((r (remainder m n)))
	      (if (=fx r 0)
		  n
		  (gcd2 n r)))))
    (case (length x)
       ((0) 0)
       ((1) (absfx (car x)))
       (else
	(let loop ((result (gcd2 (absfx (car x)) (absfx (cadr x))))
			(left (cddr x)))
		(if (pair? left)
		    (loop (gcd2 result (absfx (car left))) (cdr left))
		    result)))))

;*---------------------------------------------------------------------*/
;*    lcm ...                                                          */
;*---------------------------------------------------------------------*/
(define (lcm . x)
   (define (lcm2 m n)
      (let ((m (absfx m)) (n (absfx n)))
	 (cond ((=fx m n) m)
	       ((=fx (remainder m n) 0) m)
	       ((=fx (remainder n m) 0) n)
	       (else (*fx (/fx m (gcd m n)) n)))))
   (case (length x)
      ((0) 1)
      ((1) (absfx (car x)))
      (else (let loop ((result (lcm2 (car x) (cadr x))) (left (cddr x)))
	       (if (pair? left)
		   (loop (lcm2 result (car left)) (cdr left))
		   result)))))

;*---------------------------------------------------------------------*/
;*    integer->string ...                                              */
;*---------------------------------------------------------------------*/
(define (integer->string x . radix)
   (if (null? radix)
       (set! radix 10)
       (set! radix (car radix)))
   (case radix
      ((2 8 10 16)
       (c-int->string x radix))
      (else
       (error "integer->string" "Illegal radix" radix))))

;*---------------------------------------------------------------------*/
;*    string->integer ...                                              */
;*---------------------------------------------------------------------*/
(define (string->integer string . radix)
   (if (null? radix)
       (set! radix 10)
       (set! radix (car radix)))
   (strtol string 0 radix))

;*---------------------------------------------------------------------*/
;*    string->elong ...                                                */
;*---------------------------------------------------------------------*/
(define (string->elong string . radix)
   (if (pair? radix)
       (long->belong (string->integer string (car radix)))
       (long->belong (string->integer string))))

;*---------------------------------------------------------------------*/
;*    string->llong ...                                                */
;*---------------------------------------------------------------------*/
(define (string->llong string . radix)
   (if (pair? radix)
       (long->llong (string->integer string (car radix)))
       (long->llong (string->integer string))))

;*---------------------------------------------------------------------*/
;*    random ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (random max::int)
   (modulo (%%rand) max))
