;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime/Eval/expd-define.scm         */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Jan  4 17:14:30 1993                          */
;*    Last change :  Mon May  7 18:46:06 2001 (serrano)                */
;*                                                                     */
;*    Les expanseurs des formes `define's et `lambda'                  */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __expander_define
   
   (import  __error
	    __bigloo
	    __tvector
	    __structure
	    __tvector
	    __bexit
	    
	    __r4_numbers_6_5
	    __r4_numbers_6_5_fixnum
	    __r4_numbers_6_5_flonum
	    __r4_characters_6_6
	    __r4_equivalence_6_2
	    __r4_booleans_6_1
	    __r4_symbols_6_4
	    __r4_strings_6_7
	    __r4_pairs_and_lists_6_3
	    __r4_input_6_10_2
	    __r4_control_features_6_9
	    __r4_vectors_6_8
	    __r4_ports_6_10_1
	    __r4_output_6_10_3
	    
	    __progn
	    __expand)
   
   (use     __type
	    __evenv)

   (export  (expand-eval-lambda        <expression> <expander>)
	    (expand-eval-define        <expression> <expander>)
	    (expand-eval-define-inline <expression> <expander>)))

;*---------------------------------------------------------------------*/
;*    expand-eval-lambda ...                                           */
;*---------------------------------------------------------------------*/
(define (expand-eval-lambda x e)
   (let ((old-internal internal-definition?))
      (set! internal-definition? #t)
      (let ((res (match-case x
		    ((?- ?args . (and ?body (not ())))
		     (let ((e (internal-begin-expander e)))
			`(lambda ,args
			    ,(e (normalize-progn body) e))))
		    (else
		     (error "lambda" "Illegal form" x)))))
	 (set! internal-definition? old-internal)
	 (replace! x res))))

;*---------------------------------------------------------------------*/
;*    internal-definition? ...                                         */
;*---------------------------------------------------------------------*/
(define internal-definition? #f)

;*---------------------------------------------------------------------*/
;*    expand-eval-define ...                                           */
;*    -------------------------------------------------------------    */
;*    on divise en deux sous:                                          */
;*       1- on define une lambda.                                      */
;*       2- on define une valeur (autre qu'un lambda).                 */
;*---------------------------------------------------------------------*/
(define (expand-eval-define x e)
   (if internal-definition?
       (expand-eval-internal-define x e)
       (expand-eval-external-define x e)))

;*---------------------------------------------------------------------*/
;*    expand-eval-internal-define ...                                  */
;*---------------------------------------------------------------------*/
(define (expand-eval-internal-define x e)
   (match-case x
      ;; 1- a lambda definition
      ((or (?- (?name . ?args) . (and ?body (not ())))
	   (?- ?name (lambda ?args . (and ?body (not ())))))
       (let ((res `(define ,(car (parse-formal-ident name))
		      (lambda ,args ,(e (normalize-progn body) e)))))
	  (replace! x res)))
      ;; 2- a variable definition
      ((?- ?name . (?value . ()))
       (let ((res `(define ,(car (parse-formal-ident name)) ,(e value e))))
	  (replace! x res)))
      ;; 3- an illegal define form
      (else
       (error "define" "Illegal form" x))))

;*---------------------------------------------------------------------*/
;*    internal-begin-expander ...                                      */
;*---------------------------------------------------------------------*/
(define (internal-begin-expander old-expander)
   (lambda (expr expander)
      (let ((res (match-case expr
		    ((begin)
		     (error 'begin "Illegal form" expr))
		    ((begin . ?rest)
		     `(begin ,@(lambda-defines
				(map (lambda (x) (expander x expander))
				     rest))))
		    (else
		     (old-expander expr expander)))))
      (replace! expr res))))
				 
;*---------------------------------------------------------------------*/
;*    lambda-defines ...                                               */
;*---------------------------------------------------------------------*/
(define (lambda-defines body)
    (let loop ((oldforms  body)
	       (newforms '())
	       (vars     '())
	       (sets     '()))
       (if (pair? oldforms)
	   (let ((form (car oldforms)))
	      (cond ((or (not (pair? form))
			 (not (eq? (car form) 'define)))
		     (loop (cdr oldforms)
			   (cons form newforms)
			   vars sets))
		    (else
		     (loop (cdr oldforms) newforms
			   (cons (cadr form) vars)
			   (cons `(set! ,(cadr form) ,(caddr form))
				 sets)))))
	   (if (not (null? vars))
	       `(((lambda ,vars (begin ,@(reverse sets) ,@(reverse newforms)))
		  ,@(vector->list (make-vector (length vars) 0))))
	       body))))

;*---------------------------------------------------------------------*/
;*    expand-eval-external-define ...                                  */
;*---------------------------------------------------------------------*/
(define (expand-eval-external-define x e)
   (set! internal-definition? #t)
   (let ((e (internal-begin-expander e)))
      (let* ((err  (lambda () (error "define" "Illegal form" x)))
	     (res  (if (and (pair? x) (pair? (cdr x)) (pair? (cddr x)))
		       (let ((type (cadr x)))
			  (cond
			     ((and (pair? type) (symbol? (car type)))
			      `(define ,(car type)
				  (lambda ,(cdr type)
				     ,(e (normalize-progn (cddr x)) e))))
			     ((symbol? type)
			      `(define ,type
				  ,(e (normalize-progn (cddr x)) e)))
			     (else
			      (err))))
		       (err))))
	 (set! internal-definition? #f)
	 (replace! x res))))

;*---------------------------------------------------------------------*/
;*    expand-eval-define-inline ...                                    */
;*---------------------------------------------------------------------*/
(define (expand-eval-define-inline x e)
   (match-case x
      ((?- (?fun . ?formals) . (and ?body (not ())))
       (let ((res `(define ,(car (parse-formal-ident fun))
		      (lambda ,formals ,(e (normalize-progn body) e)))))
	  (replace! x res)))
      (else
       (error "define-inline" "Illegal form" x))))

