;*=====================================================================*/
;*    serrano/prgm/project/bigloo/recette/hygien.scm                   */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Feb 27 12:52:59 1998                          */
;*    Last change :  Wed Dec  5 14:04:55 2001 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Hygienic macro tests                                             */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module hygien
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-hygien))
   (option  (set! *hygien?* #t)))

;*---------------------------------------------------------------------*/
;*    global syntax                                                    */
;*---------------------------------------------------------------------*/
(define-syntax funcall
  (syntax-rules ()
     ((funcall function arguments ...)
      (function arguments ...) ) ) )

(define-syntax unless
   (syntax-rules ()
      ((unless condition form ...)
       (if (not condition) (begin form ...)) ) ) )

(define-syntax when
  (syntax-rules ()
    ((when condition form ...)
     (if condition (begin form ...)) ) ) )

(define-syntax progn
  (syntax-rules ()
    ((progn body ...)
     (begin body ...) ) ) )

(define (test1)
  (list
   (let ((f (lambda (x) (funcall cons x x))))
     (funcall f (+ 2 3)) )
   (let ((x 'a))
     (unless 1 (set! x 'b) 3)
     x )
   (unless #f 2 3)
   (let ((x 'a))
     (unless #f (set! x 'b) 3)
     x )
   (progn (when #f 2 3) (when 1 2 3))
   (let ((x 'a))
     (when #f (set! x 'b) 3)
     x )
   ) )

(define (test1-eval)
   (eval '(set! *hygien?* #t))

   (eval '(define-syntax funcall
	     (syntax-rules ()
		((funcall function arguments ...)
		 (function arguments ...) ) ) ) )

   (eval '(define-syntax unless
	     (syntax-rules ()
		((unless condition form ...)
		 (if (not condition) (begin form ...)) ) ) ) )

   (eval '(define-syntax when
	     (syntax-rules ()
		((when condition form ...)
		 (if condition (begin form ...)) ) ) ) )

   (eval '(define-syntax progn
	     (syntax-rules ()
		((progn body ...)
		 (begin body ...) ) ) ) )

   (eval '(define (test1)
	     (list
	      (let ((f (lambda (x) (funcall cons x x))))
		 (funcall f (+ 2 3)) )
	      (let ((x 'a))
		 (unless 1 (set! x 'b) 3)
		 x )
	      (unless #f 2 3)
	      (let ((x 'a))
		 (unless #f (set! x 'b) 3)
		 x )
	      (progn (when #f 2 3) (when 1 2 3))
	      (let ((x 'a))
		 (when #f (set! x 'b) 3)
		 x )
	      ) ) )
   (eval '(test1)))

;*---------------------------------------------------------------------*/
;*    define ...                                                       */
;*---------------------------------------------------------------------*/
(define-syntax foodefine
  (syntax-rules ()
    ((foodefine x v)
     (define x v))))
(foodefine rglup 4)

(define (test2-eval)
   (eval '(set! *hygien?* #t))
   (eval '(define-syntax foodefine
	     (syntax-rules ()
		((foodefine x v)
		 (define x v)))))
   (eval ' (foodefine rglup 4)))

(define-syntax array
  (syntax-rules ()
    ((array e e-get (t u ...)) 
     (begin (define e (make-vector (* t u ...) 0))
            (define e-get (array-sub e 0 (i j k l m n o p) () (u ... 1)))))))

(define-syntax array-sub
  (syntax-rules ()
    ((array-sub v old (i index ...) (arg ...) ())
     (lambda (arg ...) (vector-ref v old)))
    ((array-sub v old (i index ...) (arg ...) (s slice ...))
     (array-sub v (* (+ old i) s) (index ...) (arg ... i) (slice ...)))))

(array y gety (4 5 6))
(gety 2 3 4)


(define e (make-vector (* 10 10 10) 0))
(define e-get (array-sub e 0 (i j k l) () (10 10 1)))

;*---------------------------------------------------------------------*/
;*    test-hygien ...                                                  */
;*---------------------------------------------------------------------*/
(define (test-hygien)
   (test-module "hygien" "hygien.scm")
   (test "let-syntax"
	 (let-syntax ((when (syntax-rules ()
			       ((when test stmt1 stmt2 ...)
				(if test
				    (begin stmt1 stmt2 ...))))))
	    (let ((if #t))
	       (when if (set! if 'now))
	       if))
	 'now)
   (test "let-syntax"
	 (let ((x 'outer))
	    (let-syntax ((m (syntax-rules () ((m) x))))
	       (let ((x 'inner))
		  (m))))
	 'outer)
   (test "letrec-syntax"
	 (letrec-syntax ((my-or (syntax-rules ()
				   ((my-or) #f)
				   ((my-or e) e)
				   ((my-or e1 e2 ...)
				    (let ((temp e1))
				       (if temp
					   temp
					   (my-or e2 ...)))))))
	    (let ((x #f)
		  (y 7)
		  (temp 8)
		  (let odd?)
		  (if even?))
	       (my-or x
		      (let temp)
		      (if y)
		      y)))
	 7)
   (test "define-syntax" (test1) '((5 . 5) a 3 b 3 a))
   (test "eval" (test1-eval) '((5 . 5) a 3 b 3 a))
   (test "define" rglup 4)
   (test "define.2" (e-get 4 3 5) 0)
   (test "define(eval)" (begin (test2-eval) (eval 'rglup)) 4))


