;*=====================================================================*/
;*    serrano/prgm/project/bigloo/recette/dsssl.scm                    */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Mar 31 09:21:59 1998                          */
;*    Last change :  Tue Aug 28 13:25:08 2001 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Dsssl keyword test                                               */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module dsssl
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-dsssl)
	    (foo x y #!optional #!rest #!key)
	    (dsssl-lexical b c #!optional)))

(define (foo x y #!optional z (zz 1) #!rest r #!key i (j 1))
   (let ((f (lambda (z y #!key (i 8)) (list z y i))))
      (labels ((g (a b #!rest l) (list a b l)))
	 (list x y z zz i: i j: j))))

(define (test-dsssl-eval)
   (eval '(define (dsssl x y #!optional z (zz 1) #!rest r #!key i (j 1))
	     (let ((f (lambda (z y #!key (i 8)) (list z y i))))
		(labels ((g (a b #!rest l) (list a b l)))
		   (list x y z zz i: i j: j)))))
   #t)

(define (dsssl-lexical b c #!optional (=::procedure equal?))
   (= b c))

(define (connect #!optional environment #!key (hostname "localhost"))
   (cons environment hostname))

;*---------------------------------------------------------------------*/
;*    test-dsssl ...                                                   */
;*---------------------------------------------------------------------*/
(define (test-dsssl)
   (test-module "dsssl" "dsssl.scm")
   (test "dsssl" (foo 1 2 3 4 i: 5) '(1 2 3 4 i: 5 j: 1))
   (test "dsssl" (foo 1 2 3 4 i: 5 j: 3) '(1 2 3 4 i: 5 j: 3))
   (test "dsssl" ((lambda (x y #!optional z #!rest r #!key i (j 1))
		     (list x y z i: i j: j))
		  3 4 5 i: 6 i: 7)
	 '(3 4 5 i: 6 j: 1))
   (test "eval" (test-dsssl-eval) #t)
   (test "eval" (eval '(dsssl 1 2 3 4 i: 5)) '(1 2 3 4 i: 5 j: 1))
   (test "dsssl" (eval '((lambda (x y #!optional z #!rest r #!key i (j 1))
			    (list x y z i: i j: j))
		       3 4 5 i: 6 i: 7))
	 '(3 4 5 i: 6 j: 1))
   (test "lexical" (dsssl-lexical '(1 2) (list 1 2)) #t)
   (test "optional+key" (connect 3) '(3 . "localhost"))
   (test "optional+key" (connect 3 hostname: "hueco") '(3 . "hueco"))
   (test "optional+rest+key"
	 (eval '((lambda (x y #!optional z #!rest r #!key i (j 1))
		    (list x y z r: r i: i j: j))
		 3 4 5 6 i: 6))
	 '(3 4 5 r: (6 i: 6) i: 6 j: 1))
   (test "optional+rest+key"
	 (eval '((lambda (x y #!optional z #!rest r #!key i (j 1))
		    (list x y z r: r i: i j: j))
		 3 4 5 6 7 8 9 i: 6))
	 '(3 4 5 r: (6 7 8 9 i: 6) i: 6 j: 1))
   (test "ucs2-char" (ucs2->integer (integer->ucs2 (char->integer #\a)))
	 (char->integer #\a)))
	 
