;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Engine/param.scm            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Oct  3 12:44:17 1995                          */
;*    Last change :  Tue Nov 27 10:28:01 2001 (serrano)                */
;*    Copyright   :  1995-2001 Manuel Serrano, see LICENSE file        */
;*    -------------------------------------------------------------    */
;*    Global control of the compiler                                   */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module engine_param
   (import  ;; tools_date is a generated file and hence, it can't be
	    ;; set in the .afile file.
	    (tools_date "Tools/date.scm")
	    tools_misc
	    engine_configure)
   (export  *bigloo-version*
	    *bigloo-name*
	    *bigloo-cmd-name*
	    *bigloo-args*
	    *rest-args*
	    *bigloo-author*    
	    *bigloo-email*     
	    *bigloo-date*
	    *bigloo-tmp*
	    *bigloo-licensing?*
	    *lib-mode*
	    *init-mode*
	    *dlopen-init*
	    *max-c-token-length*
	    *max-c-foreign-arity*
	    *verbose*
	    *hello*
	    *unsafe-type*      
	    *unsafe-range*     
	    *unsafe-struct*    
	    *unsafe-arity*
	    *unsafe-version*
	    *unsafe-library*
	    *warning-overriden-slots*
	    *profile-library*
	    *trace-name*
	    *trace-write-length*
	    *additional-traces*
	    *inlining?*
	    *user-inlining?*
	    *inlining-kfactor*
	    *inlining-reduce-kfactor*
	    *optim*
	    *optim-stack?*
	    *optim-unroll-loop?*
	    *optim-loop-inlining?*
	    *optim-O-macro?*
	    *optim-cfa-arithmetic?*
	    *optim-dataflow?*
	    *optim-reduce-beta?*
	    *optim-jvm-inlining*
	    *optim-jvm-constructor-inlining*
	    *optim-jvm-peephole*
	    *optim-jvm-branch*
	    *optim-jvm-fasteq*
	    *jvm-purify*
	    *jvm-env*
	    *max-stack-alloc-size*
	    *genericity*
	    *shared-cnst?*
	    ;; -------------------------------------------------------------
	    ;; warning, any change about this variable name must be reported
	    ;; in the no-trace-no-check macro of Llib/error.scm file
 	    *compiler-debug*
	    *compiler-sharing-debug?*
	    ;; -------------------------------------------------------------
	    *debug-module*
	    *c-debug*
	    *c-debug-option*
	    *jvm-debug*
	    *bdb-debug*
	    *heap-debug*
	    *heap-debug-copt*
	    *bdb-debug-no-line-directives?*
	    *profile-mode*
	    *prof-table-name*
	    *module-shape?*             
	    *key-shape?*
	    *type-shape?*
	    *access-shape?*
	    *location-shape?*
	    *user-shape?*
	    *tmp-dest*         
	    *dest*
	    *shell*
	    *cc*
	    *cflags-optim*
	    *cflags-prof*
	    *stdc*               
	    *cc-options*       
	    *rm-c-files*       
	    *ld-options*
	    *ld-relative*
	    *strip*            
	    *bigloo-lib*
	    *bigloo-lib-base-name*
	    *gc-lib*
	    *static-bigloo?*
	    *double-ld-libs?*
	    *bigloo-user-lib*
	    *additional-bigloo-libraries*
	    *additional-bigloo-zips*
	    *default-lib-dir*
	    *lib-dir*
	    *lib-src-dir*
	    *include-foreign*  
	    *additional-include-foreign*
	    *indent*
	    *access-file*
	    *access-file-default*
	    *access-table*
	    *qualified-type-file*
	    *qualified-type-file-default*
	    *src-files*
	    *o-files*          
	    *c-files*          
	    *with-files*
	    *early-with-modules*
	    *interpreter*      
	    *startup-file*     
	    *call/cc?*
	    *reflection?*
	    *garbage-collector*
	    *pass*
	    *jvm-jar?*
	    *jvm-shell*
	    *jvm-java*
	    *jvm-options*
	    *jvm-classpath*
	    *jvm-jarpath*
	    *module-checksum-object?*
	    *heap-base-name*
	    *heap-name*
	    *heap-jvm-name*
	    *jvm-foreign-class-id*
	    *jvm-foreign-class-name*
	    *additional-heap-name*
	    *additional-heap-names*
	    *extend-entry*
	    *auto-mode*
	    *src-suffix*
	    *c-suffix*
	    *obj-suffix*
	    *mco-suffix*
	    *mco-include-path*
	    *ast-case-sensitive*
	    *user-heap-size*
	    *reader*
	    *target-language*
	    *use-private?*
	    *builtin-allocators*
	    *eval-options*
	    (bigloo-variables-usage ::bool))
   (eval    (export-all)))

;*---------------------------------------------------------------------*/
;*    *bigloo-variables* ...                                           */
;*    -------------------------------------------------------------    */
;*    This variable hold the list of all the Bigloo control            */
;*    variables with there description. This variable is used by       */
;*    the only function `bigloo-variables-usage'.                      */
;*---------------------------------------------------------------------*/
(define *bigloo-variables* '())

;*---------------------------------------------------------------------*/
;*    add-doc-variable! ...                                            */
;*---------------------------------------------------------------------*/
(define (add-doc-variable! id doc)
   (set! *bigloo-variables* (cons (cons id doc) *bigloo-variables*)))

;*---------------------------------------------------------------------*/
;*    doc-define ...                                                   */
;*---------------------------------------------------------------------*/
(define-macro (doc-define var doc val)
   `(begin
       (define ,var ,val)
       (add-doc-variable! ',var ,doc)))
		    
;*---------------------------------------------------------------------*/
;*    bigloo-variables-usage ...                                       */
;*    -------------------------------------------------------------    */
;*    If MANUAL? is true the formatting is done according to manual    */
;*    width constraints.                                               */
;*---------------------------------------------------------------------*/
(define (bigloo-variables-usage manual?)
   (print "   All the Bigloo control variables can be changed from the")
   (print "   interpreter, by the means of the `-eval' option, or using")
   (print "   the module clause `option'. For instance the option")
   (print "   \"-eval '(set! *strip* #t)'\" will set the variable")
   (print "   `*strip*' to the value `#t'.")
   (print "   These variables are:")
   (newline)
   (let loop ((l (reverse *bigloo-variables*)))
      (if (pair? l)
	  (let ((var (car l)))
	     (if manual?
		 (begin
		    (print "   - " (car var) " : ")
		    (print "     " (cdr var))
		    (display "     default: ")
		    (write (eval (car var)))
		    (newline))
		 (begin
		    (display* "   - " (car var) " : " (cdr var) " [")
		    (write (eval (car var)))
		    (print "]")))
	     (loop (cdr l))))))
   
;*---------------------------------------------------------------------*/
;*    Les auteurs et le nom du soft                                    */
;*---------------------------------------------------------------------*/
;; the bigloo version
(doc-define *bigloo-version*
	    "The Bigloo major release number"
	    bgl-configure-release-number)
;; the bigloo name
(doc-define *bigloo-name*
	    "The Bigloo name"
	    (string-append "Bigloo (" *bigloo-version* ")"))
(define *bigloo-cmd-name*   'nothing-yet)
(define *bigloo-args*       'nothing-yet)
(define *rest-args*         '())
(define *bigloo-author*     "Manuel Serrano")
(define *bigloo-email*      "Manuel.Serrano@inria.fr")
(define *bigloo-date*       (bigloo-date))
;; the tmp directory
(doc-define *bigloo-tmp*
	    "The tmp directory name"
	    (let ((Venv (getenv "TMPDIR")))
	       (if (string? Venv)
		   Venv
		   (os-tmp))))
;; Shall we include the license in the C files ?
(doc-define *bigloo-licensing?*
	    "Add the Bigloo license ?"
	    #f)
	    
;*---------------------------------------------------------------------*/
;*    Le bavardage ...                                                 */
;*---------------------------------------------------------------------*/
(doc-define *verbose*
	    "The verbosity level"
	    0)

(doc-define *hello*
	    "Say hello (when verbose)"
	    #t)

;*---------------------------------------------------------------------*/
;*    Les noms des differents fichiers                                 */
;*---------------------------------------------------------------------*/
;; the source files
(doc-define *src-files*
	    "The sources files"
	    '())
(define *tmp-dest*          #f)
;; the target name
(doc-define *dest*
	    "The target name"
	    #f)

;*---------------------------------------------------------------------*/
;*    Le compilateur C et ses options                                  */
;*---------------------------------------------------------------------*/
;; the shell
(doc-define *shell*
	    "The shell to exec C compilations"
	    bgl-configure-shell)
;; the c compiler
(doc-define *cc*
	    "The C compiler"
	    bgl-configure-c-compiler)
;; the c compiler  option
(doc-define *cflags*
	    "The C compiler option"
	    bgl-configure-c-flag)
;; the c compiler optimization option
(doc-define *cflags-optim*
	    "The C compiler optimization option"
	    bgl-configure-c-optim-flag)
;; the c compiler profile option
(doc-define *cflags-prof*
	    "The C compiler profiling option"
	    bgl-configure-c-prof-flag)
;; The C production type
(doc-define *stdc*
	    "Shall we produced ISO C?"
	    #f)
;; the CC option
(doc-define *cc-options*
	    "cc options"
	    bgl-configure-c-flag)
;; shall we remove the C produced file?
(doc-define *rm-c-files*
	    "Shall we remove the C produced file?"
	    #t)
;; ld options
(doc-define *ld-options*
	    "ld options"
	    "")
;; library link mode
(doc-define *ld-relative*
	    "Relative or absolute path names for libraries"
	    #f)
;; strip ?
(doc-define *strip*
	    "Shall we strip the executable?"
	    #t)
;; the default lib dir path
(doc-define *default-lib-dir*
	    "The default lib dir path (without version)"
	    bgl-configure-library-directory)
;; the lib dir path
(doc-define *lib-dir*
	    "The lib dir path"
	    (let ((lib-env (build-path-from-shell-variable "BIGLOOLIB")))
	       (if (not (pair? lib-env))
		   (list "." *default-lib-dir*)
		   (cons "." lib-env))))
;; the lib source dir path
(doc-define *lib-src-dir*
	    "The lib dir path"
	    (make-file-name (car *lib-dir*) "runtime"))
;; the bigloo library base name
(doc-define *bigloo-lib-base-name*
	    "The Bigloo library base name"
	    bgl-configure-library-base-name)
;; the bigloo library
(doc-define *bigloo-lib*
	    "The Bigloo library"
	    *bigloo-lib-base-name*)
;; the gc library
(doc-define *gc-lib*
	    "The Gc library"
	    "gc")
;; does we use a static version of the bigloo library?
(doc-define *static-bigloo?*
	    "Do we use the static Bigloo library"
	    #f)
;; does we include twice the additional user libraries?
(doc-define *double-ld-libs?*
	    "Do we include twice the additional user libraries"
	    #t)
;; the user C libraries
(doc-define *bigloo-user-lib*
	    "The user extra C libraries"
	    (list bgl-configure-user-libraries))
;; the user Bigloo libraries
(doc-define *additional-bigloo-libraries*
	    "The user extra Bigloo libraries"
	    '())
;; the user Bigloo zip files
(doc-define *additional-bigloo-zips*
	    "The user extra Bigloo Zip files"
	    '())
;; the load path
(set! *load-path* (append *lib-dir* *load-path*))
;; the C include files
(doc-define *include-foreign*
	    "The C included files"
	    (list "bigloo.h"))
;; the additional C include files
(doc-define *additional-include-foreign*
	    "The additional C included files"
	    '())
;; the bigloo heap base name
(doc-define *heap-base-name*
	    "The Bigloo heap base name"
	    "bigloo")
;; the heap name
(doc-define *heap-name*
	    "The Bigloo heap file name"
	    (string-append *heap-base-name* ".heap"))
;; the jvm heap name
(doc-define *heap-jvm-name*
	    "The Bigloo heap file name for the JVM backend"
	    (string-append *heap-base-name* ".jheap"))
;; the jvm foreign class id
(doc-define *jvm-foreign-class-id*
	    "The identifier of the Jlib foreign class"
	    'foreign)
;; the jvm foreign class name
(doc-define *jvm-foreign-class-name*
	    "The name of the Jlib foreign class"
	    "bigloo.foreign")
;; the additional heap name
(doc-define *additional-heap-name*
	    "A name of an additional heap file name to be build"
	    #f)
;; the additional heap names
(doc-define *additional-heap-names*
	    "A list of Bigloo additional heap file name"
	    '())
;; indent
(doc-define *indent*
	    "The name of the C beautifier"
	    bgl-configure-c-beautifier)
;; debugging level
(doc-define *compiler-debug*
	    "Debugging level"
	    0)
(doc-define *compiler-sharing-debug?*
	    "Compiler self sharing debug"
	    #f)
;; debugging level
(doc-define *debug-module*
	    "Module initilazation debugging"
	    0)
;; C debugging mode?
(doc-define *c-debug*
	    "C debugging mode?"
	    #f)
;; C debugging option
(doc-define *c-debug-option*
	    "cc debugging option"
	    "-g")
;; jvm debuggin mode?
(doc-define *jvm-debug*
	    "JVM debugging mode?"
	    #f)
;; The bdb debugging option
(doc-define *bdb-debug*
	    "Bdb debugging mode"
	    0)
;; The heap debugging option
(doc-define *heap-debug*
	    "Heap debugging mode"
	    0)
;; The heap debugging option
(doc-define *heap-debug-copt*
	    "Heap debugging C flags"
	    bgl-configure-heap-debug-copt)
(define *bdb-debug-no-line-directives?* #f)
;; The Bigloo profiling option
(doc-define *profile-mode*
	    "Bigloo profile mode"
	    0)
;; The Bigloo profiling translation table name
(doc-define *prof-table-name*
	    "Bprof translation table file name"
	    "bmon.out")

;*---------------------------------------------------------------------*/
;*    Access and qualifed-type                                         */
;*---------------------------------------------------------------------*/
(doc-define *access-file*
	    "The access file name"
	    #f)
(doc-define *access-file-default*
	    "The default access file name"
	    ".afile")
(define *access-table* '())

(doc-define *qualified-type-file*
	    "The qualifed-type association file name"
	    #f)
(doc-define *qualified-type-file-default*
	    "The qualifed-type association file name"
	    ".jfile")

;*---------------------------------------------------------------------*/
;*    Link files                                                       */
;*---------------------------------------------------------------------*/
(doc-define *o-files*
	    "The additional obect files"
	    '())
(doc-define *c-files*
	    "The C source files"
	    '())
(doc-define *with-files*
	    "The additional modules"
	    '())
(define *early-with-modules* '())
   
;*---------------------------------------------------------------------*/
;*    Des variables de controle sur `comment on doit compiler'         */
;*---------------------------------------------------------------------*/
(doc-define *interpreter*
	    "Shall we interprete the source file?"
	    #f)
(doc-define *startup-file*
	    "A startup file for the interpreter"
	    #f)
(doc-define *call/cc?*
	    "Shall we enabled call/cc?"
	    #f)
(doc-define *reflection?*
	    "Shall we produce refection code for classes"
	    #t)
(doc-define *pass*
	    "Stop after the pass"
	    'ld)
(doc-define *jvm-jar?*
	    "Enable/disable a JAR file production for the JVM back-end"
	    #f)
(doc-define *jvm-shell*
	    "Shell to be used when producing JVM run scripts"
	    bgl-configure-java-shell)
(doc-define *jvm-java*
	    "JVM to be used to run Java programs"
	    bgl-configure-java)
(doc-define *jvm-options*
	    "JVM options"
	    "")
(doc-define *jvm-classpath*
	    "JVM classpath"
	    #f)
(doc-define *jvm-jarpath*
	    "JVM jarpath"
	    #f)
(doc-define *module-checksum-object?*
	    "Produce a module checksum object (.mco)"
	    #f)
(doc-define *garbage-collector*
	    "The garbage collector"
	    'boehm)

;*---------------------------------------------------------------------*/
;*    Les modes de compilations                                        */
;*---------------------------------------------------------------------*/
(doc-define *unsafe-type*
	    "Runtime type safety"
	    #f)
(doc-define *unsafe-arity*
	    "Runtime type arity safety"
	    #f)
(doc-define *unsafe-range*
	    "Runtime range safety"
	    #f)
(doc-define *unsafe-struct*
	    "Runtime struct range safety"
	    #f)
(doc-define *unsafe-version*
            "Module version safety"
	    #f)
(doc-define *unsafe-library*
	    "Use the unsafe library version"
	    #f)
(doc-define *warning-overriden-slots*
	    "Set to #t to warn about virtual slot overriding"
	    #t)
(doc-define *profile-library*
	    "Use the profiled library version"
	    #f)
(define *module-shape?*             #f)
(define *key-shape?*                #f)
(define *type-shape?*               #f)
(define *access-shape?*             #f)
(define *location-shape?*           #f)
(define *user-shape?*               #f)
(doc-define *max-stack-alloc-size*
	    "Maximum size of stack allocated objects"
	    #f)
(define *genericity*                #t)
(doc-define *shared-cnst?*
	    "Shared constant compilation?"
	    #t)
(doc-define *lib-mode*
	    "Lib-mode compilation?"
	    #f)
(doc-define *init-mode*
	    "Module initialization mode"
	    'read)
(doc-define *dlopen-init*
	    "Emit a standard Bigloo dynamic loading init entry point"
	    #f)
(doc-define *max-c-token-length*
	    "Max c token length"
	    1024)
(doc-define *max-c-foreign-arity*
	    "Max C function arity"
	    16)
(doc-define *trace-name*
	    "Trace file name"
	    "trace")
(doc-define *trace-write-length*
	    "Trace dumping max level"
	    80)
(define *additional-traces*         '())

;*---------------------------------------------------------------------*/
;*    Optimizations                                                    */
;*---------------------------------------------------------------------*/
(doc-define *optim*
	    "Optimization level"
	    0)
(doc-define *optim-stack?*
	    "Stack allocation optimization"
	    #unspecified)
(doc-define *optim-unroll-loop?*
	    "Loop unrolling optimization"
	    #unspecified)
(doc-define *optim-loop-inlining?*
	    "Loop inlining optimization"
	    #t)
(doc-define *optim-O-macro?*
	    "Enable optimization by macro-expansion"
	    #f)
(doc-define *optim-jvm-inlining*
	    "Enable JVM inlining"
	    0)
(doc-define *optim-jvm-constructor-inlining*
	    "Enable JVM inlining for constructors"
	    0)
(doc-define *optim-jvm-peephole*
	    "Enable JVM peephole optimization"
	    0)
(doc-define *optim-jvm-branch*
	    "Enable JVM branch tensioning"
	    0)
(doc-define *optim-jvm-fasteq*
	    "EQ? no longer works on integers (use =FX instead)"
	    #f)
(doc-define *jvm-purify*
	    "Produce byte code verifier compliant JVM code"
	    #f)
(doc-define *jvm-env*
	    "List of environment variables to be available in the compiled code"
	    '())
(doc-define *optim-jvm*
	    "Enable optimization by inlining jvm code"
	    0)
(doc-define *optim-cfa-arithmetic?*
	    "Enable refined arithmetic specialization"
	    #f)
(doc-define *optim-dataflow?*
	    "Enable simple dataflow optimization"
	    #f)
(doc-define *optim-reduce-beta?*
	    "Enable simple beta reduction"
	    #f)
(doc-define *inlining?*
	    "Inlining optimization"
	    #t)
(doc-define *user-inlining?*
	    "User inlining optimization"
	    #t)
(doc-define *inlining-kfactor*
	    "Inlining growth factor"
	    (lambda (olevel) (*fx 2 olevel)))
(doc-define *inlining-reduce-kfactor*
	    "Inlinine growth factor reductor"
	    (lambda (kfactor) (/fx kfactor 2)))

;*---------------------------------------------------------------------*/
;*    *extend-entry* ...                                               */
;*---------------------------------------------------------------------*/
(doc-define *extend-entry*
	    "Extend entry"
	    #f)

;*---------------------------------------------------------------------*/
;*    *src-suffix* ...                                                 */
;*    -------------------------------------------------------------    */
;*    The list of suffix recognized by the compiler and the linker.    */
;*---------------------------------------------------------------------*/
(doc-define *src-suffix*
	    "Scheme legal suffixes"
	    '("scm" "bgl"))

;*---------------------------------------------------------------------*/
;*    *c-suffix* ...                                                   */
;*    -------------------------------------------------------------    */
;*    The list of C suffix recognized by the compiler and the linker.  */
;*---------------------------------------------------------------------*/
(doc-define *c-suffix*
	    "C legal suffixes"
	    '("c"))

;*---------------------------------------------------------------------*/
;*    *obj-suffix* ...                                                 */
;*    -------------------------------------------------------------    */
;*    The suffix list of the object file                               */
;*---------------------------------------------------------------------*/
(doc-define *obj-suffix*
	    "Object legal suffixes"
	    '("o"))

;*---------------------------------------------------------------------*/
;*    *mco-suffix*                                                     */
;*    -------------------------------------------------------------    */
;*    The suffix list of the module checksum object files.             */
;*---------------------------------------------------------------------*/
(doc-define *mco-suffix*
	    "Module checksum object legal suffixes"
	    '("mco"))

;*---------------------------------------------------------------------*/
;*    *mco-include-path* ...                                           */
;*---------------------------------------------------------------------*/
(doc-define *mco-include-path*
	    "Module checksum C include path"
	    '("."))

;*---------------------------------------------------------------------*/
;*    Les auto-modes (comme en emacs)                                  */
;*---------------------------------------------------------------------*/
(doc-define *auto-mode*
	    "auto-mode (extend mode) list"
	    '(("ml"  . "caml")
	      ("mli" . "caml")
	      ("oon" . "meroon")))

;*---------------------------------------------------------------------*/
;*    *ast-case-sensitive* ...                                         */
;*---------------------------------------------------------------------*/
(doc-define *ast-case-sensitive*
	    "Case sensitivity"
	    #t)

;*---------------------------------------------------------------------*/
;*    *user-heap-size*                                                 */
;*---------------------------------------------------------------------*/
(doc-define *user-heap-size*
	    "Heap size (in MegaByte) or #f for default value"
	    #f)

;*---------------------------------------------------------------------*/
;*    *reader* ...                                                     */
;*---------------------------------------------------------------------*/
(doc-define *reader*
	    "The way the reader reads input file ('plain or 'intern)"
	    'plain)

;*---------------------------------------------------------------------*/
;*    *target-language* ...                                            */
;*---------------------------------------------------------------------*/
(doc-define *target-language*
	    "The target language (either C or JVM)"
	    (string->symbol bgl-configure-default-back-end))

;*---------------------------------------------------------------------*/
;*    *use-private?* ...                                               */
;*---------------------------------------------------------------------*/
(doc-define *use-private?*
	    "Use private construction instead of pragma"
	    #f)

;*---------------------------------------------------------------------*/
;*    *builtin-allocators* ...                                         */
;*    -------------------------------------------------------------    */
;*    The builtin allocators (used only for Kprof).                    */
;*---------------------------------------------------------------------*/
(define *builtin-allocators*
   '(("CONS" . "make_pair")
     ("%STRING->SYMBOL" . "make_symbol")
     ("%MAKE-STRING" . "string_to_bstring_len")
     ("%MAKE-OUTPUT-PORT" . "make_output_port")
     ("%MAKE-INPUT-PORT" . "make_input_port")
     ("%MAKE-ERROR-PORT" . "make_error_port")))

;*---------------------------------------------------------------------*/
;*    *eval-options* ...                                               */
;*---------------------------------------------------------------------*/
(doc-define *eval-options*
	    "A user variable to store dynamic command line options"
	    '())

;*---------------------------------------------------------------------*/
;*    Other variables that are defined inside the interpreter...       */
;*---------------------------------------------------------------------*/
(add-doc-variable! '*load-path* "The load path")
(add-doc-variable! '*user-pass* "The user specific compilation pass")
(add-doc-variable! '*debug*     "The debugging level")
(add-doc-variable! '*warning*   "The warning level")
(add-doc-variable! '*hygien?*   "Hygienic r5rs macro expansion activation")
