;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bmacs/ude/ude-toolbar.el             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Nov 11 09:18:10 1998                          */
;*    Last change :  Tue May 16 11:32:16 2000 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Command Ude Toolbar handling functions and variables.            */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(provide 'ude-toolbar)
(require 'ude-icon)

;*---------------------------------------------------------------------*/
;*    The close button                                                 */
;*---------------------------------------------------------------------*/
(defvar ude-close-toolbar-button
  (toolbar-make-button-list ude-close-toolbar-icon))

;*---------------------------------------------------------------------*/
;*    The open button                                                  */
;*---------------------------------------------------------------------*/
(defvar ude-open-toolbar-button
  (toolbar-make-button-list ude-open-toolbar-icon))

;*---------------------------------------------------------------------*/
;*    ude-toolbar-height ...                                           */
;*---------------------------------------------------------------------*/
(defun ude-toolbar-height (toolbar)
  (let ((button (aref (car toolbar) 0)))
    (if (toolbar-button-p button)
	(+ 8 (glyph-height (car button)))
      (+ 8 (glyph-height (car (eval button)))))))

;*---------------------------------------------------------------------*/
;*    ude-open-close-toolbar ...                                       */
;*---------------------------------------------------------------------*/
(defun ude-open-close-toolbar (toolbar)
  (let ((old-height (specifier-instance default-toolbar-height))
	(new-height (ude-toolbar-height toolbar)))
    (set-specifier default-toolbar toolbar (current-buffer))
    ;; This following set-spectified should be apply to (current-buffer).
    ;; Unfortunately this does not work with xemacs 20.4
    (if (and (string-match "XEmacs" emacs-version)
             (= emacs-major-version 20)
             (= emacs-minor-version 4))
        (set-specifier default-toolbar-height new-height)
      (set-specifier default-toolbar-height new-height (current-buffer)))))


