;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/R5rs/misc5.scm               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Mar 21 17:20:38 1998                          */
;*    Last change :  Mon May  7 18:38:16 2001 (serrano)                */
;*    -------------------------------------------------------------    */
;*  Copyright 1992 William Clinger                                     */
;*                                                                     */
;*  Permission to copy this software, in whole or in part, to use this */
;*  software for any lawful purpose, and to redistribute this software */
;*  is granted subject to the restriction that all copies made of this */
;*  software must include this copyright notice in full.               */
;*                                                                     */
;*  I also request that you send me a copy of any improvements that you*/
;*  make to this software so that they may be incorporated within it to*/
;*  the benefit of the Scheme community.                               */
;*                                                                     */
;* Miscellaneous routines.                                             */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __r5_syntax_misc
   
   (use    __type
           __error
           __bigloo
           __tvector
           __structure
           __tvector
           __bexit
            
           __r4_numbers_6_5
           __r4_numbers_6_5_fixnum
           __r4_numbers_6_5_flonum
           __r4_characters_6_6
           __r4_equivalence_6_2
           __r4_booleans_6_1
           __r4_symbols_6_4
           __r4_strings_6_7
           __r4_pairs_and_lists_6_3
           __r4_input_6_10_2
           __r4_control_features_6_9
           __r4_vectors_6_8
           __r4_ports_6_10_1
           __r4_output_6_10_3
   
	   __r5_syntax_expand)

   (export (m-warn msg . more)
	   (m-error msg . more)
	   (m-bug msg . more)
	   (make-null-terminated x)
	   (safe-length x)
	   (filter1 p x)
	   (every1? p x)
	   (union2 x y)
	   (copy-alist alist)))

(define (m-warn msg . more)
   (apply warning (cons msg (cons " -- " more))))

(define (m-error msg . more)
   (error "expand-syntax" msg more)
   (m-quit #f))

(define (m-bug msg . more)
   (error "expand-syntax: internal-error" msg more)
   (m-quit #f))

; Given a <formals>, returns a list of bound variables.

(define (make-null-terminated x)
  (cond ((null? x) '())
        ((pair? x)
         (cons (car x) (make-null-terminated (cdr x))))
        (else (list x))))

; Returns the length of the given list, or -1 if the argument
; is not a list.  Does not check for circular lists.

(define (safe-length x)
  (define (loop x n)
    (cond ((null? x) n)
          ((pair? x) (loop (cdr x) (+ n 1)))
          (else -1)))
  (loop x 0))

; Given a unary predicate and a list, returns a list of those
; elements for which the predicate is true.

(define (filter1 p x)
  (cond ((null? x) '())
        ((p (car x)) (cons (car x) (filter1 p (cdr x))))
        (else (filter1 p (cdr x)))))

; Given a unary predicate and a list, returns #t if the
; predicate is true of every element of the list.

(define (every1? p x)
  (cond ((null? x) #t)
        ((p (car x)) (every1? p (cdr x)))
        (else #f)))

; Binary union of two sets represented as lists, using equal?.

(define (union2 x y)
  (cond ((null? x) y)
        ((member (car x) y)
         (union2 (cdr x) y))
        (else (union2 (cdr x) (cons (car x) y)))))

; Given an association list, copies the association pairs.

(define (copy-alist alist)
  (map (lambda (x) (cons (car x) (cdr x)))
       alist))
