;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Eval/expand.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Nov  3 09:57:39 1994                          */
;*    Last change :  Mon May  7 18:45:05 2001 (serrano)                */
;*    -------------------------------------------------------------    */
;*    La macro expansion de l'interprete                               */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __expand
   
   (import  __type
	    __error
	    __bigloo
	    __tvector
	    __structure
	    __tvector
	    __bexit
	    __os
	    
	    __r4_numbers_6_5
	    __r4_numbers_6_5_fixnum
	    __r4_numbers_6_5_flonum
	    __r4_characters_6_6
	    __r4_equivalence_6_2
	    __r4_booleans_6_1
	    __r4_symbols_6_4
	    __r4_strings_6_7
	    __r4_pairs_and_lists_6_3
	    __r4_input_6_10_2
	    __r4_control_features_6_9
	    __r4_vectors_6_8
	    __r4_ports_6_10_1
	    __r4_output_6_10_3

	    __evenv
	    __macro)

   (export  (expand             <expression>)
	    (expand-once        <expression>)
	    (parse-formal-ident <expression>)))

;*---------------------------------------------------------------------*/
;*    expand ...                                                       */
;*---------------------------------------------------------------------*/
(define (expand x)
   (initial-expander x initial-expander))

;*---------------------------------------------------------------------*/
;*    expand-once ...                                                  */
;*---------------------------------------------------------------------*/
(define (expand-once x)
   (initial-expander x (lambda (x e) x)))

;*---------------------------------------------------------------------*/
;*    initial-expander ...                                             */
;*---------------------------------------------------------------------*/
(define (initial-expander x e)
   (let ((e1 (cond
		((symbol? x)
		 *identifier-eval-expander*)
		((not (pair? x))
		 (lambda (x e) x))
		((symbol? (car x))
		 (let ((id (car (parse-formal-ident (car x)))))
		    (let ((b (get-eval-expander id)))
		       (if b
			   b
			   *application-eval-expander*))))
		(else
		 *application-eval-expander*))))
      (let ((new (e1 x e)))
	 (if (and (pair? new)
		  (not (epair? new))
		  (epair? x))
	     (econs (car new) (cdr new) (cer x))
	     new))))

;*---------------------------------------------------------------------*/
;*    *identifier-eval-expander* ...                                   */
;*---------------------------------------------------------------------*/
(define (*identifier-eval-expander* x e)
   x)

;*---------------------------------------------------------------------*/
;*    *application-eval-expander* ...                                  */
;*---------------------------------------------------------------------*/
(define (*application-eval-expander* x e)
   (let loop ((x x))
      (cond
	 ((null? x)
	  '())
	 ((not (pair? x))
	  (error "application" "Illegal form" x))
	 (else
	  (cons (e (car x) e) (loop (cdr x)))))))

;*---------------------------------------------------------------------*/
;*    parse-formal-ident ...                                           */
;*---------------------------------------------------------------------*/
(define (parse-formal-ident ident)
   (cond
      ((or (eq? ident #!optional)
	   (eq? ident #!rest)
	   (eq? ident #!key))
       (cons (gensym 'dsssl) '()))
      ((and (pair? ident) (symbol? (car ident)))
       (cons ident '()))
      ((not (symbol? ident))
       (error #f "Illegal formal identifier" ident))
      (else
       (let* ((string (symbol->string ident))
	      (len    (string-length string)))
	  (let loop ((walker     0)
		     (id-stop    0)
		     (type-start 0))
	     (cond
		((=fx walker len)
		 (cond
		    ((and (=fx id-stop 0)
			  (>fx type-start 0))
		     ;; this empty name variable can be usefull to declare
		     ;; prototype so it is legal.
		     (cons (string->symbol "")
			   (string->symbol (substring string type-start len))))
		    ((=fx id-stop 0)
		     (cons ident '()))
		    ((=fx type-start len)
		     ;; empty type are eroneous
		     (error #f "Illegal formal identifier" ident))
		    (else
		     (cons (string->symbol
			    (substring string 0 id-stop))
			   (string->symbol
			    (substring string type-start len))))))
		((and (char=? (string-ref string walker) #\:)
		      (<fx walker (-fx len 1))
		      (char=? (string-ref string (+fx walker 1)) #\:))
		 (if (>fx type-start 0)
		     (error #f "Illegal formal identifier" ident)
		     (loop (+fx walker 2)
			   walker
			   (+fx walker 2))))
		(else
		 (loop (+fx walker 1)
		       id-stop
		       type-start))))))))
