;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Module/eval.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jun  4 16:28:03 1996                          */
;*    Last change :  Mon Sep 24 06:16:48 2001 (serrano)                */
;*    Copyright   :  1996-2001 Manuel Serrano, see LICENSE file        */
;*    -------------------------------------------------------------    */
;*    The eval clauses compilation.                                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module module_eval
   (include "Ast/unit.sch"
	    "Ast/node.sch")
   (import  module_module
	    module_include
	    engine_param
	    tools_shape
	    tools_error
	    tools_location
	    type_cache
	    ast_env
	    ast_glo-decl
	    ast_sexp)
   (export  (make-eval-compiler)
	    *all-eval?*
	    *all-export-eval?*
	    *all-module-eval?*))

;*---------------------------------------------------------------------*/
;*    make-eval-compiler ...                                           */
;*---------------------------------------------------------------------*/
(define (make-eval-compiler)
   (instantiate::ccomp (id 'eval)
		       (producer eval-producer)
		       (finalizer eval-finalizer)))

;*---------------------------------------------------------------------*/
;*    eval-producer ...                                                */
;*---------------------------------------------------------------------*/
(define (eval-producer clause)
   (match-case clause
      ((?- . ?protos)
       (for-each (lambda (proto) (eval-parser proto clause)) protos)
       '())
      (else
       (user-error "Parse error"
		   (string-append "Illegal `eval' clause")
		   clause
		   '()))))
   
;*---------------------------------------------------------------------*/
;*    eval-parser ...                                                  */
;*---------------------------------------------------------------------*/
(define (eval-parser proto clause)
   (match-case proto
      ((export-all)
       (set! *all-eval?* #t))
      ((export-exports)
       (set! *all-export-eval?* #t))
      ((export-module)
       (set! *all-module-eval?* #t))
      ((export (and (? symbol?) ?var))
       (set! *one-eval?* #t)
       (remember-eval-exported! var *module* proto))
      ((export (@ (and (? symbol?) ?var) (and (? symbol?) ?module)))
       (set! *one-eval?* #t)
       (remember-eval-exported! var module proto))
      ((import (and (? symbol?) ?var))
       (declare-global-svar! var 'eval 'eval clause #f))
      (else
       (user-error "Parse error" "Illegal `eval clause'" clause '()))))

;*---------------------------------------------------------------------*/
;*    *eval-exported* ...                                              */
;*---------------------------------------------------------------------*/
(define *eval-exported* '())

;*---------------------------------------------------------------------*/
;*    remember-eval-exported! ...                                      */
;*---------------------------------------------------------------------*/
(define (remember-eval-exported! var::symbol module::symbol loc)
   (set! *eval-exported* (cons (list var module loc) *eval-exported*)))

;*---------------------------------------------------------------------*/
;*    *all-eval?* ...                                                  */
;*---------------------------------------------------------------------*/
(define *all-eval?* #f)
(define *all-export-eval?* #f)
(define *all-module-eval?* #f)

;*---------------------------------------------------------------------*/
;*    *one-eval?* ...                                                  */
;*---------------------------------------------------------------------*/
(define *one-eval?* #f)

;*---------------------------------------------------------------------*/
;*    eval-finalizer ...                                               */
;*---------------------------------------------------------------------*/
(define (eval-finalizer)
   (if (or *one-eval?* *all-eval?* *all-export-eval?* *all-module-eval?*)
       (list
	(unit
	 'eval
	 (-fx (get-toplevel-unit-weight) 2)
	 (delay
	    (let loop ((globals (get-evaluated-globals))
		       (init*  '(#unspecified)))
	       (if (null? globals)
		   `(begin ,@(reverse! init*))
		   (let ((g (car globals)))
		      (set-eval-types! g)
		      (loop (cdr globals)
			    (cons (cond
				     ((svar? (global-value g))
				      (variable-access-set! g 'write)
				      (define-primop-ref->node g
					 (location->node g)))
				     ((scnst? (global-value g))
				      (define-primop-ref->node g
					 (location->node g)))
				     (else
				      (define-primop->node g)))
				  init*))))))
	 #f))
       'void))

;*---------------------------------------------------------------------*/
;*    set-eval-types! ...                                              */
;*    -------------------------------------------------------------    */
;*    Global variables send to eval must be obj variable. This         */
;*    function enforce that.                                           */
;*---------------------------------------------------------------------*/
(define (set-eval-types! global)
   (let ((val (global-value global)))
      (if (not (sfun? val))
	  (let ((type (global-type global)))
	     (cond
		((eq? type *_*)
		 (global-type-set! global *obj*))
		((not (bigloo-type? type))
		 (error "eval"
			"Non bigloo prototyped value can't be evaluated"
			(global-id global))))))))
   
;*---------------------------------------------------------------------*/
;*    get-evaluated-globals ...                                        */
;*---------------------------------------------------------------------*/
(define (get-evaluated-globals)   
   (if (or *all-eval?* *all-export-eval?* *all-module-eval?*)
       (let ((globals '())
	     (scope-lst (cond
			   (*all-eval?* '(import static export))
			   (*all-module-eval?* '(static export))
			   (else '(export)))))
	  (for-each-global!
	   (lambda (g)
	      (if (and (memq (global-import g) scope-lst)
		       (global-evaluable? g)
		       (or *lib-mode* (not (global-library? g))))
		  (set! globals (cons g globals)))))
	  globals)
       (let loop ((eval-exported *eval-exported*)
		  (res           '()))
	  (if (null? eval-exported)
	      res
	      (let ((var.module.pos (car eval-exported)))
		 (let ((g (find-global/module (car var.module.pos)
					      (cadr var.module.pos))))
		    (cond
		       ((not (global? g))
			(user-error/location (find-location
					      (caddr var.module.pos))
					     "eval-init"
					     "Unbound eval variable"
					     (car var.module.pos)
					     '())
			(loop (cdr eval-exported) res))
		       ((and (not *lib-mode*) (global-library? g))
			(loop (cdr eval-exported) res))
		       ((not (global-evaluable? g))
			(user-error/location (find-location
					      (caddr var.module.pos))
					     "eval-init"
					     "This variable cannot be known by eval"
					     (car var.module.pos)
					     '())
			(loop (cdr eval-exported) res))
		       (else
			(loop (cdr eval-exported) (cons g res))))))))))

