;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Expand/iarith.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Aug 26 09:16:56 1994                          */
;*    Last change :  Mon Jul  2 06:01:11 2001 (serrano)                */
;*    Copyright   :  1994-2001 Manuel Serrano, see LICENSE file        */
;*    -------------------------------------------------------------    */
;*    Les expandeurs arithmetiques (entiers)                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module expand_iarithmetique
   (export (expand-eq? ::obj ::procedure)
	   (expand-i+  ::obj ::procedure)
	   (expand-i-  ::obj ::procedure)
	   (expand-i*  ::obj ::procedure)
	   (expand-i/  ::obj ::procedure)
	   (expand-i=  ::obj ::procedure)
	   (expand-i<  ::obj ::procedure)
	   (expand-i>  ::obj ::procedure)
	   (expand-i<= ::obj ::procedure)
	   (expand-i>= ::obj ::procedure)
	   (expand-+fx ::obj ::procedure)
	   (expand--fx ::obj ::procedure)))

;*---------------------------------------------------------------------*/
;*    expand-i+ ...                                                    */
;*---------------------------------------------------------------------*/
(define (expand-i+ x e)
   (match-case x
      ((?-)
       0)
      ((?- . (?x . ()))
       (e x e))
      ((?- ?x . (?y . ()))
       (cond
	  ((and (integer? x)
		(integer? y))
	   (+fx x y))
	  (else
	   (e `(+fx ,x ,y) e))))
      ((?- ?x . ?y)
       (e `(+fx ,x (+ ,@y)) e)))) 
      
;*---------------------------------------------------------------------*/
;*    expand-i- ...                                                    */
;*---------------------------------------------------------------------*/
(define (expand-i- x e)
   (match-case x
      ((?- . (?x . ()))
       (cond
	  ((integer? x)
	   (negfx x))
	  (else
	   `(negfx ,(e x e)))))
      ((?- ?x . (?y . ()))
       (cond
	  ((and (integer? x)
		(integer? y))
	   (-fx x y))
	  (else
	   (e `(-fx ,x ,y) e))))
      ((?- ?x . ?y)
       (e `(-fx ,x (+ ,@y)) e)))) 
      
;*---------------------------------------------------------------------*/
;*    expand-i* ...                                                    */
;*---------------------------------------------------------------------*/
(define (expand-i* x e)
   (match-case x
      ((?-)
       1)
      ((?- . (?x . ()))
       (e x e))
      ((?- ?x . (?y . ()))
       (cond
	  ((and (integer? x)
		(integer? y))
	   (*fx x y))
	  (else
	   (e `(*fx ,x ,y) e))))
      ((?- ?x . ?y)
       (e `(*fx ,x (* ,@y)) e)))) 
       
;*---------------------------------------------------------------------*/
;*    expand-i/ ...                                                    */
;*---------------------------------------------------------------------*/
(define (expand-i/ x e)
   (match-case x
      ((?- . (?x . ()))
       `(/fx 1 ,(e x e)))
      ((?- ?x . (?y . ()))
       (cond
	  ((and (integer? x)
		(integer? y))
	   (/fx x y))
	  (else
	   (e `(/fx ,x ,y) e))))
      ((?- ?x . ?y)
       (e `(/fx ,x (* ,@y)) e)))) 
      
;*---------------------------------------------------------------------*/
;*    expand-i= ...                                                    */
;*---------------------------------------------------------------------*/
(define (expand-i= x e)
   (match-case x
      ((?- ?x . (?y . ()))
       (cond
	  ((and (integer? x) (integer? y))
	   (=fx x y))
	  (else
	   (e `(=fx ,x ,y) e))))
      ((?- ?x . ?y)
       (e `(and (=fx ,x ,(car y)) (= ,@y)) e))))

;*---------------------------------------------------------------------*/
;*    expand-i< ...                                                    */
;*---------------------------------------------------------------------*/
(define (expand-i< x e)
   (match-case x
      ((?- ?x . (?y . ()))
       (cond
	  ((and (integer? x) (integer? y))
	   (<fx x y))
	  (else
	   (e `(<fx ,x ,y) e))))
      ((?- ?x . ?y)
       (e `(and (<fx ,x ,(car y)) (< ,@y)) e))))

;*---------------------------------------------------------------------*/
;*    expand-i> ...                                                    */
;*---------------------------------------------------------------------*/
(define (expand-i> x e)
   (match-case x
      ((?- ?x . (?y . ()))
       (cond
	  ((and (integer? x) (integer? y))
	   (>fx x y))
	  (else
	   (e `(>fx ,x ,y) e))))
      ((?- ?x . ?y)
       (e `(and (>fx ,x ,(car y)) (> ,@y)) e))))
     
;*---------------------------------------------------------------------*/
;*    expand-i<= ...                                                   */
;*---------------------------------------------------------------------*/
(define (expand-i<= x e)
   (match-case x
      ((?- ?x . (?y . ()))
       (cond
	  ((and (integer? x) (integer? y))
	   (<=fx x y))
	  (else
	   (e `(<=fx ,x ,y) e))))
      ((?- ?x . ?y)
       (e `(and (<=fx ,x ,(car y)) (<= ,@y)) e))))
      
;*---------------------------------------------------------------------*/
;*    expand-i>= ...                                                   */
;*---------------------------------------------------------------------*/
(define (expand-i>= x e)
   (match-case x
      ((?- ?x . (?y . ()))
       (cond
	  ((and (integer? x) (integer? y))
	   (>=fx x y))
	  (else
	   (e `(>=fx ,x ,y) e))))
      ((?- ?x . ?y)
       (e `(and (>=fx ,x ,(car y)) (>= ,@y)) e))))

;*---------------------------------------------------------------------*/
;*    expand-eq? ...                                                   */
;*---------------------------------------------------------------------*/
(define (expand-eq? x e)
   (match-case x
      ((?- ?x . (?y . ()))
       `(c-eq? ,(e x e) ,(e y e)))
      (else
       (error #f "Incorrect number of arguments for `eq?'" x))))

;*---------------------------------------------------------------------*/
;*    expand-+fx ...                                                   */
;*---------------------------------------------------------------------*/
(define (expand-+fx x e)
   (match-case x
      ((?- ?x . (?y . ()))
       (cond
	  ((and (integer? x) (integer? y))
	   (+fx x y))
	  (else
	   `(+fx ,(e x e) ,(e y e)))))
      (else
       (error #f "Incorrect number of arguments for `+fx'" x))))

;*---------------------------------------------------------------------*/
;*    expand--+fx ...                                                  */
;*---------------------------------------------------------------------*/
(define (expand--fx x e)
   (match-case x
      ((?- ?x . (?y . ()))
       (cond
	  ((and (integer? x) (integer? y))
	   (-fx x y))
	  (else
	   `(-fx ,(e x e) ,(e y e)))))
      (else
       (error #f "Incorrect number of arguments for `-fx'" x))))
