;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bmacs/ude/ude-balloon.el             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Aug  6 16:00:36 1998                          */
;*    Last change :  Tue Apr  6 09:25:03 1999 (serrano)                */
;*    -------------------------------------------------------------    */
;*    My self brewed balloon implementation. This implementation is    */
;*    much less ambition than the official balloon but it is less      */
;*    instrusive because much less resource consuming...               */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(provide 'ude-balloon)
(require 'ude-config)

;*---------------------------------------------------------------------*/
;*    ude-balloon-timeout-id ...                                       */
;*---------------------------------------------------------------------*/
(defvar ude-balloon-timeout-id nil)

;*---------------------------------------------------------------------*/
;*    ude-balloon-started-p ...                                        */
;*    -------------------------------------------------------------    */
;*    A buffer local variable that tells if balloon is already all     */
;*    set on the requesting buffer.                                    */
;*---------------------------------------------------------------------*/
(defvar ude-balloon-started-p nil)
(make-variable-buffer-local 'ude-balloon-started-p)

;*---------------------------------------------------------------------*/
;*    ude-balloon-start ...                                            */
;*---------------------------------------------------------------------*/
(defun ude-balloon-start ()
  (if (not ude-balloon-started-p)
      (progn
	(setq ude-balloon-started-p t)
	(add-hook 'mode-motion-hook 'ude-balloon-mouse-motion-hook)
	(setq ude-balloon-timeout-id
	      (add-timeout (/ (float ude-balloon-timeout) 1000.0)
			   'ude-balloon-timeout
			   '() 
			   (/ (float ude-balloon-timeout) 1000.0))))))

;*---------------------------------------------------------------------*/
;*    ude-balloon-stop ...                                             */
;*---------------------------------------------------------------------*/
(defun ude-balloon-stop ()
  (remove-hook 'mouse-motion-handler 'ude-balloon-mouse-motion-hook)
  (if (numberp ude-balloon-timeout-id)
      (disable-timeout ude-balloon-timeout-id)))

;*---------------------------------------------------------------------*/
;*    ude-balloon-actions ...                                          */
;*---------------------------------------------------------------------*/
(defvar ude-balloon-actions '())

;*---------------------------------------------------------------------*/
;*    ude-add-balloon-action ...                                       */
;*---------------------------------------------------------------------*/
(defun ude-add-balloon-action (label pred action)
  (setq ude-balloon-actions (cons (cons label (cons pred action))
				  ude-balloon-actions)))

;*---------------------------------------------------------------------*/
;*    ude-remove-balloon-action ...                                    */
;*---------------------------------------------------------------------*/
(defun ude-remove-balloon-action (label)
  (let ((cell (assq label ude-balloon-actions)))
    (if (consp cell)
	(setq ude-balloon-actions (delq cell ude-balloon-actions)))
    (if (null ude-balloon-actions)
	(ude-balloon-stop))))

;*---------------------------------------------------------------------*/
;*    ude-balloon-mouse-point ...                                      */
;*---------------------------------------------------------------------*/
(defvar ude-balloon-mouse-point nil)
(defvar ude-balloon-mouse-buffer nil)
(defvar ude-balloon-old-mouse-point nil)
(defvar ude-balloon-old-mouse-buffer nil)

;*---------------------------------------------------------------------*/
;*    ude-balloon-get-buffer ...                                       */
;*---------------------------------------------------------------------*/
(defun ude-balloon-get-buffer ()
  ude-balloon-mouse-buffer)

;*---------------------------------------------------------------------*/
;*    ude-balloon-get-point ...                                        */
;*---------------------------------------------------------------------*/
(defun ude-balloon-get-point ()
  ude-balloon-mouse-point)

;*---------------------------------------------------------------------*/
;*    ude-balloon-mouse-motion-hook ...                                */
;*---------------------------------------------------------------------*/
(defun ude-balloon-mouse-motion-hook (event)
  (if (and (eventp event) (motion-event-p event))
      (progn
	(setq ude-balloon-mouse-point (event-closest-point event))
	(setq ude-balloon-mouse-buffer (event-buffer event)))))

;*---------------------------------------------------------------------*/
;*    ude-balloon-timeout ...                                          */
;*---------------------------------------------------------------------*/
(defun ude-balloon-timeout (dummy)
  (if (not (and (eq ude-balloon-mouse-point
		    ude-balloon-old-mouse-point)
		(eq ude-balloon-mouse-buffer
		    ude-balloon-old-mouse-buffer)))
      (let ((mouse-pos (mouse-pixel-position)))
	(setq ude-balloon-old-mouse-point ude-balloon-mouse-point)
	(setq ude-balloon-old-mouse-buffer ude-balloon-mouse-buffer)
	(let ((l     ude-balloon-actions)
	      (found nil))
	  (while (and (not found) (consp l))
	    (if (funcall (car (cdr (car l))) mouse-pos)
		(setq found (car l))
	      (setq l (cdr l))))
	  (if found
	      (funcall (cdr (cdr found))))))))

