/** 
 * @namespace   biew
 * @file        refs.c
 * @brief       This file contains basic level routines for resolving references.
 * @version     -
 * @remark      this source file is part of Binary vIEW project (BIEW).
 *              The Binary vIEW (BIEW) is copyright (C) 1995 Nick Kurshev.
 *              All rights reserved. This software is redistributable under the
 *              licence given in the file "Licence.en" ("Licence.ru" in russian
 *              translation) distributed in the BIEW archive.
 * @note        Requires POSIX compatible development system
 *
 * @author      Nick Kurshev
 * @since       1995
 * @note        Development, fixes and improvements
**/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "bmfile.h"
#include "reg_form.h"
#include "bconsole.h"
#include "biewutil.h"
#include "codeguid.h"
#include "biewlib/biewlib.h"
#include "biewlib/pmalloc.h"

/***************************************************************************/
/************************  FOR MZ  *****************************************/
/***************************************************************************/

long __HUGE__ * CurrMZChain = 0;
static unsigned long CurrMZCount;
static char __codelen;

static tCompare __FASTCALL__ compare_ptr(const void __HUGE__ *e1,const void __HUGE__ *e2)
{
  unsigned long v1,v2;
  tCompare ret;
  v1 = *((const unsigned long __HUGE__ *)e1);
  v2 = *((const unsigned long __HUGE__ *)e2);
  if(v1 < v2) ret = -1;
  else
    if(v1 > v2) ret = 1;
    else        ret = 0;
  return ret;
}

static void __NEAR__ __FASTCALL__ BuildMZChain( void )
{
  unsigned i;
  unsigned long fpos;
  TWindow * w,*usd;
  usd = twUsedWin();
  w = CrtDlgWndnls(" System is busy ",49,1);
  twUseWin(w);
  twGotoXY(1,1);
  twPutS(" Building reference chains for MZ part");
  twUseWin(usd);
  CurrMZCount = 0;
  fpos = bmGetCurrFilePos();
  for(i = 0;i < oldh.mz.mzRelocationCount;i++)
  {
    unsigned off,seg,j;
    unsigned long ptr;
    void __HUGE__ * tptr;
    if(!CurrMZChain) tptr = PHMalloc(sizeof(void *));
    else             tptr = PHRealloc(CurrMZChain,(CurrMZCount + 1)*sizeof(void *));
    if(!tptr) break;
    CurrMZChain = tptr;
    j = oldh.mz.mzTableOffset + i*4;
    bmSeek(j,BM_SEEK_SET);
    off = bmReadWord();
    seg = bmReadWord();
    ptr = (((long)seg) << 4) + off + (((long)oldh.mz.mzHeaderSize) << 4);
    CurrMZChain[CurrMZCount++] = ptr;
  }
  HQSort(CurrMZChain,CurrMZCount,sizeof(void *),compare_ptr);
  bmSeek(fpos,BM_SEEK_SET);
  CloseWnd(w);
}

static tCompare __FASTCALL__ compare_mz(const void __HUGE__ *e1,const void __HUGE__ *e2)
{
  long l1,l2;
  tCompare ret;
  l1 = *(const long __HUGE__ *)e1;
  l2 = *(const long __HUGE__ *)e2;
  if(l1 >= l2 && l1 < l2 + __codelen) ret = 0;
  else
    if(l1 < l2) ret = -1;
    else        ret = 1;
  return ret;
}

static tBool __NEAR__ __FASTCALL__ isMZReferenced(unsigned long shift,char len)
{
  if(FType == OLD_EXE && oldh.mz.mzRelocationCount)
  {
     unsigned long mz_size;
     mz_size = (long)(oldh.mz.mzPageCount)*512 + oldh.mz.mzPartLastPage;
     if(shift <= mz_size && shift >= ((unsigned long)oldh.mz.mzHeaderSize) << 4)
     {
       if(!CurrMZChain) BuildMZChain();
       __codelen = len;
       return HLFind(&shift,CurrMZChain,CurrMZCount,sizeof(long),compare_mz) != 0;
     }
  }
  return False;
}

static tBool __NEAR__ __FASTCALL__ AppendMZRef(char *str,unsigned long ulShift,char codelen)
{
  tBool ret = False;
  if(isMZReferenced(ulShift,codelen))
  {
     unsigned wrd;
     wrd = bmReadWordEx(ulShift,BM_SEEK_SET);
     strcat(str,Get4Digit(wrd));
     strcat(str,"+PID");
     ret = True;
  }
  return ret;
}


extern REGISTRY_BIN binTable;
int __FASTCALL__ AppendAsmRef(char *str,unsigned long ulShift,int mode,char codelen,unsigned long r_sh)
{
  static tBool warn_displayed = False;
  int ret = RAPREF_NONE;
  if(detectedFormat->bind) ret = detectedFormat->bind(str,ulShift,mode,codelen,r_sh);
  else
  {
    if(detectedFormat != &binTable && !warn_displayed)
    {
      WarnMessageBox("Sorry! References resolving for this format still not supported",NULL);
      warn_displayed = True;
    }
    if(FType == OLD_EXE) ret = AppendMZRef(str,ulShift,codelen) ? RAPREF_PROCEEDCMT : RAPREF_NONE;
  }
  return ret;
}
