/** 
 * @namespace   biew
 * @file        mz_sys.c
 * @brief       This file contains implementation of MZ and DOS-SYS format file decoder.
 * @version     -
 * @remark      this source file is part of Binary vIEW project (BIEW).
 *              The Binary vIEW (BIEW) is copyright (C) 1995 Nick Kurshev.
 *              All rights reserved. This software is redistributable under the
 *              licence given in the file "Licence.en" ("Licence.ru" in russian
 *              translation) distributed in the BIEW archive.
 * @note        Requires POSIX compatible development system
 *
 * @author      Nick Kurshev
 * @since       1995
 * @note        Development, fixes and improvements
**/
#include <string.h>
#include <stdio.h>

#include "colorset.h"
#include "bmfile.h"
#include "biewutil.h"
#include "bconsole.h"
#include "biewlib/pmalloc.h"
#include "biewlib/kbd_code.h"

static const char * __NEAR__ __FASTCALL__ __QueryAddInfo( unsigned char *memmap )
{
  static char rbuff[41];
  unsigned long idl;
  unsigned short idw,idw0;
  idl = ((unsigned long *)memmap)[0];
  idw0 = ((unsigned short *)memmap)[0];
  idw = ((unsigned short *)memmap)[2];
  if(memcmp(memmap,"RJSX",4) == 0) { ArjARC: return "ARJ self-extracting archive"; }
  else
    if(memcmp(memmap,"LZ09",4) == 0) return "LZEXE 0.90 compressed executable";
    else
      if(memcmp(memmap,"LZ91",4) == 0) return "LZEXE 0.91 compressed executable";
      else
        if(memmap[2] == 0xFB)
        {
           char hi,low;
           hi = (memmap[3] >> 4) & 0x0F;
           low = memmap[3] & 0x0F;
           sprintf(rbuff,"Borland TLINK version: %u.%u",(unsigned)hi,(unsigned)low);
           return rbuff;
        }
        else
          if(memcmp(&memmap[2],"PKLITE",6) == 0)
          {
             char hi, low;
             low = memmap[0];
             hi =  memmap[1] & 0x0F;
             sprintf(rbuff,"PKLITE v%u.%u compressed executable",(unsigned)hi,(unsigned)low);
             return rbuff;
          }
          else
            if(memcmp(&memmap[9],"LHarc's SFX",11) == 0) return "LHarc 1.x self-extracting archive";
            else
              if(memcmp(&memmap[8],"LHa's SFX",9) == 0) return "LHa 2.x self-extracting archive";
              else
                if(idl == 0x018A0001L && idw == 0x1565) return "TopSpeed 3.0 CRUNCH compressed file";
                else
                  if(idl == 0x00020001L && idw == 0x0700) return "PKARCK 3.5 self-extracting-archive";
                  else
                    if(idw0 == 0x000F && memmap[2] == 0xA7) return "BSA (Soviet archiver) selft-extarcting";
                    else
                      if(memcmp(&memmap[4],"SFX by LARC",11) == 0) return "LARC self-extracting archive";
                      else
                        if(memcmp(&memmap[8],"LH's SFX",8) == 0) return "LH self-extracting archive";
                        else
                        {
                          unsigned i;
                          for(i = 0;i < 1000-6;i++)
                          {
                            if(memmap[i] == 'a' && memcmp(&memmap[i+1],"RJsfX",5) == 0)
                            {
                               goto ArjARC;
                            }
                          }
                        }
 return 0;
}

static const char * __NEAR__ __FASTCALL__ QueryAddInfo( void )
{
   unsigned char *memmap;
   memmap = PMalloc(1000);
   if(memmap)
   {
     const char *ret;
     unsigned long fpos;
     fpos = bmGetCurrFilePos();
     bmReadBufferEx(memmap,1000,0x1C,BM_SEEK_SET);
     bmSeek(fpos,BM_SEEK_SET);
     ret = __QueryAddInfo(memmap);
     PFREE(memmap);
     return ret;
   }
   return NULL;
}

unsigned long ShowMZHeader( void )
{
 unsigned keycode;
 TWindow * hwnd;
 unsigned long HeadSize;
 unsigned long newcpos,fpos;
 unsigned long FPageCnt;
 const char * addinfo;
 MZHEADER *mz = &oldh.mz;
 fpos = BMGetCurrFilePos();
 keycode = 16;
 if(FType > OLD_EXE) keycode++;
 addinfo = QueryAddInfo();
 if(addinfo) keycode++;
 hwnd = CrtDlgWndnls(" Old Exe Header ",43,keycode-1);
 HeadSize = ((unsigned long)mz->mzHeaderSize) << 4;
 FPageCnt =  ((long)mz->mzPageCount - 1)*512;
 twUseWin(hwnd);
 twGotoXY(1,1);
 twPrintF("Signature            = 'MZ'\n"
          "Part Last Page       = %hu [ bytes ]\n"
          "Page count           = %hu [ pages ]\n"
          "Relocations count    = %hu\n"
          "Header size          = %hu [ paragraphs ]\n"
          "Minimum memory       = %04hXH [ paragraphs ]\n"
          "Maximum memory       = %04hXH [ paragraphs ]\n"
          "SS : SP              = %04hX:%04hXH\n"
          "Check summ           = %hu\n"
          "CS : IP              = %04hX:%04hXH\n"
          "Table offset         = %04hXH [ bytes ]\n"
          "Overlay Number       = %hu\n"
          ,mz->mzPartLastPage
          ,mz->mzPageCount
          ,mz->mzRelocationCount
          ,mz->mzHeaderSize
          ,mz->mzMinMem
          ,mz->mzMaxMem
          ,mz->mzRelocationSS,mz->mzExeSP
          ,mz->mzCheckSumm
          ,mz->mzRelocationCS,mz->mzExeIP
          ,mz->mzTableOffset
          ,mz->mzOverlayNumber);
 newcpos = HeadSize;
 newcpos += (((unsigned long)mz->mzRelocationCS) << 4) + (unsigned long)mz->mzExeIP;
 twSetColorAttr(dialog_cset.entry);
 twPrintF(">Entry Point         = %08lXH",newcpos); twClrEOL();
 twSetColorAttr(dialog_cset.addinfo);
 twPrintF("\nModule Length        = %lu [ bytes ]",(FPageCnt - HeadSize) + mz->mzPartLastPage);
 twClrEOL();
 twSetColorAttr(dialog_cset.main);
 twPrintF("\nImage offset         = %08lXH",(long)HeadSize);
 if(headshift)
 {
   twSetColorAttr(dialog_cset.altinfo);
   twPrintF("\nNew EXE header shift = %08lXH",(long)headshift);
   twClrEOL();
 }
 if(addinfo)
 {
   twSetColorAttr(dialog_cset.extrainfo);
   twPrintF("\n%s",addinfo);
   twClrEOL();
 }
 while(1)
 {
   keycode = GetEvent(drawEmptyPrompt,hwnd);
   if(keycode == KE_F(5) || keycode == KE_ENTER) { fpos = newcpos; break; }
   else
     if(keycode == KE_ESCAPE || keycode == KE_F(10)) break;
 }
 CloseWnd(hwnd);
 return fpos;
}

unsigned long ShowSysHeader( void )
{
 int keycode;
 TWindow *hwnd;
 tBool charun;
 long fpos;
 fpos = BMGetCurrFilePos();
 hwnd = CrtDlgWndnls(" DOS Device Driver Header ",57,13);
 charun = (oldh.drv.ddAttribute & 0x8000) == 0x8000;
 if(charun) twPrintF("Device Name               = %8s\n",oldh.drv.ddName);
 else       twPrintF("Device Supports             %u Block Units\n",(unsigned)oldh.drv.ddName[0]);
 twPrintF("Attributes :\n"
          "  [%c]  STDIN\n"
          "  [%c]  STDOUT\n"
          "  [%c]  STDNUL\n"
          "  [%c]  CLOCK\n"
          "  [%c]  Support Logical Device\n"
          "  [%c]  Support OPEN/CLOSE/RM\n"
          "  [%c]  Non IBM Block-Device\n"
          "  [%c]  Support IOCTL\n"
          "  Device is                %s\n"
         ,GetBool(oldh.drv.ddAttribute & 0x0001)
         ,GetBool(oldh.drv.ddAttribute & 0x0002)
         ,GetBool(oldh.drv.ddAttribute & 0x0004)
         ,GetBool(oldh.drv.ddAttribute & 0x0008)
         ,GetBool(oldh.drv.ddAttribute & 0x0040)
         ,GetBool(oldh.drv.ddAttribute & 0x0800)
         ,GetBool(oldh.drv.ddAttribute & 0x2000)
         ,GetBool(oldh.drv.ddAttribute & 0x4000)
         ,(oldh.drv.ddAttribute & 0x8000 ? "CHARACTERS" : "BLOCKS"));
 twSetColorAttr(dialog_cset.entry);
 twPrintF(">STRATEGY routine offset  = %04hXH bytes [Enter]",oldh.drv.ddStrategyOff);
 twClrEOL(); twPrintF("\n");
 twSetColorAttr(dialog_cset.altentry);
 twPrintF(">INTERRUPT routine offset = %04hXH bytes [Ctrl+Enter | F5]",oldh.drv.ddInterruptOff);
 twClrEOL();
 while(1)
 {
   keycode = GetEvent(drawEmptyPrompt,hwnd);
   if(keycode == KE_ENTER) { fpos = oldh.drv.ddStrategyOff; break; }
   else
     if(keycode == KE_CTL_ENTER || keycode == KE_F(5)) { fpos = oldh.drv.ddInterruptOff; break; }
     else
       if(keycode == KE_ESCAPE || keycode == KE_F(10)) break;
 }
 CloseWnd(hwnd);
 return fpos;
}
