/** 
 * @namespace   biew
 * @file        tstrings.c
 * @brief       This file contains start of work for NLS support by BIEW.
 * @version     -
 * @remark      this source file is part of Binary vIEW project (BIEW).
 *              The Binary vIEW (BIEW) is copyright (C) 1995 Nick Kurshev.
 *              All rights reserved. This software is redistributable under the
 *              licence given in the file "Licence.en" ("Licence.ru" in russian
 *              translation) distributed in the BIEW archive.
 * @note        Requires POSIX compatible development system
 *
 * @author      Nick Kurshev
 * @since       1995
 * @note        Development, fixes and improvements
**/
#include "tstrings.h"

/**   English release for all messages */

const char msgAboutText[] =
"          File viewer with built-in\n"
"   Pentium-4/K7-Athlon/Cyrix-M2 disassembler\n"
"   Supports multiple executable structures\n"
"  Written by Nick Kurshev. Kazan. Tatarstan.\n"
"                    Russia.";

const char * BiewPicture[] = {
 "       ",
 "                ",
 "              ",
 "              ",
 "        "
};

const char * CompPicture[] = {
" ",
"              ",
"              ",
"              ",
"              ",
" ",
""
};

const char *MBoardPicture[] =
{
"Ŀ",
"             ",
"           ",
"           ",
"           ",
"             ",
"ٳĿ"
};

const char *ConnectorPicture[] =
{
"Ŀ",
"   ",
"   ",
"   ",
"   ",
"   ",
""
};

const char *BitStreamPicture[] =
{
"01010101",
"10011100",
"00001110",
"01010000",
"11001111",
"11001100",
"10010000"
};

const char *BiewerPicture[] =
{
"",
"             ",
"             ",
"             ",
"             ",
"             ",
""
};

const char *BiewerScreenPicture[] =
{
"pushf        ",
"push    cs   ",
"push    ax   ",
"iret         ",
"int3         ",
};

const char * CompScreenPicture[] = {
"0001001001100",
"1001000101011",
"0110001110000",
"1010010011111",
};

const char * msgTypeComments[] =
{
 " Mode :",
 " [ ] - Put structures    ",
 "  Type of comments:      ",
 " ( ) - None              ",
 " ( ) - NASM (*.asm)      "
};

const char * msgFindOpt[] =
{
 " [ ] - Match Case               ",
 " [ ] - Match Whole Word Only    ",
 " Scan                           "
};
