//
// bidwatcher
// copyright (c) 1999, 2000, 2001
// Trent McNair (trent@rmci.net)
// Tom McNair  (tmcnair@cyberhighway.net)
// Wayne Schlitt (wayne@midwestcs.com)
// Ben Byer (bushing@users.sourceforge.net)
// Kevin Dwyer (kevin@pheared.net)
// 
// use of this code is restricted to the terms
// of the GNU GPL, which should have been included in this
// distribution. If not, see www.gnu.org/copyleft/gpl.html.
// Here is the short version:
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
#ifndef AUCTION_H
#define AUCTION_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

// This is the amount of time before Bidwatcher will give up on
// fetching a web page.  It is fairly common for something to "hang",
// and a the quickest way to get the page loaded is to give up and
// try again.
//
// If this value is too small, then bidwatcher may give up on a
// request that is actually close to finishing.  By giving up too
// early, you end up having to do two requests, which takes more time.
// It is probably better for this to be too large than too small.
//
// If this value is too large, then precious time will can be wasted
// when a snipe is supposed to be executed.
//
// Actually, bidwatcher will detect hung connections quicker than the
// TIMEOUT value.  This is really more of the "maximum" timeout.

#define TIMEOUT 8	// in seconds

#define NORMAL_LOAD_TIME  4	// good for ISDN, ADSL, cable, T1 etc.

#define INITIAL_LOAD_TIME  ( \
    NORMAL_LOAD_TIME		\
    + (20*1024)/(56000/10))   // ms to download a 20k page on 58k modem
    

extern double avg_load_time;

gint secondticker_callback(gpointer data);
gint bigdelay_callback(gpointer data);
gint updatelist_callback(gpointer data);

// other constants
#define HUGEBUFF  (256*1024)
#define MAXAUCS  100
//#define BIGDELAY  (2*60*60*1000)	// in seconds
#define BIGDELAY  (2*60*1000)	// in seconds
#define AUTODEL  (-24*60*60)	// in seconds

#define NUM_CONFIG_TABS 3
#define CONFIG_MAIN 1
#define CONFIG_COLOR 2


// number of items in a static array
#define array_elem(a)	(sizeof(a)/sizeof(a[0]))

struct URL {
  struct hostent * hostinfo;
  unsigned int port;
  char url[256];
  bool useproxy;
  
  URL(char *newurl,URL *proxy);
  void create(char *newurl,URL *proxy);
};


//
// Stucture to store auction information
//
struct auctioninfo {
  unsigned long int  ItemNumber;     /*  Item Number (User Entered)    */
  char Description[129];   /*  Description Of Item For sale  */
  char currency[10];
  float CurrentBid;     /*  1: Current Bid                */
  float FirstBid;       /*  2: First (or starting) Bid    */
  int Quantity;       /*  3: Quantity of Items For Sale */
  int BidCount;       /*  4: Total Number of Bids       */
  char TimeLeft[51];       /*  5: Time Left in Auction       */
  char Location[101];      /*  6: Location of Item           */
  char Started[51];        /*  7: Time when Auction Started  */
  char Ends[51];           /*  8: Time/Data Auction Ends     */
  char Seller[76];         /*  9: User Selling the Item      */
  char HighBidder[76];     /* 10: Current High Bidder        */
  char BidInc[15];         /* 11: Minimum Bid Increment      */
  char SellerRate[15];
  char BidderRate[15];
  float snipeAmount;
  int snipeQty;
  char snipeKey[100];
  float myBidAmount;
  int myBidQuantity;
  long int EndsValue;      // this is the time that the auction ends in seconds.
  char stat;
  char bidstatus;
  char reserveMet;         /* y = met, n = not met, x = no reserve */ 
  bool isSnipe;
  URL *infourl,*bidurl;

  int magic;
  auctioninfo();
  ~auctioninfo();
  int getinfo();
  bool parseaucinfo(char *);
  void getkey(float bid,int quantity);
  int bid(bool);
};

typedef char string30[30];
class ConfigWindow;
class GetPass;
class AboutWindow;
class PopupMenu;
class DetailsWindow;
class BidWindow;

void CmUser();
void CmAddItem();
void CmTimeSync();
void CmUpdate();
void CmHelp();
void CmExit();
void CmCancelClicked();
void doubleClick(int);
void addNewItem(unsigned int);
void timer1Up();
void timer2Up();
void timer3Up();
void timer4Up();
void CmMenu();
void CmDetails();
void CmViewFile();
void CmViewEnded();
void UpdateItem();
void launchBrowser( int choice );
void deleteItem();
void flush();
void setupSnipe(auctioninfo *,int);
void CmBid();
void CmUnBid();
void ClearSnipe(int);
void CmWeb();
void CmEmail(char*);

void            TimeSync();
void            DoSnipe(int);
void            UpdateListItem(int);
void	        UpdateList();
void          ArrangeList();
void	        DeleteAuction(int);
void 	        ReadAucFile();
bool		bigUpdate();
bool            UpdateAll(bool);
int             updateitem(unsigned int);
int		timeToNextEnd();
void            UpdateLatest();
int 	        GetUserBids();
int             GetUserListings();
int             UpdateAuction(auctioninfo *);  
void          WriteLog(int);      
void           WriteAucFile();  	

void            showError(char *arg);
void            showBidStatus(char *arg);
void            showStatus(char *arg);

GdkColor *get_style(struct auctioninfo *);

class BidWindow {
public:
struct auctioninfo * myauc;
GtkWidget *window,*currentbidlabel, *timeleftlabel,
  *bidtext,*bidlabel,*quantitytext,*quantitylabel,
  *okbutton,*cancelbutton,*snipebutton,
  *bidbox,*quantitybox,*radio_bid,*radio_snipe;

BidWindow(struct auctioninfo * auc);
~BidWindow();
};

class DetailsWindow {
public:
struct auctioninfo * myauc;
GtkWidget *window,*categorylabel,*infolabel,*hbox,*currentbidlabel,
  *sellerbutton,*bidderbutton,*cancelbutton;
gint timeouttag;

DetailsWindow(struct auctioninfo * auc);
void fill();
void update();
~DetailsWindow();
};

class EndedWindow {
public:
char issnipes,iscurrent;
GtkWidget *window,*hbox,*textbuffer,*scrollbar,*monthbutton,*monthlabel,*okbutton;

EndedWindow(char snipes,char current);
void update();
~EndedWindow();
};

class AboutWindow {
public:
GtkWidget *window,*aboutlabel,*okbutton;
AboutWindow();
~AboutWindow();
};

class GetPass {
 public:
	GtkWidget *window, *okbutton, *cancelbutton, *missinglabel, 
		*useridlabel, *passlabel, *useridentry, *passentry, 
		*useridbox, *passbox;

	GetPass();
	~GetPass();
};    

class ConfigWindow {
 public:
  GtkWidget *window;
  GtkWidget *notebook, *bookbox[NUM_CONFIG_TABS], *tab_label[NUM_CONFIG_TABS];
  GtkWidget *useridbox, *passwordbox, *browserbox, *emailbox, *proxybox;
  GtkWidget *useridlabel,*useridtext,*passwordlabel,*passwordtext,
	  *browserlabel,*browsertext,*mailclientlabel,*mailclienttext,
	  *proxylabel,*proxytext, *listingcheck, *bidcheck, *startupcheck,
	  *deletecheck, *snipebox, *snipespin, *snipelabel, *okbutton,
	  *cancelbutton, *label_security, *radio_sec_low, *radio_sec_medium,
	  *radio_sec_high, *security_box;

  GtkObject *snipeadj;

  GtkWidget *colorseldlg;
  GtkWidget *color_ended_box, *color_ended_label;

  bool listing,bid,startup,del;

  GtkStyle *color_button_style;
  GtkWidget *color_button;

  ConfigWindow();
  ~ConfigWindow();
};

class ErrorWindow {
public:
GtkWidget *window,*messagelabel, *okbutton;
ErrorWindow(char *message);
~ErrorWindow();
};

class ConfirmWindow {
public:
GtkWidget *window,*messagelabel, *okbutton, *cancelbutton;
ConfirmWindow(char *message);
~ConfirmWindow();
};


float calculateBidIncrement(float currentBid,  char *currency);
char * StripHtmlTags(const char * stringToStrip);
char * StripAndTab(const char * stringToStrip);
int ProcessBidSubmission( char * Buff, char * lineBuff );
int ProcessBid( char * Buff );
int ParseEmailAddress(char * Buff, char * emailAddress);
void encode_password( char *dest, const char *src );
void decode_password( char *dest, const char *src );
long int CalcTimeLeft ( long int endTime, int ebayOffset );
int stringTimeLeft ( long int endTime, int ebayOffset, char * chTimeLeft );
void MakeFileName(char * prefix2, char * fileName, bool thisMonth);
void ClearBidMakeUp(struct auctioninfo * NewAuction) ;
long int CalcEndsValue( char * Ends );
long int CalcTimeLeft ( long int endTime, int ebayOffset );
void MakeClockTime(int offSet, char * theTime);
char * parseRows(const char * fromBuff);
int ParseList( auctioninfo ** TempList, char * Buff);
void strip_commas( char *p );
void translate_date( char *date );
bool GetAucInfo(char *Buff, struct auctioninfo * NewAuction);
int calcTimeDiff ( char * buffer);
int fetchURL(URL *url, char **Buff, double timeOut);
char *stristr(const char *haystack, const char *needle);

extern bool cancelPressed;

extern URL *proxyurl;
extern int numbids;
extern char authID[76];
extern char authPASS[76];
extern struct auctioninfo * auction[MAXAUCS+1];
extern string30 auctionlist[MAXAUCS + 1];


/* so many return codes! */
#define ERROR -1

/* ProcessBidSubmission */
#define PBS_SUCCESS 1
#define PBS_BIDTOOLOW 2
#define PBS_BADQUANTITY 3
#define PBS_AUCTIONOVER 5

/* ProcessBid */
#define PB_HIGHBID 1
#define PB_OUTBID 2
#define PB_BIDTOOLOW 3
#define PB_BADQUANTITY 4
#define PB_AUCTIONOVER 5
#define PB_BADUSER 6

/* ParseEmailAddress */
#define PEA_SUCCESS 1
#define PEA_BADUSER 2

/* Network Functions (i.e. FetchURL) */
// WTF happened here?
#define NET_NETERROR 2
#define NET_TIMEOUT 4
#define NET_USERCANCEL 10
#define NET_SUCCESS 1

/* GetUserAuctions */
#define GUA_BADUSER -2
#define GUA_CGIDOWN -5
#define GUA_TIMEOUT -4
#define GUA_SUCCESS 1
#endif // AUCTION_H

/* Info from auctioninfo::getinfo */
#define INFO_SUCCESS 1
#define INFO_NETERROR NET_NETERROR
#define INFO_BADAUCTION 3
#define INFO_TIMEOUT NET_TIMEOUT
#define INFO_CGIDOWN 5
#define INFO_USERCANCEL NET_USERCANCEL

//#define DEBUG_NETWORK

void getAdultCookie(char *, char *);

// We can make a bunch of these and make cases for all of em.
#define TYPE_EBAY 0
#define TYPE_EBAYMOTORSCAR 1  //Ebay motors auctions that are cars
#define TYPE_EBAYMOTORS 0     //Auctions on motors that aren't cars


// Security levels
#define SEC_LOW  0   // Write everything to file, keep in memory
#define SEC_MED  1   // Write user to file, keep in memory
#define SEC_HIGH 2   // Write nothing to file, keep nothing in memory
