/*********
*
* In the name of the Father, and of the Son, and of the Holy Spirit.
*
* This file is part of BibleTime's source code, http://www.bibletime.info/.
*
* Copyright 1999-2009 by the BibleTime developers.
* The BibleTime source code is licensed under the GNU General Public License
* version 2.0.
*
**********/

#ifndef BTBOOKSHELFDOCKWIDGET_H
#define BTBOOKSHELFDOCKWIDGET_H

#include <QDockWidget>


class CSwordModuleInfo;
class BtBookshelfView;
class BtBookshelfTreeModel;
class BtBookshelfFilterModel;
class QAction;
class QActionGroup;
class QLabel;
class QLineEdit;
class QMenu;
class QToolBar;
class QToolButton;

class BtBookshelfDockWidget: public QDockWidget {
        Q_OBJECT
    public:
        BtBookshelfDockWidget(QWidget *parent = 0, Qt::WindowFlags f = 0);

    signals:
        void moduleOpenTriggered(CSwordModuleInfo *module);
        void moduleSearchTriggered(CSwordModuleInfo *module);
        void moduleEditPlainTriggered(CSwordModuleInfo *module);
        void moduleEditHtmlTriggered(CSwordModuleInfo *module);
        void moduleUnlockTriggered(CSwordModuleInfo *module);
        void moduleAboutTriggered(CSwordModuleInfo *module);

    protected:
        bool eventFilter(QObject *object, QEvent *event);
        void initMenus();
        void retranslateUi();

    protected slots:
        void moduleChecked(CSwordModuleInfo *module, bool checked);
        void showContextMenu(QPoint pos);
        void groupingActionTriggered(QAction *action);
        void showHideEnabled(bool enable);
        void showItemContextMenu(CSwordModuleInfo *module, QPoint pos);
        void itemActionTriggered(QAction *action);

    protected:
        // Models:
        BtBookshelfTreeModel   *m_bookshelfTreeModel;
        BtBookshelfFilterModel *m_filterProxyModel;

        // Widgets:
        QWidget         *m_widget;
        BtBookshelfView *m_view;
        QLabel          *m_nameFilterLabel;
        QLineEdit       *m_nameFilterEdit;
        QToolButton     *m_groupingButton;
        QToolButton     *m_showHideButton;

        // Popup menus:
        QMenu *m_contextMenu;
        QMenu *m_groupingMenu;
        QActionGroup *m_groupingActionGroup;
        QAction *m_groupingCatLangAction;
        QAction *m_groupingCatAction;
        QAction *m_groupingLangCatAction;
        QAction *m_groupingLangAction;
        QAction *m_groupingNoneAction;
        QAction *m_showHideAction;
        QMenu *m_itemContextMenu;
        QActionGroup *m_itemActionGroup;
        QAction *m_itemOpenAction;
        QAction *m_itemSearchAction;
        QMenu   *m_itemEditMenu;
        QAction *m_itemEditPlainAction;
        QAction *m_itemEditHtmlAction;
        QAction *m_itemUnlockAction;
        QAction *m_itemAboutAction;
};

#endif // BTBOOKSHELFDOCKWIDGET_H
