/*
 * Copyright (c) 2005 Jeremy Erickson
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef FILTERSEARCHQUERY_H
#define FILTERSEARCHQUERY_H

#include <searchfilter.h>
#include <list>

namespace bmemcore
{
class FilterSearchAtom;

/**
@author Jeremy Erickson
*/
class FilterSearchQuery : public SearchFilter
{
public:
    enum MatchesType
    {
        MATCHES_ALL,
        MATCHES_ANY
    };
    FilterSearchQuery();

    virtual ~FilterSearchQuery();

    virtual bool allows(const Verse& arg1);
    void setMatches(MatchesType);
    MatchesType getMatches();
    void addAtom(FilterSearchAtom*);
    void removeAtom(FilterSearchAtom*);
    void clearAtoms();
    void setAtoms(const std::list<FilterSearchAtom*>&);
    std::list<FilterSearchAtom*> getAtoms();
private:
    MatchesType mMatches;
    std::list<FilterSearchAtom*> mAtoms;
};

}
#endif
