/*
 * Copyright (c) 2005 Jeremy Erickson
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "filtersearchquery.h"
#include "filtersearchatom.h"
#include <qapplication.h>
#include <list>
#include <algorithm>

namespace bmemcore
{

FilterSearchQuery::FilterSearchQuery()
{}


FilterSearchQuery::~FilterSearchQuery()
{
    //Frees memory used by atoms.
    while (!mAtoms.empty())
    {
        FilterSearchAtom *toDelete = mAtoms.back();
        mAtoms.pop_back();
        delete toDelete;
    }
}


bool FilterSearchQuery::allows(const Verse& verse)
{
    std::list<FilterSearchAtom*>::iterator it = mAtoms.begin();
    while (it != mAtoms.end())
    {
        if ((*it)->allows(verse))
        {
            if (mMatches == MATCHES_ANY)
                return true;
        }
        else
        {
            if (mMatches == MATCHES_ALL)
                return false;
        }
        it++;
    }
    //No deterministic answer above.
    if (mMatches == MATCHES_ANY)
        return false; //Nothing matched to return true.
    else
        return true; //Nothing conflicted to return false.
}

void FilterSearchQuery::setMatches(FilterSearchQuery::MatchesType matches)
{
    mMatches = matches;
}

FilterSearchQuery::MatchesType FilterSearchQuery::getMatches()
{
    return mMatches;
}

void FilterSearchQuery::addAtom(FilterSearchAtom* atom)
{
    mAtoms.push_back(atom);
}

void FilterSearchQuery::removeAtom(FilterSearchAtom* atom)
{
    std::list<FilterSearchAtom*>::iterator it = std::find(mAtoms.begin(),
            mAtoms.end(), atom);
    if (it != mAtoms.end())
        mAtoms.erase(it);
}

void FilterSearchQuery::clearAtoms()
{
    mAtoms.clear();
}

void FilterSearchQuery::setAtoms(const std::list<FilterSearchAtom*>& atoms)
{
    mAtoms = atoms;
}

std::list<FilterSearchAtom*> FilterSearchQuery::getAtoms()
{
    return mAtoms;
}

}

