/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/

#ifndef INCLUDED_XMLFO_UTILS_H
#define INCLUDED_XMLFO_UTILS_H


#include "libraries.h"
#include <glib.h>
#include <gtk/gtk.h>


class XmlFoRoot
{
public:
  XmlFoRoot (vector<ustring> * lines);
  ~XmlFoRoot ();
private:
  vector<ustring> * mylines;
};


class XmlFoLayoutMasterSet
{
public:
  XmlFoLayoutMasterSet (vector<ustring> * lines, bool twocolumns);
  ~XmlFoLayoutMasterSet ();
private:
};


class XmlFoPageSequence
{
public:
  XmlFoPageSequence (vector<ustring> * lines, bool force_even_page_count);
  ~XmlFoPageSequence ();
private:
  vector<ustring> * mylines;
};


class XmlFoStaticContent
{
public:
  XmlFoStaticContent (vector<ustring> * lines);
  ~XmlFoStaticContent ();
private:
};


class XmlFoFlow
{
public:
  XmlFoFlow (vector<ustring> * lines);
  ~XmlFoFlow ();
private:
  vector<ustring> * mylines;
};


class XmlFoBlock
{
public:
  XmlFoBlock (vector<ustring> * lines, double fontsize,
              const ustring& italic_in, const ustring& bold_in, 
              const ustring& underline_in, const ustring& smallcaps_in,
              ustring justification,
              double spacebefore, double spaceafter,
              double leftmargin, double rightmargin,
              double firstlineindent, bool spancolumns);
  ~XmlFoBlock ();
  bool italic;
  bool bold;
  bool underline;
  bool smallcaps;
private:
  vector<ustring> * mylines;
};


ustring XmlFoInlineText (const ustring& line, XmlFoBlock * xmlfoblock, double fontpercentage, const ustring& italic, const ustring& bold, const ustring& underline, const ustring& smallcaps, bool superscript);


#endif
