/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#ifndef INCLUDED_WINDOWSOUTPOST_H
#define INCLUDED_WINDOWSOUTPOST_H


#include "libraries.h"
#include <arpa/inet.h>
#include <netdb.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <stdio.h>


class WindowsOutpost
{
public:
  WindowsOutpost (bool dummy);
  ~WindowsOutpost ();
  void Start ();
  void BibleWorksReferenceSet (const ustring& book, const ustring& chapter, const ustring& verse);
  void SantaFeFocusReferenceSet (const ustring& book, const ustring& chapter, const ustring& verse);
  void SantaFeFocusWordSet (const ustring& word);
private:
  struct sockaddr_in address;
  struct in_addr inaddr;
  struct hostent *host;
  int sock;
  static void thread_start (gpointer data);
  void thread_main ();
  bool thread_run;
  bool thread_running;
  int stage;
  bool connected;
  void clear ();
  void disconnect ();
  void log (const ustring & message);
  ustring last_message;
  void telnet ();
  void send_line (const ustring & command);
  void send_scheduled (ustring& value);
  ustring Readln ();
  ustring bibleworks_reference_set_value;
  ustring santafefocus_reference_set_value;
  ustring santafefocus_word_set_value;
};


void windowsoutpost_open_url (const ustring& url);


#endif
