/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "versification.h"
#include <config.h>
#include "utilities.h"
#include "bible.h"
#include "books.h"


void versification_get_ones_available (vector<ustring>& versifications)
{
  versifications.clear();
  FILE *stream;
  ustring s = "sc-versification --names";
  stream = popen (s.c_str (), "r");
  char buf[1024];
  while (fgets (buf, sizeof (buf), stream)) {
    s = buf;
    s = trim (s);
    versifications.push_back (s);
  }
  pclose (stream);
  sort (versifications.begin(), versifications.end());
}


void versification_create_book_template (const ustring& versification, const ustring& book, vector<ustring>& booktemplate)
{
  // Clear template and add id and running header.
  booktemplate.clear();
  unsigned index = books_english_to_id (book);
  ustring id = books_id_to_paratext (index);
  booktemplate.push_back ("\\id " + id);
  booktemplate.push_back ("\\h " + book);
  // Variables for later use.
  ustring command;
  FILE *stream;
  // Get the number of chapters in the book.
  vector<int> high_verses;
  command = "sc-versification --name " + versification + " --book '" + book + "' --verses";
  stream = popen (command.c_str (), "r");
  char buf[1024];
  while (fgets (buf, sizeof (buf), stream)) {
    high_verses.push_back (convert_to_int (trim(buf)));
  }
  pclose (stream);
  // Add \c and \v information for all chapters.
  for (unsigned int i = 0; i < high_verses.size(); i++) {
    booktemplate.push_back ("\\c " + convert_to_string (int (i) + 1));
    // Some paragraph ought to follow the chapter, so insert it here.
    booktemplate.push_back ("\\p ");
    for (int verse = 1; verse <= high_verses[i]; verse++) {
      booktemplate.push_back ("\\v " + convert_to_string (verse));
    }
  }
}
