/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/

#ifndef INCLUDED_USFM_H
#define INCLUDED_USFM_H

#include "libraries.h"
#include "style.h"


class Usfm
{
  friend class UsfmInlineMarkers;
  friend class XslFoFootnote;
  friend class XslFoEndnote;
  friend class XslFoXref;
  friend class SwordNote;
  friend class EditorNote;
public:
  Usfm (const ustring& stylesheet);
  ~Usfm ();
  bool is_identifier (const ustring& usfm);
  bool is_comment (const ustring& usfm);
  bool is_running_header (const ustring& usfm);
  bool is_starting_paragraph (const ustring& usfm);
  ParagraphType paragraph_get_subtype (const ustring& usfm);
  bool is_inline_text (const ustring& usfm);
  bool is_chapter_number (const ustring& usfm);
  bool is_verse_number (const ustring& usfm);
  double fontsize ();
  int fontpercentage ();
  ustring italic ();
  ustring bold ();
  ustring underline ();
  ustring smallcaps ();
  bool superscript ();
  ustring justification ();
  double spacebefore ();
  double spaceafter ();
  double leftmargin ();
  double rightmargin ();
  double firstlineindent ();
  bool spancolumns ();
private:
  vector<Style> styles;
  ustring last_marker;
  int last_style_pointer;
  int get_style_pointer (const ustring& usfm);
};


bool usfm_is_id (const ustring& marker);
bool usfm_is_chapter (const ustring& marker);
bool usfm_is_verse (const ustring& marker);


#endif
