/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#ifndef INCLUDED_PROJECTUTILS_H
#define INCLUDED_PROJECTUTILS_H


#include "libraries.h"
#include "categorize.h"
#include "sqlite_reader.h"


void projects_initial_check (bool gui);
vector<ustring> projects_get_all ();
ustring project_filename (const ustring& project);
ustring project_book_filename (const ustring& project, const ustring& book);
bool project_exists (const ustring& project);
void project_create (const ustring& project);
void project_delete (const ustring& project);
void project_copy (const ustring& project, const ustring& newproject);
void project_move (const ustring& project, const ustring& newproject);
void project_store_book (const ustring& project, const ustring& book, CategorizeChapterVerse& ccv);
void project_remove_book (const ustring& project, const ustring& book);
void project_store_chapter (const ustring& project, const ustring& book, CategorizeChapterVerse& ccv);
void project_store_verse (const ustring& project, const ustring& book, const ustring& chapter, const ustring& verse, const ustring& data);
void project_update_book (const ustring& project, const ustring& book, unsigned int timestamp);
ustring project_retrieve_verse (const ustring& project, const ustring& book, unsigned int chapter, const ustring& verse);
vector<ustring> project_retrieve_chapter (const ustring& project, const ustring& book, unsigned int chapter);
vector<ustring> project_retrieve_book (const ustring& project, const ustring& book);
unsigned int project_retrieve_timestamp (const ustring& project);
void project_link_book (const ustring& project, const ustring& book, const ustring& file);

class ProjectLinksGet
{
public:
  ProjectLinksGet (const ustring& project);
  vector<ustring> books;
  vector<bool> updateds;
  vector<ustring> filenames;
  vector<unsigned int> filetimes;
  vector<unsigned int> filesizes;
private:
};

vector<ustring> project_get_books (const ustring& project);
vector<unsigned int> project_get_chapters (const ustring& project, const ustring& book);
vector<ustring> project_get_verses (const ustring& project, const ustring& book, unsigned int chapter);
bool project_book_exists (const ustring& project, const ustring& book);
void project_vacuum (const ustring& project, unsigned int starttime);


#endif
