/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "listview.h"
#include "utilities.h"


ustring listview_get_active_string (GtkWidget * listview)
// Gets the currently active string in a combobox.
{
  // Storage for result
  ustring active_string;
  // Get the model
  GtkTreeModel * model;
  model = gtk_tree_view_get_model (GTK_TREE_VIEW (listview));
  // Get the selection.
  GtkTreeSelection * selection;
  selection = gtk_tree_view_get_selection (GTK_TREE_VIEW (listview));
  // Some variables needed.
  GtkTreeIter iter;
  // Get the selected iterator.
  if (gtk_tree_selection_get_selected (selection, &model, &iter)) {
    gchar *str_data;
    // Make sure you terminate calls to gtk_tree_model_get() with a '-1' value.
    gtk_tree_model_get (model, &iter, 0, &str_data, -1);
    active_string = str_data;
    g_free (str_data);
  }
  // Return result.
  return active_string;
}


void listview_clear_strings (GtkWidget * listview, GtkListStore * store)
// Clear the strings loaded in the combobox.
{
  gtk_list_store_clear (store);
}


void listview_set_strings (GtkWidget * listview, GtkListStore * store, const vector<ustring>& strings)
{
  // Clear store.
  listview_clear_strings (listview, store);
  // Load new data.
  GtkTreeIter iter;
  for (unsigned int i = 0; i < strings.size(); i++) {
    gtk_list_store_append (store, &iter);
    gtk_list_store_set (store, &iter, 0, strings[i].c_str (), -1);
  }
}


void listview_set_strings (GtkWidget * listview, GtkListStore * store, const vector<unsigned int>& strings)
{
  // Clear store.
  listview_clear_strings (listview, store);
  // Load new data.
  GtkTreeIter iter;
  for (unsigned int i = 0; i < strings.size(); i++) {
    gtk_list_store_append (store, &iter);
    gtk_list_store_set (store, &iter, 0, convert_to_string ((int)strings[i]).c_str (), -1);
  }
}


void listview_focus_string (GtkWidget * listview, const ustring& string)
// Sets the string that is focused and scrolls to it.
{
  // Get the model
  GtkTreeModel * model;
  model = gtk_tree_view_get_model (GTK_TREE_VIEW (listview));
  // Get the selection.
  GtkTreeSelection * selection;
  selection = gtk_tree_view_get_selection (GTK_TREE_VIEW (listview));
  // Some variables needed.
  GtkTreeIter iter;
  gboolean valid;
  gint index = 0;
  // Get the first iter in the store.
  valid = gtk_tree_model_get_iter_first (model, &iter);
  while (valid) {
    // Walk through the list, reading each row
    gchar *str_data;
    // Make sure you terminate calls to gtk_tree_model_get() with a '-1' value.
    gtk_tree_model_get (model, &iter, 0, &str_data, -1);
    // If this is the marker we wish to display, select it, put the cursor on it,
    // and focus on the listview.
    if (str_data == string) {
      gtk_tree_selection_select_iter (selection, &iter);
      GtkTreePath * path = NULL;
      path = gtk_tree_path_new_from_indices (index, -1);
      if (path) {
        gtk_tree_view_set_cursor (GTK_TREE_VIEW (listview), path, NULL, false);
        gtk_tree_view_scroll_to_cell (GTK_TREE_VIEW (listview), path, NULL, true, 0.5, 0.5);
      }
      gtk_tree_path_free (path);
      gtk_widget_grab_focus (listview);
    }
    g_free (str_data);
    valid = gtk_tree_model_iter_next (model, &iter);
    index++;
  }
}


vector <ustring> listview_get_strings (GtkWidget * listview)
// Gets the strings loaded in the listview.
{
  // Storage for the result.
  vector <ustring> strings;
  // Get the model
  GtkTreeModel * model;
  model = gtk_tree_view_get_model (GTK_TREE_VIEW (listview));
  // Some variables needed.
  GtkTreeIter iter;
  gboolean valid;
  // Get the first iter in the store.
  valid = gtk_tree_model_get_iter_first (model, &iter);
  while (valid) {
    // Walk through the list, reading each row
    gchar *str_data;
    // Make sure you terminate calls to gtk_tree_model_get() with a '-1' value.
    gtk_tree_model_get (model, &iter, 0, &str_data, -1);
    // Store.
    strings.push_back (str_data);
    // Free memory and go to next.
    g_free (str_data);
    valid = gtk_tree_model_iter_next (model, &iter);
  }
  // Return the results.
  return strings;
}
