/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "editorobject.h"


EditorObject::EditorObject (EditorObjectType type_in)
{
  type = type_in;
}


void EditorObject::clear ()
{
  type = eotNone;
  s1.clear();
  s2.clear();
  s3.clear();
}


void EditorObject::note_set (ustring& opener, ustring& caller, ustring& closer)
{
  s1 = opener;
  s2 = caller;
  s3 = closer;
}


void EditorObject::note_get (ustring& opener, ustring& caller, ustring& closer)
{
  opener = s1;
  caller = s2;
  closer = s3;
}
