/* Anti-Web HTTPD */
/* Hardcore Software */
/*
This software is Copyright (C) 2001-2004 By Hardcore Software and
others. The software is distributed under the terms of the GNU General
Public License. See the file 'COPYING' for more details.
*/


#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <signal.h>
#include <unistd.h>
#include <stdlib.h>

#include "aw3.h"


// GLOBALS
struct serverstruct *servers;
struct connstruct *usedconns;
struct connstruct *freeconns;
struct cgiextstruct *cgiexts;
struct indexstruct *indexlist;



void initlists() {
  int i;
  struct connstruct *tp;

  servers = NULL;
  usedconns = NULL;
  freeconns = NULL;
  cgiexts = NULL;
  indexlist = NULL;

  for(i=0; i<INITIAL_CONNECTION_SLOTS; i++) {
    tp = freeconns;
    freeconns = (struct connstruct *) malloc(sizeof(struct connstruct));
    if (freeconns == NULL) {
      fprintf(stderr, "Not enough memory to allocate %d connection slots!\n",
              INITIAL_CONNECTION_SLOTS);
      exit(-1);
    }
    freeconns->next = tp;
  }
}


void usage(char *cmline) {
  fprintf(stderr, "Anti-Web V%s  (C) 2001-2004 by Hardcore Software and others\n\n", VERSION);

  fprintf(stderr, "  AW has 2 valid command lines (see README for details)\n\n");

  fprintf(stderr, "  %s <dir> <port>\n", cmline);
  fprintf(stderr, "     <dir>                 The root of your HTML tree\n");
  fprintf(stderr, "     <port>                The port to use\n\n");

  fprintf(stderr, "  %s <dir>\n", cmline);
  fprintf(stderr, "     <dir>/awhttpd.conf    Conf file\n");
  fprintf(stderr, "     <dir>/default/        Default HTML root\n");
  fprintf(stderr, "     <dir>/example.com/    Zero or more virtual host directories\n");

  exit(1);
}


int main(int argc, char *argv[]) {

  char buf[MAXREQUESTLENGTH];
  int pid, tp;

  initlists();

  if (argc != 2 && argc != 3) usage(argv[0]);

  webroot = strdup(argv[1]);

  tp = strlen(webroot);
  if (webroot[tp-1] == '/') webroot[tp-1] = '\0';

  if (isdir(webroot) == 0) {
    fprintf(stderr, "'%s' is not a directory\n", webroot);
    exit(1);
  }

  defaultconfvals();

  if (argc == 2) {
    snprintf(buf, sizeof(buf), "%s/awhttpd.conf", webroot);
    procconf(buf);
  } else {
    if ((tp=openlistener(atoi(argv[2]))) == -1) {
      fprintf(stderr, "ERR: Couldn't bind to port %d (IPv4)\n", atoi(argv[2]));
      exit(0);
    }

    addindex("index.html");
    addtoservers(tp);
    setgid(32767);
    setuid(32767);
  }

  if (permcheck == 1) procpermcheck(webroot);

  pid = fork();

  if(pid > 0) {
    status();
    exit(0);
  } else if(pid == -1) {
    fprintf(stderr,"Anti-Web: Sorry, fork failed... Tough dice.\n");
    exit(1);
  }

  setsid();

  /* SIGNALS */
  signal(SIGINT, die);
  signal(SIGQUIT, die);
  signal(SIGTERM, die);

  #ifndef SOLARIS
  signal(SIGPIPE, nada);
  #endif

  #ifdef SOLARIS
  act.sa_handler = nada;
  sigemptyset(&act.sa_mask);
  act.sa_flags = SA_RESTART;

  sigaction(SIGPIPE,&act,NULL);
  #endif

  selectloop();

  return 0;

}
