/* Anti-Web HTTPD */
/* Hardcore Software */
/*
This software is Copyright (C) 2001-2004 By Hardcore Software and
others. The software is distributed under the terms of the GNU General
Public License. See the file 'COPYING' for more details.
*/


#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <time.h>
#include <stdlib.h>

#include "aw3.h"



void addconnection(int sd, char *ip) {
  struct connstruct *tp;

  // Get ourselves a connstruct
  if (freeconns == NULL) {
    tp = (struct connstruct *) malloc(sizeof(struct connstruct));
    if (tp == NULL) {
      send505(sd, "Out of memory");
      // removeconnection() should be used normally
      close(sd);
      return;
    }
  } else {
    tp = freeconns;
    freeconns = tp->next;
  }

  // Attach it to the used list
  tp->next = usedconns;
  usedconns = tp;

  tp->networkdesc = sd;
  tp->filedesc = -1;
  tp->dirp = NULL;

  *(tp->actualfile) = '\0';
  *(tp->filereq) = '\0';
  *(tp->cgiargs) = '\0';
  *(tp->virtualhostreq) = '\0';

  tp->state = STATE_WANT_TO_READ_HEAD;
  tp->reqtype = TYPE_GET;

  strncpy(tp->ip, ip, MAXIPLEN);

  tp->offset = -1;

  numusers++;

  updatetimeout(tp, time(NULL));

  return;

}



// Remove cn from the used list
// FIXME: This O(N) operation could be avoided if we used
//        doubly linked lists...
void removeconnection(struct connstruct *cn) {

  struct connstruct *tp;
  int shouldret=0;

  tp = usedconns;

  if (tp == NULL || cn == NULL) shouldret=1;
  else if (tp == cn) usedconns = tp->next;
  else {
    while(tp != NULL) {
      if (tp->next == cn) {
        tp->next = (tp->next)->next;
        shouldret=0;
        break;
      }
      tp = tp->next;
      shouldret=1;
    }
  }

  if (shouldret) return;

  // If we did, add it to the free list
  cn->next = freeconns;
  freeconns = cn;

  // Close it all down
  if (cn->networkdesc != -1) close(cn->networkdesc);
  if (cn->filedesc != -1) close(cn->filedesc);
  if (cn->dirp != NULL) closedir(cn->dirp);

  numusers--;

  return;

}
