/*
Copyright 2010, 2012, 2014 Jose Robson Mariano Alves

This file is part of bgfinancas.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This package is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*/

package PreRelatorios;

import Biblioteca.Botoes;
import Biblioteca.Calendario;
import Biblioteca.JanelaModal;
import Biblioteca.Janelinha;
import Biblioteca.Visual;
import Relatorios.RReceitasItens;
import java.text.ParseException;

public class PreReceitasItens extends JanelaModal {

    private final RReceitasItens Relatorio = new RReceitasItens();

    public PreReceitasItens(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        Visual.JanelaModal(this.getJanela());
        BarraDeFerramentas.add(Botoes.Sair(this));
    }

    @Override
    public void Botoes(String acao)
    {
        if(acao.equals(Lingua.getMensagem("sair")))
        {
            PreReceitasItens.this.dispose();
        }
    }

    public void ReceitasItens() throws ParseException
    {
        String DataInicial = data_inicial.getSelectedItem().toString();
        String tmp[] = DataInicial.split("/");
        DataInicial = tmp[2]+"-"+tmp[1]+"-"+tmp[0];
        String DataFinal = data_final.getSelectedItem().toString();
        String tmp2[] = DataFinal.split("/");
        DataFinal = tmp2[2]+"-"+tmp2[1]+"-"+tmp2[0];
        Relatorio.RReceitasItens(DataInicial,DataFinal,(String)ordenar.getSelectedItem());
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        BarraDeFerramentas = new javax.swing.JToolBar();
        INICIO = new javax.swing.JLabel();
        BFiltrar = new javax.swing.JButton();
        TEXTO = new javax.swing.JLabel();
        INICIO1 = new javax.swing.JLabel();
        ordenar = new javax.swing.JComboBox();
        INICIO2 = new javax.swing.JLabel();
        data_inicial = new Calendario(true);
        data_final = new Calendario(true);

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle(Lingua.getMensagem("receitas")+" > "+Lingua.getMensagem("periodo_item"));
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        getContentPane().setLayout(null);

        BarraDeFerramentas.setFloatable(false);
        BarraDeFerramentas.setRollover(true);
        getContentPane().add(BarraDeFerramentas);
        BarraDeFerramentas.setBounds(0, 0, 500, 41);

        INICIO.setFont(FonteFinancas);
        INICIO.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        INICIO.setText(Lingua.getMensagem("ordenar_por")+":");
        getContentPane().add(INICIO);
        INICIO.setBounds(30, 160, 130, 20);

        BFiltrar.setFont(FonteFinancas);
        BFiltrar.setText(Lingua.getMensagem("gerar"));
        BFiltrar.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                BFiltrarActionPerformed(evt);
            }
        });
        getContentPane().add(BFiltrar);
        BFiltrar.setBounds(170, 190, 110, 20);

        TEXTO.setFont(FonteFinancasPequena);
        TEXTO.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        TEXTO.setText(Lingua.getMensagem("mensagem_relatorio")+":");
        getContentPane().add(TEXTO);
        TEXTO.setBounds(0, 56, 380, 20);

        INICIO1.setFont(FonteFinancas);
        INICIO1.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        INICIO1.setText(Lingua.getMensagem("inicio")+":");
        getContentPane().add(INICIO1);
        INICIO1.setBounds(30, 100, 130, 20);

        ordenar.setFont(FonteFinancas);
        ordenar.setModel(new javax.swing.DefaultComboBoxModel(new String[] { Lingua.getMensagem("item"), Lingua.getMensagem("categoria"), Lingua.getMensagem("valor") }));
        getContentPane().add(ordenar);
        ordenar.setBounds(170, 160, 110, 20);

        INICIO2.setFont(FonteFinancas);
        INICIO2.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        INICIO2.setText(Lingua.getMensagem("fim")+":");
        getContentPane().add(INICIO2);
        INICIO2.setBounds(30, 130, 130, 20);

        data_inicial.setFont(FonteFinancas);
        getContentPane().add(data_inicial);
        data_inicial.setBounds(170, 100, 110, 20);

        data_final.setFont(FonteFinancas);
        getContentPane().add(data_final);
        data_final.setBounds(170, 130, 110, 20);

        setSize(new java.awt.Dimension(386, 288));
        setLocationRelativeTo(null);
    }// </editor-fold>//GEN-END:initComponents

    private void BFiltrarActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_BFiltrarActionPerformed
        try {
            ReceitasItens();
        } catch (ParseException ex) {
            Janelinha.Aviso((Lingua.getMensagem("erro")), Lingua.getMensagem("excecao")+" "+ex.getMessage());
        }
}//GEN-LAST:event_BFiltrarActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton BFiltrar;
    private javax.swing.JToolBar BarraDeFerramentas;
    private javax.swing.JLabel INICIO;
    private javax.swing.JLabel INICIO1;
    private javax.swing.JLabel INICIO2;
    private javax.swing.JLabel TEXTO;
    private javax.swing.JComboBox data_final;
    private javax.swing.JComboBox data_inicial;
    private javax.swing.JComboBox ordenar;
    // End of variables declaration//GEN-END:variables

}
